{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE RecordWildCards #-}

import qualified Data.ByteString.Char8
import qualified Jsonifier as J

-- |
-- Outputs the following:
--
-- > {"name":"Metallica","genres":[{"name":"Metal"},{"name":"Rock"},{"name":"Blues"}]}
main =
  Data.ByteString.Char8.putStrLn (J.toByteString (artistJson metallica))

metallica :: Artist
metallica =
  Artist "Metallica" [Genre "Metal", Genre "Rock", Genre "Blues"]

-- * Model

-------------------------

data Artist = Artist {artistName :: Text, artistGenres :: [Genre]}

data Genre = Genre {genreName :: Text}

-- * Encoders

-------------------------

artistJson :: Artist -> J.Json
artistJson Artist {..} =
  J.object
    [ ("name", J.textString artistName),
      ("genres", J.array (fmap genreJson artistGenres))
    ]

genreJson :: Genre -> J.Json
genreJson Genre {..} =
  J.object
    [ ("name", J.textString genreName)
    ]
