-- Do not edit! Automatically created with doctest-extract from src/UniqueLogic.hs
{-# LINE 23 "src/UniqueLogic.hs" #-}

module Test.UniqueLogic where

import UniqueLogic
import Test.DocTest.Base
import qualified Test.DocTest.Driver as DocTest

{-# LINE 24 "src/UniqueLogic.hs" #-}
import     qualified Data.Array.Comfort.Boxed as BoxedArray
import     qualified Data.Array.Comfort.Shape as Shape
import     qualified Data.Map as Map
import     Common

test :: DocTest.T ()
test = do
 DocTest.printPrefix "UniqueLogic:56: "
{-# LINE 56 "src/UniqueLogic.hs" #-}
 DocTest.example(
{-# LINE 56 "src/UniqueLogic.hs" #-}
    solve 3 $ Map.fromList [((0,0),1), ((1,0),1), ((2,0),1::Integer)]
  )
  [ExpectedLine [LineChunk "BoxedArray",WildCardChunk,LineChunk "Triangular",WildCardChunk,LineChunk " 3",WildCardChunk,LineChunk " [Just 1,Just 1,Just 0,Just 1,Just 0,Just 0]"]]
 DocTest.printPrefix "UniqueLogic:59: "
{-# LINE 59 "src/UniqueLogic.hs" #-}
 DocTest.example(
{-# LINE 59 "src/UniqueLogic.hs" #-}
    solve 3 $ Map.fromList [((0,0),1), ((2,0),1), ((2,2),1::Integer)]
  )
  [ExpectedLine [LineChunk "BoxedArray",WildCardChunk,LineChunk "Triangular",WildCardChunk,LineChunk " 3",WildCardChunk,LineChunk " [Just 1,Nothing,Nothing,Just 1,Nothing,Just 1]"]]
 DocTest.printPrefix "UniqueLogic:79: "
{-# LINE 79 "src/UniqueLogic.hs" #-}
 DocTest.example(
{-# LINE 79 "src/UniqueLogic.hs" #-}
    solveMixed (BoxedArray.fromList (Shape.lowerTriangular $ ShapeOp 2) [Mul]) (Map.fromList [((0,0),0), ((1,1),0::Rational)])
  )
  [ExpectedLine [LineChunk "BoxedArray",WildCardChunk,LineChunk "Triangular",WildCardChunk,LineChunk " 2",WildCardChunk,LineChunk " [Just (0 % 1),Nothing,Just (0 % 1)]"]]
 DocTest.printPrefix "UniqueLogic:81: "
{-# LINE 81 "src/UniqueLogic.hs" #-}
 DocTest.example(
{-# LINE 81 "src/UniqueLogic.hs" #-}
    solveMixed (BoxedArray.fromList (Shape.lowerTriangular $ ShapeOp 2) [Mul]) (Map.fromList [((0,0),0), ((1,1),5::Rational)])
  )
  [ExpectedLine [LineChunk "BoxedArray",WildCardChunk,LineChunk "Triangular",WildCardChunk,LineChunk " 2",WildCardChunk,LineChunk " [Just (0 % 1),Just (0 % 1),Just (5 % 1)]"]]
 DocTest.printPrefix "UniqueLogic:108: "
{-# LINE 108 "src/UniqueLogic.hs" #-}
 DocTest.example(
{-# LINE 108 "src/UniqueLogic.hs" #-}
    map (length . solvables) [0..5]
  )
  [ExpectedLine [LineChunk "[1,1,3,16,122,1188]"]]
