{-# LANGUAGE TypeFamilies #-}
module Common where

import qualified Data.Array.Comfort.Boxed as BoxedArray
import qualified Data.Array.Comfort.Shape as Shape
import qualified Data.Set as Set
import Data.Array.Comfort.Boxed (Array)
import Data.Map (Map)
import Data.Set (Set)

import qualified Combinatorics



data Op = Add | Mul
   deriving (Eq, Ord, Enum, Show)

newtype ShapeOp = ShapeOp {shapeOpSize :: Int}

instance Shape.C ShapeOp where
   size (ShapeOp n) = max 0 $ n-1

instance Shape.Indexed ShapeOp where
   type Index ShapeOp = Int
   indices sh = take (Shape.size sh) [0..]
   unifiedOffset sh = Shape.unifiedOffset (Shape.ZeroBased (Shape.size sh))


sizeFromOps :: Array (Shape.LowerTriangular ShapeOp) op -> Int
sizeFromOps = shapeOpSize . Shape.triangularSize . BoxedArray.shape


type ShapeInt = Shape.ZeroBased Int


type SolutionCheck a =
      BoxedArray.Array (Shape.LowerTriangular ShapeOp) Op ->
      Map (Int,Int) a ->
      Bool


allCellSelections :: Int -> [Set (Int, Int)]
allCellSelections n =
   map Set.fromList $ Combinatorics.tuples n $ Shape.indices $
   Shape.lowerTriangular $ Shape.ZeroBased n
