/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Capabilities;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.SimpleNode;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;

public class TargetError
extends EvalError {
    Throwable target;
    boolean inNativeCode;

    public TargetError(String string, Throwable throwable, SimpleNode simpleNode, boolean bl) {
        super(string, simpleNode);
        this.target = throwable;
        this.inNativeCode = bl;
    }

    public TargetError(Throwable throwable, SimpleNode simpleNode) {
        this("TargetError", throwable, simpleNode, false);
    }

    public TargetError(String string, Throwable throwable) {
        this(string, throwable, null, false);
    }

    public Throwable getTarget() {
        if (this.target instanceof InvocationTargetException) {
            return ((InvocationTargetException)this.target).getTargetException();
        }
        return this.target;
    }

    public String toString() {
        return super.toString() + "\nTarget exception: " + this.printTargetError(this.target);
    }

    public void printStackTrace() {
        this.printStackTrace(false, System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        this.printStackTrace(false, printStream);
    }

    public void printStackTrace(boolean bl, PrintStream printStream) {
        if (bl) {
            super.printStackTrace(printStream);
            System.out.println("--- Target Stack Trace ---");
        }
        this.target.printStackTrace(printStream);
    }

    public String printTargetError(Throwable throwable) {
        String string = this.target.toString();
        if (Capabilities.canGenerateInterfaces()) {
            string = string + "\n" + this.xPrintTargetError(throwable);
        }
        return string;
    }

    public String xPrintTargetError(Throwable throwable) {
        String string = "import java.lang.reflect.UndeclaredThrowableException;if ( target instanceof UndeclaredThrowableException )\treturn target.getUndeclaredThrowable().toString();else return \"\"";
        Interpreter interpreter = new Interpreter();
        try {
            interpreter.set("target", throwable);
            return (String)interpreter.eval(string);
        }
        catch (EvalError evalError) {
            throw new InterpreterError("xprintarget: " + evalError.toString());
        }
    }

    public boolean inNativeCode() {
        return this.inNativeCode;
    }
}

