/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHMethodDeclaration;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;
import java.io.Serializable;

public class BshMethod
implements Serializable {
    BSHMethodDeclaration method;
    Modifiers modifiers;
    NameSpace declaringNameSpace;
    private Class[] argTypes;

    BshMethod(BSHMethodDeclaration bSHMethodDeclaration, NameSpace nameSpace, Modifiers modifiers) {
        this.method = bSHMethodDeclaration;
        this.declaringNameSpace = nameSpace;
        this.modifiers = modifiers;
    }

    public Class[] getArgTypes() {
        return this.getArgumentTypes();
    }

    public Class[] getArgumentTypes() {
        if (this.argTypes == null) {
            this.argTypes = this.method.params.argTypes;
        }
        return this.argTypes;
    }

    public Object getReturnType() {
        return this.method.returnType;
    }

    public String getName() {
        return this.method.name;
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter) throws EvalError {
        return this.invoke(objectArray, interpreter, null, null);
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack) throws EvalError {
        return this.invoke(objectArray, interpreter, callStack, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        if (this.modifiers != null && this.modifiers.hasModifier("synchronized")) {
            This this_;
            This this_2 = this_ = this.declaringNameSpace.getThis(interpreter);
            synchronized (this_2) {
                return this.invokeImpl(objectArray, interpreter, callStack, simpleNode);
            }
        }
        return this.invokeImpl(objectArray, interpreter, callStack, simpleNode);
    }

    private Object invokeImpl(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        if (callStack == null) {
            callStack = new CallStack(this.declaringNameSpace);
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray.length != this.method.params.numArgs) {
            throw new EvalError("Wrong number of arguments for local method: " + this.method.name, simpleNode, callStack);
        }
        NameSpace nameSpace = new NameSpace(this.declaringNameSpace, this.method.name);
        nameSpace.setNode(simpleNode);
        nameSpace.isMethod = true;
        int n = 0;
        while (n < this.method.params.numArgs) {
            if (this.method.params.argTypes[n] != null) {
                try {
                    objectArray[n] = NameSpace.getAssignableForm(objectArray[n], this.method.params.argTypes[n]);
                }
                catch (UtilEvalError utilEvalError) {
                    throw new EvalError("Invalid argument: `" + this.method.params.argNames[n] + "'" + " for method: " + this.method.name + " : " + utilEvalError.getMessage(), simpleNode, callStack);
                }
                try {
                    nameSpace.setTypedVariable(this.method.params.argNames[n], this.method.params.argTypes[n], objectArray[n], false);
                }
                catch (UtilEvalError utilEvalError) {
                    throw utilEvalError.toEvalError("Typed method parameter assignment", simpleNode, callStack);
                }
            }
            if (objectArray[n] == Primitive.VOID) {
                throw new EvalError("Undefined variable or class name, parameter: " + this.method.params.argNames[n] + " to method: " + this.method.name, simpleNode, callStack);
            }
            try {
                nameSpace.setLocalVariable(this.method.params.argNames[n], objectArray[n], interpreter.getStrictJava());
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError(simpleNode, callStack);
            }
            ++n;
        }
        callStack.push(nameSpace);
        Object object = this.method.block.eval(callStack, interpreter, true);
        CallStack callStack2 = callStack.copy();
        callStack.pop();
        ReturnControl returnControl = null;
        if (object instanceof ReturnControl) {
            returnControl = (ReturnControl)object;
            if (returnControl.kind != 42) {
                throw new EvalError("continue or break in method body", returnControl.returnPoint, callStack2);
            }
            object = ((ReturnControl)object).value;
            if (this.method.returnType == Primitive.VOID && object != Primitive.VOID) {
                throw new EvalError("Cannot return value from void method", returnControl.returnPoint, callStack2);
            }
        }
        if (this.method.returnType != null) {
            if (this.method.returnType == Primitive.VOID) {
                return Primitive.VOID;
            }
            try {
                object = NameSpace.getAssignableForm(object, (Class)this.method.returnType);
            }
            catch (UtilEvalError utilEvalError) {
                SimpleNode simpleNode2 = simpleNode;
                if (returnControl != null) {
                    simpleNode2 = returnControl.returnPoint;
                }
                throw utilEvalError.toEvalError("Incorrect type returned from method: " + this.method.name + utilEvalError.getMessage(), simpleNode2, callStack);
            }
        }
        return object;
    }

    public String toString() {
        return "Scripted Method: " + StringUtil.methodString(this.method.name, this.getArgumentTypes());
    }
}

