# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


def generate_content() -> str:
    # [START googlegenaisdk_tools_enterprise_web_search_with_txt]
    from google import genai
    from google.genai.types import (
        EnterpriseWebSearch,
        GenerateContentConfig,
        HttpOptions,
        Tool,
    )

    client = genai.Client(http_options=HttpOptions(api_version="v1"))

    response = client.models.generate_content(
        model="gemini-2.5-flash",
        contents="When is the next total solar eclipse in the United States?",
        config=GenerateContentConfig(
            tools=[
                # Use Enterprise Web Search Tool
                Tool(enterprise_web_search=EnterpriseWebSearch())
            ],
        ),
    )

    print(response.text)
    # Example response:
    # 'The next total solar eclipse in the United States will occur on ...'
    # [END googlegenaisdk_tools_enterprise_web_search_with_txt]
    return response.text


if __name__ == "__main__":
    generate_content()
