# Publications

A list of publications closely related to RetDec, grouped by year.

## 2018

* J. Křoustek, P. Matula: RetDec: An Open-Source Machine-Code Decompiler [talk]. Pass the SALT 2018, Lille, France, July 2, 2018 ([WWW](https://2018.pass-the-salt.org/schedule/#retdec), [PDF](data/retdec-slides-salt-2018.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_SALT_18,
            author = {J. K\v{r}oustek and P. Matula},
            title = {RetDec: An Open-Source Machine-Code Decompiler},
            year = {2018},
            month = {July},
            howpublished = {[talk]},
            note = {Presented at Pass the SALT 2018, Lille, FR}
        }
        ```
      </p>
      </details>
* P. Matula, M. Milkovič: An Open-Source Machine-Code Decompiler [talk]. RECon 2018, Montreal, CA, June 16, 2018 ([WWW](https://recon.cx/2018/montreal/schedule/events/112.html), [PDF](data/retdec-slides-recon-2018.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_RECON_18,
            author = {P. Matula and M. Milkovi\v{c}},
            title = {An Open-Source Machine-Code Decompiler},
            year = {2018},
            month = {June},
            howpublished = {[talk]},
            note = {Presented at RECon 2018, Montreal, CA}
        }
        ```
      </p>
      </details>

## 2017

* J. Křoustek, P. Matula, P. Zemek: RetDec: An Open-Source Machine-Code Decompiler [talk]. Botconf 2017, Montpellier, FR, December 6, 2017 ([WWW](https://botconf2017.sched.com/event/CtGx/retdec-an-open-source-machine-code-decompiler), [PDF](data/retdec-slides-botconf-2017.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_BOTCONF_17,
            author = {J. K\\v{r}oustek and P. Matula and P. Zemek},
            title = {RetDec: An Open-Source Machine-Code Decompiler},
            year = {2017},
            month = {December},
            howpublished = {[talk]},
            note = {Presented at Botconf 2017, Montpellier, FR}
        }
        ```
      </p>
      </details>

## 2015

* J. Křoustek: Weather Forecast for Today? Advert Flood Coming from East [online]. AVG Blog, October 5, 2015 ([WWW](http://now.avg.com/weather-forecast-for-today-advert-flood-coming-from-east/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG07_15,
            author = {J. K\\v{r}oustek},
            title = {Weather Forecast for Today? Advert Flood Coming from East},
            year = {2015},
            month = {October},
            howpublished = {[online]},
            note = {Available on \url{http://now.avg.com/weather-forecast-for-today-advert-flood-coming-from-east/}}
        }
        ```
      </p>
      </details>
* J. Křoustek: Retargetable Analysis of Machine Code. Ph.D. Thesis, FIT BUT, Brno, CZ, 2015, pp. 190 ([WWW](http://www.fit.vutbr.cz/study/DP/PD.php?id=482&y=2015), [PDF](http://www.fit.vutbr.cz/study/DP/PD.php?id=482&file=t))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_KROUSTEK_PHD_15,
            author = {J. K\\v{r}oustek},
            title = {Retargetable Analysis of Machine Code},
            school = {Faculty of Information Technology, Brno University of Technology, CZ},
            pages = {190},
            year = {2015}
        }
        ```
      </p>
      </details>
* J. Křoustek: On Decompilation of VLIW Executable Files, In: Scientific Journal Problems in Programming, Vol. 16, No. 1, 2015, Kyiv, UA, pp. 29-37
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_SJPP_15,
            author = {J. K\\v{r}oustek},
            title = {On Decompilation of {VLIW} Executable Files},
            journal = {Scientific Journal Problems in Programming},
            volume = {16},
            number = {1},
            pages = {29--37},
            year = {2015}
        }
        ```
      </p>
      </details>
* J. Křoustek: Analysis of Banking Trojan Vawtrak (White Paper) [online]. AVG Blog, March 24, 2015 ([WWW](http://now.avg.com/banking-trojan-vawtrak-harvesting-passwords-worldwide/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG06_15,
            author = {J. K\\v{r}oustek},
            title = {Analysis of Banking Trojan Vawtrak (White Paper)},
            year = {2015},
            month = {March},
            howpublished = {[online]},
            note = {Available on \url{http://now.avg.com/banking-trojan-vawtrak-harvesting-passwords-worldwide/}}
        }
        ```
      </p>
      </details>

## 2014

* L. Ďurfina, J. Křoustek, P. Matula, P. Zemek: A Novel Approach to Online Retargetable Machine-Code Decompilation. In: Journal of Network and Innovative Computing, Vol. 2, No. 1, 2014, US, pp. 224-232 ([PDF](http://www.mirlabs.net/jnic/secured/Volume2-Issue1/Paper24/JNIC_Paper24.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_JNIC_14,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Matula and P. Zemek},
            title = {A Novel Approach to Online Retargetable Machine-Code Decompilation},
            journal = {Journal of Network and Innovative Computing},
            volume = {2},
            number = {1},
            pages = {224--232},
            year = {2014}
        }
        ```
      </p>
      </details>
* J. Křoustek: Pay the debt! – Malware Campaign Hits the Czech Republic [online]. AVG Blog, June 27, 2014 ([WWW](http://blogs.avg.com/news-threats/malware-campaign-hits-czech-republic/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG05_14,
            author = {J. K\\v{r}oustek},
            title = {Pay the debt! -- Malware Campaign Hits the Czech Republic},
            year = {2014},
            month = {June},
            howpublished = {[online]},
            note = {Available on \url{http://blogs.avg.com/news-threats/malware-campaign-hits-czech-republic/}}
        }
        ```
      </p>
      </details>
* J. Křoustek: Turla Rootkit: A Look Under the Hood [online]. AVG Blog, June 9, 2014 ([WWW](http://blogs.avg.com/news-threats/turla-rootkit-analysed/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG04_14,
            author = {J. K\\v{r}oustek},
            title = {Turla Rootkit: A Look Under the Hood},
            year = {2014},
            month = {June},
            howpublished = {[online]},
            note = {Available on \url{http://blogs.avg.com/news-threats/turla-rootkit-analysed/}}
        }
        ```
      </p>
      </details>
* J. Křoustek, P. Matula: Malware Analysis: Cryptocurrency-mining Malware Running on DVRs [online]. AVG Blog, April 23, 2014 ([WWW](http://blogs.avg.com/news-threats/cryptocurrency-mining-dvr-malware/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG03_14,
            author = {J. K\\v{r}oustek and P. Matula},
            title = {Malware Analysis: Cryptocurrency-mining Malware Running on {DVR}s},
            year = {2014},
            month = {April},
            howpublished = {[online]},
            note = {Available on \url{http://blogs.avg.com/news-threats/cryptocurrency-mining-dvr-malware/}}
        }
        ```
      </p>
      </details>
* J. Křoustek: AutoIt Approach: Infecting Your Browser Via Code Recycling [online]. AVG Blog, March 26, 2014 ([WWW](http://blogs.avg.com/news-threats/autoit-approach-infecting-browser-code-recycling/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG02_14,
            author = {J. K\\v{r}oustek},
            title = {{AutoIt} Approach: Infecting Your Browser Via Code Recycling},
            year = {2014},
            month = {March},
            howpublished = {[online]},
            note = {Available on \url{http://blogs.avg.com/news-threats/autoit-approach-infecting-browser-code-recycling/}}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Matula, P. Zemek: Linux.Aidra vs Linux.Darlloz: War of the Worms [online]. AVG Blog, February 20, 2014 ([WWW](http://blogs.avg.com/news-threats/war-of-the-worms/))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Misc{RETDEC_AVG01_14,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Matula and P. Zemek},
            title = {{Linux.Aidra} vs {Linux.Darlloz}: War of the Worms},
            year = {2014},
            month = {February},
            howpublished = {[online]},
            note = {Available on \url{http://blogs.avg.com/news-threats/war-of-the-worms/}}
        }
        ```
      </p>
      </details>
* J. Křoustek, P. Matula, D. Kolář, M. Zavoral: Advanced Preprocessing of Binary Executable Files and its Usage in Retargetable Decompilation. In: Internation Journal on Advances in Software, Vol. 7, No. 1, 2014, US, pp. 112-122 ([PDF](http://www.thinkmind.org/download.php?articleid=soft_v7_n12_2014_9))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_IJAS_14,
            author = {J. K\\v{r}oustek and P. Matula and D. Kol\\'{a}\\v{r} and M. Zavoral},
            title = {Advanced Preprocessing of Binary Executable Files and its Usage in Retargetable Decompilation},
            journal = {Internation Journal on Advances in Software},
            volume = {7},
            number = {1},
            pages = {112--122},
            year = {2014}
        }
        ```
      </p>
      </details>

## 2013

* L. Ďurfina, J. Křoustek, P. Zemek: Retargetable Machine-Code Decompilation in Your Web Browser, In: 3rd IEEE World Congress on Information and Communication Technologies (WICT'13), Hanoi, VN, IEEE, 2013, pp. 57-62
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_WICT_13,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek},
            title = {Retargetable Machine-Code Decompilation in Your Web Browser},
            booktitle = {3rd IEEE World Congress on Information and Communication Technologies (WICT'13)},
            pages = {57--62},
            year = {2013},
            address = {Hanoi, VN},
            publisher = {IEEE}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek: Psyb0t Malware: A Step-by-Step Decompilation Case Study, In: 20th Working Conference on Reverse Engineering (WCRE'13), Koblenz, DE, IEEE, 2013, pp. 449-456 ([PDF](data/retdec-paper-wcre-2013.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_WCRE_13,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek},
            title = {Psyb0t Malware: A Step-by-Step Decompilation Case Study},
            booktitle = {20th Working Conference on Reverse Engineering (WCRE'13)},
            pages = {449--456},
            year = {2013},
            address = {Koblenz, DE},
            publisher = {IEEE}
        }
        ```
      </p>
      </details>
* L. Ďurfina, D. Kolář: Generic Detection of the Statically Linked Code, In: Proceedings of the Twelfth International Conference on Informatics (INFORMATICS'13), Spišská Nová Ves, SK, FEI TU in Košice, 2013, pp. 157-161
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_INFORMATICS_13,
            author = {L. \\v{D}urfina and D. Kol\\'{a}\\v{r}},
            title = {Generic Detection of the Statically Linked Code},
            booktitle = {Proceedings of the Twelfth International Conference on Informatics (INFORMATICS'13)},
            pages = {157--161},
            year = {2013},
            address = {Spi\\v{s}sk\\'{a} Nov\\'{a} Ves, SK},
            publisher = {FEI TU in Ko\\v{s}ice}
        }
        ```
      </p>
      </details>
* J. Křoustek: Decompilation of VLIW Executable Files - Caveats and Pitfalls, In: Theoretical and Applied Aspects of Cybernetics (TAAC'13), Kyiv, UA, TSNUK, 2013, pp. 287-296
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_TAAC_13,
            author = {J. K\\v{r}oustek},
            title = {Decompilation of {VLIW} Executable Files -- Caveats and Pitfalls},
            booktitle = {Theoretical and Applied Aspects of Cybernetics (TAAC'13)},
            pages = {287--296},
            year = {2013},
            address = {Kyiv, UA},
            publisher = {TSNUK}
        }
        ```
      </p>
      </details>
* J. Křoustek, F. Pokorný: Reconstruction of Instruction Idioms in a Retargetable Decompiler, In: 4th Workshop on Advances in Programming Languages (WAPL'13), Kraków, PL, IEEE, 2013, pp. 1507-1514 ([PDF](https://fedcsis.org/proceedings/2013/pliks/153.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_WAPL_13,
            author = {J. K\\v{r}oustek and F. Pokorn\\'{y}},
            title = {Reconstruction of Instruction Idioms in a Retargetable Decompiler},
            booktitle = {4th Workshop on Advances in Programming Languages (WAPL'13)},
            pages = {1507--1514},
            year = {2013},
            address = {Krak\'{o}w, PL},
            publisher = {IEEE}
        }
        ```
      </p>
      </details>
* J. Křoustek, D. Kolář: Context Parsing (Not Only) of the Object-File-Format Description Language, In: Computer Science and Information Systems, Vol. 10, No. 4, 2013, Novi Sad, RS, pp. 1673-1702 ([WWW](http://www.comsis.org/archive.php?show=pprsclit004-1301), [PDF](http://www.comsis.org/pdf.php?id=sclit004-1301))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_COMSIS_13,
            author = {J. K\\v{r}oustek and D. Kol\\'{a}\\v{r}},
            title = {Context Parsing (Not Only) of the Object-File-Format Description Language},
            journal = {Computer Science and Information Systems},
            volume = {10},
            number = {4},
            pages = {1673--1702},
            year = {2013}
        }
        ```
      </p>
      </details>
* J. Křoustek, D. Kolář: Approaching Retargetable Static, Dynamic, and Hybrid Executable-Code Analysis. In: Acta Informatica Pragensia, Vol. 2, No. 1, 2013, Prague, CZ, pp. 18-29 ([WWW](http://aip.vse.cz/index.php/aip/article/view/19), [PDF](http://aip.vse.cz/index.php/aip/article/download/19/15))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_AIP_13,
            author = {J. K\\v{r}oustek and D. Kol\\'{a}\\v{r}},
            title = {Approaching Retargetable Static, Dynamic, and Hybrid Executable-Code Analysis},
            journal = {Acta Informatica Pragensia},
            volume = {2},
            number = {1},
            pages = {18--19},
            year = {2013}
        }
        ```
      </p>
      </details>
* J. Křoustek, D. Kolář: Preprocessing of Binary Executable Files Towards Retargetable Decompilation. In: 8th International Multi-Conference on Computing in the Global Information Technology (ICCGI'13), Nice, FR, IARIA, 2013, pp. 259-264 ([WWW](http://www.thinkmind.org/index.php?view=article&articleid=iccgi_2013_13_10_10061), [PDF](http://www.thinkmind.org/download.php?articleid=iccgi_2013_13_10_10061))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_ICCGI_13,
            author = {J. K\\v{r}oustek and D. Kol\\'{a}\\v{r}},
            title = {Preprocessing of Binary Executable Files Towards Retargetable Decompilation},
            booktitle = {8th International Multi-Conference on Computing in the Global Information Technology},
            pages = {259--264},
            year = {2013},
            address = {Nice, FR},
            publisher = {IARIA}
        }
        ```
      </p>
      </details>
* P. Matula, D. Kolář: Reconstruction of Simple Data Types in Decompilation, In: Sborník příspěvků Mezinárodní Masarykovy konference pro doktorandy a mladé vědecké pracovníky, Hradec Králové, CZ, Akademické sdružení MAGNANIMITAS Assn., 2013, pp. 1-10
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_MMK_13,
            author = {P. Matula and D. Kol\\'{a}\\v{r}},
            title = {Reconstruction of Simple Data Types in Decompilation},
            booktitle = {Sborn\\'{i}k p\\v{r}\\'{i}sp\\v{e}vk\\r{u} Mezin\\'{a}rodn\\'{i} Masarykovy konference pro doktorandy a mlad\\'{e} v\\v{e}deck\\'{e} pracovn\\'{i}ky},
            pages = {1--10},
            year = {2013},
            address = {Hradec Kr\\'{a}lov\\'{e}},
            publisher = {Akademick\\'{e} sdru\\v{z}en\\'{i} MAGNANIMITAS Assn.}
        }
        ```
      </p>
      </details>

## 2012

* L. Ďurfina, J. Křoustek, P. Zemek, B. Kábele, D. Kolář: On Complex Reconstruction of Functions from Binary Executable Files, In: 8th Doctoral Workshop on Mathematical and Engineering Methods in Computer Science (MEMICS'12), Brno, CZ, MUNI, 2012, pp. 100-101
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_MEMICS_12,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek and B. K\\'{a}bele and D. Kol\\'{a}\\v{r}},
            title = {On Complex Reconstruction of Functions from Binary Executable Files},
            booktitle = {8th Doctoral Workshop on Mathematical and Engineering Methods in Computer Science},
            pages = {100--101},
            year = {2012},
            address = {Brno, CZ},
            publisher = {MUNI}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek, B. Kábele: Accurate Recovery of Functions in a Retargetable Decompiler, In: The 15th International Symposium on Research in Attacks, Intrusions and Defenses (RAID'12), Amsterdam, NL, Springer, 2012, pp. 390-392 ([WWW](http://link.springer.com/chapter/10.1007%2F978-3-642-33338-5_27))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_RAID_12,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek and B. K\\'{a}bele},
            title = {Accurate Recovery of Functions in a Retargetable Decompiler},
            booktitle = {The 15th International Symposium on Research in Attacks, Intrusions and Defenses (RAID'12)},
            pages = {390--392},
            year = {2012},
            address = {Amsterdam, NL},
            publisher = {Springer}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek, B. Kábele: Detection and Recovery of Functions and Their Arguments in a Retargetable Decompiler, In: 19th Working Conference on Reverse Engineering (WCRE'12), Kingston, Ontario, CA, IEEE, 2012, pp. 51-60 ([WWW](http://www.computer.org/csdl/proceedings/wcre/2012/4891/00/4891a051-abs.html))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_WCRE_12,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek and B. K\\'{a}bele},
            title = {Detection and Recovery of Functions and Their Arguments in a Retargetable Decompiler},
            booktitle = {19th Working Conference on Reverse Engineering (WCRE'12)},
            pages = {51--60},
            year = {2012},
            address = {Kingston, Ontario, CA},
            publisher = {IEEE}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek: Generic Source Code Migration Using Decompilation, In: 10th Annual Industrial Simulation Conference (ISC'12), Brno, CZ, EUROSIS, 2012, pp. 38-42
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_ISC_12,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek},
            title = {Generic Source Code Migration Using Decompilation},
            booktitle = {10th Annual Industrial Simulation Conference (ISC'12)},
            pages = {38--42},
            year = {2012},
            address = {Brno, CZ},
            publisher = {EUROSIS}
        }
        ```
      </p>
      </details>
* J. Křoustek, D. Kolář: Object-File-Format Description Language and Its Usage in Retargetable Decompilation, In: AIP Conference Proceedings, Kos, GR, AIP, 2012, pp. 466-469 ([WWW](http://proceedings.aip.org/resource/2/apcpcs/1479/1/466_1))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_SCLIT_12,
            author = {J. K\\v{r}oustek and D. Kol\\'{a}\\v{r}},
            title = {Object-File-Format Description Language and Its Usage in Retargetable Decompilation},
            booktitle = {AIP Conference Proceedings},
            pages = {466--469},
            year = {2012},
            address = {Kos, GR},
            publisher = {AIP}
        }
        ```
      </p>
      </details>
* J. Křoustek, P. Matula, J. Končický, D. Kolář: Accurate Retargetable Decompilation Using Additional Debugging Information, In: Proceedings of the Sixth International Conference on Emerging Security Information, Systems and Technologies (SECURWARE'12), Rome, IT, IARIA, 2012, pp. 79-84 ([PDF](http://www.thinkmind.org/download.php?articleid=securware_2012_3_40_30099))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_SECURWARE_12,
            author = {J. K\\v{r}oustek and P. Matula and J. Kon\\v{c}ick\\'{y} and D. Kol\\'{a}\\v{r}},
            title = {Accurate Retargetable Decompilation Using Additional Debugging Information},
            booktitle = {Proceedings of the Sixth International Conference on Emerging Security Information, Systems and Technologies (SECURWARE'12)},
            pages = {79--84},
            year = {2012},
            address = {Rome, IT},
            publisher = {IARIA}
        }
        ```
      </p>
      </details>

## 2011

* L. Ďurfina, D. Kolář: Generic Detection of Register Realignment, In: AIP Conference Proceedings, Kassandra, Halkidiki, GR, AIP, 2011, pp. 806-809 ([WWW](http://proceedings.aip.org/resource/2/apcpcs/1389/1/806_1))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_SCLIT_11,
            author = {L. \\v{D}urfina and D. Kol\\'{a}\\v{r}},
            title = {Generic detection of register realignment},
            booktitle = {AIP Conference Proceedings},
            pages = {806--809},
            year = {2011},
            address = {Kassandra, Halkidiki, GR},
            publisher = {AIP}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek, D. Kolář, T. Hruška, K. Masařík, A. Meduna: Advanced Static Analysis for Decompilation Using Scattered Context Grammars, In: Proceedings of the Applied Computing Conference (ACC'11), Angers, FR, WSEAS, 2011, pp. 164-169 ([PDF](http://www.wseas.us/e-library/conferences/2011/Angers/ACMMA/ACMMA-27.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_ACC_11,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek and D. Kol\\'{a}\\v{r} and T. Hru\\v{s}ka and K. Masa\\v{r}\\'{i}k and A. Meduna},
            title = {Advanced Static Analysis for Decompilation Using Scattered Context Grammars},
            booktitle = {Proceedings of the Applied Computing Conference (ACC'11)},
            pages = {164--169},
            year = {2011},
            address = {Angers, FR},
            publisher = {WSEAS}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek, D. Kolář, T. Hruška, K. Masařík, A. Meduna: Design of a Retargetable Decompiler for a Static Platform-Independent Malware Analysis, In: International Journal of Security and Its Applications, vol. 5, n. 4, 2011, Daejeon, KR, pp. 91-106 ([PDF](http://www.sersc.org/journals/IJSIA/vol5_no4_2011/8.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @Article{RETDEC_IJSIA_11,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek and D. Kol\\'{a}\\v{r} and T. Hru\\v{s}ka and K. Masa\\v{r}\\'{i}k and A. Meduna},
            title = {Design of a Retargetable Decompiler for a Static Platform-Independent Malware Analysis},
            journal = {International Journal of Security and Its Applications},
            pages = {91--106},
            volume = {5},
            number = {4},
            year = {2011}
        }
        ```
      </p>
      </details>
* L. Ďurfina, J. Křoustek, P. Zemek, D. Kolář, T. Hruška, K. Masařík, A. Meduna: Design of an Automatically Generated Retargetable Decompiler, In: 2nd European Conference of COMPUTER SCIENCE (ECCS'11), Puerto De La Cruz, Tenerife, ES, NAUN, 2011, pp. 199-204 ([PDF](http://www.wseas.us/e-library/conferences/2011/Tenerife/CSCC/CSCC-31.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_ECCS_11,
            author = {L. \\v{D}urfina and J. K\\v{r}oustek and P. Zemek and D. Kol\\'{a}\\v{r} and T. Hru\\v{s}ka and K. Masa\\v{r}\\'{i}k and A. Meduna},
            title = {Design of an Automatically Generated Retargetable Decompiler},
            booktitle = {2nd European Conference of COMPUTER SCIENCE (ECCS'11)},
            pages = {199--204},
            year = {2011},
            address = {Puerto De La Cruz, Tenerife, ES},
            publisher = {NAUN}
        }
        ```
      </p>
      </details>
* L. Ďurfina: Recognition of Register Realignment by Scattered Context Grammars, In: Proceedings of the 17th Conference and Competition STUDENT EEICT 2011 Volume 3, Brno, CZ, VUT FIT, 2011, pp. 470-474 ([PDF](http://www.feec.vutbr.cz/EEICT/2011/sbornik/03-Doktorske%20projekty/08-Informacni%20systemy/03-idurfina.pdf))
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_EEICT_11,
            author = {L. \\v{D}urfina},
            title = {Recognition of Register Realignment by Scattered Context Grammars},
            booktitle = {Proceedings of the 17th Conference and Competition STUDENT EEICT 2011 Volume 3},
            pages = {470--474},
            year = {2011},
            address = {Brno, CZ},
            publisher = {VUT FIT}
        }
        ```
      </p>
      </details>
* J. Křoustek, P. Matula, L. Ďurfina: Generic Plugin-Based Convertor of Executable File Formats and Its Usage in Retargetable Decompilation, In: Proceedings of the 6th International Scientific and Technical Conference (CSIT'11), Lviv, UA, 2011, pp. 127-130, IEEE, 2011
    * <details><summary>BibTeX</summary>
      <p>

        ```bibtex
        @InProceedings{RETDEC_CSIT_11,
            author = {J. K\\v{r}oustek and P. Matula and L. \\v{D}urfina},
            title = {Generic Plugin-Based Convertor of Executable File Formats and Its Usage in Retargetable Decompilation},
            booktitle = {Proceedings of the 6th International Scientific and Technical Conference (CSIT'11)},
            pages = {127--130},
            year = {2011},
            address = {Lviv, UA},
            publisher = {IEEE}
        }
        ```
      </p>
      </details>
