# Node Foundation CTC Meeting 2016-08-31

## Links

* **Audio Recording**: TBP
* **GitHub Issue**: [#8330](https://github.com/nodejs/node/issues/8330)
* **Minutes Google Doc**: <https://docs.google.com/document/d/1qYUOfiiytaZ0-YZVZ1NZX9O-4SE28QNooapOdcjlPqA>
* _Previous Minutes Google Doc_: <https://docs.google.com/document/d/1mkOUQ-M3s6zV2ige00hj6IIlT5oGQcw1USeliRqRDSk>

## Present

* Anna Henningsen @addaleax (CTC)
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
* Сковорода Никита Андреевич @ChALkeR (CTC)
* Evan Lucas @evanlucas (CTC)
* Jeremiah Senkpiel @Fishrock123 (CTC)
* Fedor Indutny @indutny (CTC)
* James M Snell @jasnell (CTC)
* Josh Gavant @joshgav (observer/Microsoft)
* Michael Dawson @mhdawson (CTC)
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
* Brian White @mscdex (CTC)
* Ali Ijaz Sheikh @ofrobots (CTC)
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
* Rod Vagg @rvagg (CTC)
* Trevor Norris @trevnorris (CTC)
* Rich Trott @Trott (CTC)


## Standup

* Anna Henningsen @addaleax (CTC)
  * Couple of own PRs
  * Segfault issue in V8
  * Issues & PR review
* Bradley Meck @bmeck (observer/GoDaddy/TC39)
  * Going around sorting out the modules rewrite / explaining to people
* Сковорода Никита Андреевич @ChALkeR (CTC)
  * Some work on the npm codesearch tool
  * Usual comments on issues and PRs
* Evan Lucas @evanlucas (CTC)
  * v6.5.0 release
* Jeremiah Senkpiel @Fishrock123 (CTC)
  * Module discussions
  * Reviewing promises warning & other PRs.
  * Discovered more odd stdio related quirks.
* Fedor Indutny @indutny (CTC)
  * Issues and PRs, nothing new
* Josh Gavant @joshgav (observer/Microsoft)
  * Some work on debugging docs.
  * Plan next Diag WG meeting.
* Michael Dawson @mhdawson (CTC)
  * Addons on test issues on AIX
  * Adding PPC machines from new cluster at OSUOSL
  * Adding AIX machines from OSUOSL
  * Adding linxuOne machine to release CI
  * Initial discussion on codecoverage.nodejs.org
  * Preparing for Node Interactive presentations (build WG update
    Post-mortem WG update)
  * General PR review/land/keeping up with issues
* Mikeal Rogers @mikeal (observer/Node.js Foundation)
  * board meeting stuff from Monday
  * getting things together for TC39 meeting
* Brian White @mscdex (CTC)
  * Landed a couple of old PRs
  * Reviewed PRs, commented on issues
* Ali Ijaz Sheikh @ofrobots (CTC)
  * V8 5.1 and 5.4 related issues.
* Jenn Turner @renrutnnej (observer/Node.js Foundation)
  * Observing for the Node.js Foundation newsletter
* Rod Vagg @rvagg (CTC)
  * Node Foundation Board business (incl Board meeting), lots of Build WG work incl major ARM cluster cleanup, OSX resource chasing, clang 3.4.1 CI node, blog post
* Trevor Norris @trevnorris (CTC)
  * Finishing async_hooks implementation
  * Few PR reviews
  * Posted issue about --prof not working on win x64 (when processing isolate*.log w/ --prof-process)
* Rich Trott @Trott (CTC)
  * Onboarded @lpinca and @danbev
  * Helped a few first-time and second-time committers, looking to do that more
  * Trying to get CI green again, even ventured into C++/crypto land for a tiny change. #OutOfMyComfortZone Please review: https://github.com/nodejs/node/pull/8352
* James M Snell @jasnell (CTC)
  * prs, issues, doc updates
  * Preparing for v7


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

### nodejs/node

* Process for determining supported platforms [#8265](https://github.com/nodejs/node/issues/8265)
* child_process, win: fix shell spawn with AutoRun [#8063](https://github.com/nodejs/node/pull/8063)
* fs: undeprecate existsSync; use access instead of stat for performance [#7455](https://github.com/nodejs/node/pull/7455)
* doc: add Google Analytics tracking. [#6601](https://github.com/nodejs/node/pull/6601)
* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)
* Move ecosystem detection tool to nodejs org [#7935](https://github.com/nodejs/node/issues/7935)

### nodejs/node-eps

* AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)


## Previous Meeting Review

* CTC membership nomination: @TheAlphaNerd [#8058](https://github.com/nodejs/node/issues/8058)
  * @rvagg to onboard @thealphanerd.
* buffer: hard-deprecate Buffer constructor [#7152](https://github.com/nodejs/node/pull/7152)
  * Land hard deprecation of `Buffer` without `new` now.
  * Other conversation continue in GH, remove ctc-agenda label.
* fs: don't alter user provided `options` object [#7831](https://github.com/nodejs/node/pull/7831)
  * CTC approved semver-major change. Remove ctc-agenda, continue with usual process.
* fs: undeprecate existsSync; use access instead of stat for performance [#7455](https://github.com/nodejs/node/pull/7455)
  * First item on next week’s agenda.
* doc: add Google Analytics tracking. [#6601](https://github.com/nodejs/node/pull/6601)
  * Raise above questions and discuss in GH.
  * Review for quick resolution next week.
* Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)
  * Defer to next week.
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
  * @rvagg to remove `ctc-agenda` label
* Landing node-eps for ABI stable module and location for PoC code [#28](https://github.com/nodejs/api/issues/28)
  * @mhdawson to commit draft to Node-EPs repo.
  * @mhdawson to create another repo for ABI-stable work.

## Minutes

* fs: undeprecate existsSync; use access instead of stat for performance [#7455](https://github.com/nodejs/node/pull/7455)

@Fishrock123: No further discussion from us this past week.
Person who submitted PR analyzed `access` with F_OK flag but that didn’t reveal anything.
If we are to undeprecate something it needs CTC signoff.

@Trott: Is anyone strongly in favor?
@trevnorris: No super compelling reason for leaving it out, especially since this is something which has had a lot of community push to keep in.

@rvagg: This one needs a CTC or Collaborator champion to move it through, otherwise it will continue to be stalled.

@joshgav: Should we have someone come and present the case to the CTC?
@jasnell: That could be helpful.
@Fishrock123: All the cases are laid out in the thread.

@rvagg: Without a champion it won’t move forward. We need to ping collaborators and seek someone particularly interested.

@trevnorris: Code and tests are there. Do we need someone to come and make the argument?
@rvagg: Someone needs to come and do the convincing.
@trevnorris: There are people religiously opposed to this, no argument could win them over. I don’t have time to make all those arguments.
@mikeal: We can move to a vote then.

@trott: Let’s ping nodejs/collaborators to see if anyone feels very strongly in favor of `existsSync` and see where that lands, then look at this again in a week. If no one stands up for the case than whether just or not it’s dead in the water.

@rvagg: We can also have a vote here and just bring it down to proper voting.

@addaleax: @williamkapke suggested discussing this at the Collaboration Summit.

**Next steps**:

* @trott to ping nodejs/collaborators in that thread.
* If no response raise for vote next week or close.


### doc: add Google Analytics tracking. [#6601](https://github.com/nodejs/node/pull/6601)

@mikeal: People with access would be web site admin team and internal foundation employees.

@trott: We wanted to wait for @bnoordhuis to give input. But he’s not here again this week. Should we table?

@mikeal: No argument about value of this data, argument about which tool to use. But no alternative has been proposed.

@rvagg: We gave warning that we’d come back to it this week. We’re back so now it’s time to vote.

@indutny: My questions are answered, I don’t have any objections.

@trott: Anyone opposed to moving to a vote?

**Vote**:

* Yes: 9 (Rich Trott, Ali Sheikh, Evan Lucas, Anna Henningsen, Fedor Indutny, Rod Vagg, James Snell, Michael Dawson, Trevor Norris)
* No: 0
* Abstain: 3 (Brian White, Сковорода Никита, Jeremiah Senkpiel)

**Next steps**:

* Merge!


### Introduce staging branch for stable release streams [#6306](https://github.com/nodejs/node/issues/6306)

@trott: No rush, propose tabling another week to wait for @thealphanerd.

@evanlucas: Myles made his position pretty clear. At first I didn’t care either way, but after the last release it was difficult to not have a staging branch to build out on. I had built binaries and then something was added and I had to go back.

@jasnell: Most people who have done releases recently have come out in favor of this or at least not said absolutely not. We can try it and if it’s too much process we can go back to the way we’re doing it now.

@rvagg: I like Myles argument about consistency and helping people onboard. Agree with James that this is up to those doing releases. If they want this, so be it.

@Fishrock123: Consistency argument is reasonably compelling, but I thought that wasn’t the case.

**Vote**:

Aye: 11 (Jeremiah Senkpiel, Evan Lucas, Ali Sheikh, Anna Henningsen, Rich Trott, Rod Vagg, Trevor Norris, Brian White, Nikita, Fedor Indutny, Michael Dawson, James Snell)
Nay: 0
Abstain: 0

**Next steps**:

* Do this as proposed.


### Process for determining supported platforms [#8265](https://github.com/nodejs/node/issues/8265)

@rvagg: Build working group should build a list and we can start from there. Next Build WG meeting is in 3 weeks.

@rvagg: Not just about platforms, but many permutations of plats and arch’s.

**Next steps**:

* Build WG will prepare initial list of supported platforms in their next meeting.
* Then CTC will review and decide next steps.


### child_process, win: fix shell spawn with AutoRun [#8063](https://github.com/nodejs/node/pull/8063)

@joshgav: Someone filed a bug to not respect registered autorun programs in Windows cmd spawned from Node.

@rvagg: Others asked what other runtimes do, e.g. Python.
Seems to me if you have something in the autorun then we should respect that.

@joshgav: Probably Microsoft would argue against bypassing something configured to autorun.

@rvagg: We don’t have sufficient expertise here to decide. Was brought to CTC because it’s semver-major.

**Next steps**:

* Remove from CTC agenda.
* @joshgav to check for opinions within Microsoft.
* Ask @joaocgreis in GitHub for more explanation.


### Move ecosystem detection tool to nodejs org [#7935](https://github.com/nodejs/node/issues/7935)

@Chalker: Now it’s completely in JavaScript and it has documentation to allow people to use it, so I think it’s ready for moving in.

@trott: In the issue I see only supportive voices. Any questions or concerns?

@Fishrock123: Chris Dickinson (@chrisdickinson) did some work on making an indexer that could track code paths (?). Just an aside, it’d be nice to get his opinion.

@Chalker: This doesn’t use any database, it uses plain text and json files compressed with lz4.

@trott: Move to a vote?

@rvagg: Who would take responsibility for this? Directly under CTC? It’s own maintenance group? For example if there are controversial issues to resolve are they resolved by the CTC.

@Chalker: Not sure.

@rvagg: CTC probably doesn’t want to own this, so probably needs its own team/WG, and that should be in the README at least.

@mhdawson: Probably needs LICENSE, CONTRIBUTORS, etc. We’ve asked others to add those in, then open an issue in nodejs/tsc, then we move it over.

@rvagg: That seems absolutely right. Prepare it and put it on TSC repo. Ping @williamkapke for help if you need.

@mhdawson: Also node-report is an example of this exercise done recently, you can learn from that.

@trott: Any objections to this?

**Next steps**:

* Prep repo for migration.
* Open issue in nodejs/tsc.


### AsyncWrap public API proposal [#18](https://github.com/nodejs/node-eps/pull/18)

@trevnorris: Updated the EP some, updating again now. There was an API which was useless. Happy with progress, 80% of the way there. Will keep working on it, put up for review tomorrow morning. Other than that one change of removal of API it’s pretty much on point.

@rvagg: There was a question about renaming the API.

@trevnorris: The name ‘AsyncWrap’ is an implementation “leak”. So I’ve renamed it “async_hooks”. Want to verify that CTC is okay with name change.

@Fishrock123: A lot of new things have been added since CTC last reviewed.

@rvagg: Let’s bring this up again next week with a clear request for a vote.
Where is the code for review?

@trevnorris: cannot be done in pieces, it’s an all-or-none thing.

@joshgav: Do we want this to land before v7?

@Fishrock123: It’s semver-minor, so not a big deal.

@trevnorris: Plan was to get this in before v6 goes LTS. When is that?

@jasnell: mid to late October.

**Next steps**:

* Trevor to update all code and ask for vote on specific item(s).
* CTC to review again once complete.


## Q/A on public channels

None.


## Upcoming Meetings

* CTC: 2016-09-07
* TSC: 2016-09-08
* Benchmarking: [Benchmarking#56](https://github.com/nodejs/benchmarking/issues/56)
* Build:
* LTS:
* Diagnostics:
* Post-Mortem:
* API:
