export type ApiStream = AsyncGenerator<ApiStreamChunk> & { id?: string }
export type ApiStreamChunk = ApiStreamTextChunk | ApiStreamThinkingChunk | ApiStreamUsageChunk | ApiStreamToolCallsChunk

export interface ApiStreamTextChunk {
	type: "text"
	/**
	 * Text content generated by the model
	 */
	text: string
	/**
	 * The response ID associated with this chunk
	 */
	id?: string
	/**
	 * The thought signature associated with this chunk used by Gemini
	 */
	signature?: string
}

export interface ApiStreamUsageChunk {
	type: "usage"
	inputTokens: number
	outputTokens: number
	cacheWriteTokens?: number
	cacheReadTokens?: number
	thoughtsTokenCount?: number // openrouter
	totalCost?: number // openrouter
	/**
	 * The response ID associated with this response
	 */
	id?: string
}

export interface ApiStreamToolCallsChunk {
	type: "tool_calls"
	/**
	 * The tool call information
	 */
	tool_call: ApiStreamToolCall
	/**
	 * The response ID associated with this chunk
	 */
	id?: string
	/**
	 * The thought signature associated with this chunk used by Gemini
	 */
	signature?: string
}

export interface ApiStreamToolCall {
	/**
	 * The call ID associated with this tool call
	 */
	call_id?: string
	// Information about the tool being called
	function: {
		/**
		 * The tool call ID
		 */
		id?: string
		/**
		 * Name of the tool
		 */
		name?: string
		/**
		 * The arguments passed to the tool execution
		 */
		arguments?: any
	}
}

export interface ApiStreamThinkingChunk {
	type: "reasoning"
	/**
	 * The reasoning text generated by the model.
	 * Redacted reasoning block will have this field set to "[REDACTED]" or an empty string.
	 */
	reasoning: string
	/**
	 * openrouter has various properties that we can pass back unmodified in api requests to preserve reasoning traces
	 * This is also where we store the summary details for OpenAI.
	 */
	details?: unknown
	/**
	 * It's used when sending the thinking block back to the  API.
	 * API expects this in completed form, not as array of deltas.
	 * Also used by Gemini for thought signature associated with this chunk
	 */
	signature?: string
	/**
	 * redacted data
	 */
	redacted_data?: string
	/**
	 * The response ID associated with this chunk
	 */
	id?: string
}
