import { ClineDefaultTool } from "@shared/tools"

export type AssistantMessageContent = TextStreamContent | ToolUse | ReasoningStreamContent

export { parseAssistantMessageV2 } from "./parse-assistant-message"

export interface TextStreamContent {
	type: "text"
	content: string
	partial: boolean
}

export const toolParamNames = [
	"command",
	"requires_approval",
	"path",
	"absolutePath",
	"content",
	"diff",
	"regex",
	"file_pattern",
	"recursive",
	"action",
	"url",
	"coordinate",
	"text",
	"query",
	"allowed_domains",
	"blocked_domains",
	"prompt",
	"server_name",
	"tool_name",
	"arguments",
	"uri",
	"question",
	"options",
	"response",
	"result",
	"context",
	"title",
	"what_happened",
	"steps_to_reproduce",
	"api_request_output",
	"additional_context",
	"needs_more_exploration",
	"task_progress",
	"timeout",
	"input",
	"from_ref",
	"to_ref",
	"skill_name",
] as const

export type ToolParamName = (typeof toolParamNames)[number]

export interface ToolUse {
	type: "tool_use"
	name: ClineDefaultTool // id of the tool being used
	// params is a partial record, allowing only some or none of the possible parameters to be used
	params: Partial<Record<ToolParamName, string>>
	partial: boolean
	/**
	 * Whether this tool use was initiated by a native tool call
	 */
	isNativeToolCall?: boolean
	/**
	 * The call / response ID this tool use is associated with.
	 */
	call_id?: string // optional call ID for tracking tool use calls
	/**
	 * Thought signature associated with this tool use, used by Gemini
	 */
	signature?: string
}

export interface ReasoningStreamContent {
	type: "reasoning"
	/**
	 * The reasoning text generated by the model.
	 * Redacted reasoning block will have this field set to "[REDACTED]" or an empty string.
	 */
	reasoning: string
	/**
	 * openrouter has various properties that we can pass back unmodified in api requests to preserve reasoning traces
	 */
	details?: any
	/**
	 * It's used when sending the thinking block back to the  API.
	 * API expects this in completed form, not as array of deltas.
	 */
	signature?: string
	/**
	 * whether this reasoning block has been redacted
	 */
	redacted?: boolean
	/**
	 * redacted data
	 */
	data?: string
	/**
	 * Indicates whether this is a partial reasoning block
	 */
	partial: boolean
}
