export const AUDIO_PROGRAM_CONFIG = {
	darwin: {
		command: "ffmpeg",
		fallbackPaths: ["/usr/local/bin/ffmpeg", "/opt/homebrew/bin/ffmpeg"],
		getArgs: (outputFile: string) => [
			"-f",
			"avfoundation",
			"-i",
			":default",
			"-c:a",
			"libopus",
			"-b:a",
			"32k",
			"-application",
			"voip",
			"-ar",
			"16000",
			"-ac",
			"1",
			outputFile,
		],
		dependencyName: "FFmpeg",
		installCommand: "brew install ffmpeg",
		error: "FFmpeg is required for voice recording but is not installed on your system.",
		installDescription: "FFmpeg is a multimedia framework that Cline uses to record audio from your microphone.",
	},
	linux: {
		command: "ffmpeg",
		fallbackPaths: ["/usr/bin/ffmpeg", "/usr/local/bin/ffmpeg", "/snap/bin/ffmpeg"],
		getArgs: (outputFile: string) => [
			"-f",
			"alsa",
			"-i",
			"default",
			"-c:a",
			"libopus",
			"-b:a",
			"32k",
			"-application",
			"voip",
			"-ar",
			"16000",
			"-ac",
			"1",
			outputFile,
		],
		dependencyName: "FFmpeg",
		installCommand: "sudo apt-get update && sudo apt-get install -y ffmpeg",
		error: "FFmpeg is required for voice recording but is not installed on your system.",
		installDescription: "FFmpeg is a multimedia framework that Cline uses to record audio from your microphone.",
	},
	win32: {
		command: "ffmpeg",
		fallbackPaths: [
			"C:\\ffmpeg\\bin\\ffmpeg.exe",
			"C:\\Program Files\\ffmpeg\\bin\\ffmpeg.exe",
			"C:\\Program Files (x86)\\ffmpeg\\bin\\ffmpeg.exe",
		],
		getArgs: (outputFile: string) => [
			"-f",
			"wasapi",
			"-i",
			"audio=default",
			"-c:a",
			"libopus",
			"-b:a",
			"32k",
			"-application",
			"voip",
			"-ar",
			"16000",
			"-ac",
			"1",
			outputFile,
		],
		dependencyName: "FFmpeg",
		installCommand: "winget install Gyan.FFmpeg",
		error: "FFmpeg is required for voice recording but is not installed on your system.",
		installDescription: "FFmpeg is a multimedia framework that Cline uses to record audio from your microphone.",
	},
}
