# Summary

UD Komi-Zyrian Lattice is a treebank of written standard Komi-Zyrian. 

# Introduction

The treebank contains continuous texts in the written Komi-Zyrian language. All of the data comes from openly available sources. The largest segments are from Lev Uspenskiy's book *Нёль боевӧй случай* (URN http://urn.fi/URN:NBN:fi-fe2014102045428), which was digitalized in the National Library of Finland's [Fenno-Ugrica](https://fennougrica.kansalliskirjasto.fi/) project, and Ivan Belyx's short story which was added to [Komi Nebögain online library](http://komikyv.org) by the author himself in 2013. Some articles from the newspaper [Выль туйӧд's 1939 number 67](http://urn.fi/URN:NBN:fi-fe201802013020) have also been included as complete texts. Several texts are used for individual examples, and these are marked with the tag `-ind`, to distinguish them from the running text. The complete list of sources with additional information and further links is available in this README file below.

# Acknowledgments

This work has been developed within the framework of the LAKME project funded by a grant from Paris Sciences et Lettres (IDEX PSL reference ANR-10-IDEX-0001-02). Thierry Poibeau is also partially supported by a RGNF-CNRS (grant between the LATTICE-CNRS Laboratory and the Russian State University for the Humanities in Moscow). The work was done in collaboration with the Kone Foundation-funded research project [Language Documentation meets Language Technology: The Next Step in the Description of Komi](langdoc.github.io/IKDP-2).

If you use this treebank in your work, please cite:

- Partanen, Niko; Blokland, Rogier; Lim, KyungTae; Poibeau, Thierry and Rießler, Michael 2018: [First Komi-Zyrian Universal Dependencies Treebanks](http://universaldependencies.org/udw18/PDFs/28_Paper.pdf). Proceedings of the Second Workshop on Universal Dependencies (UDW 2018) (pp. 126-132).

## Sources used

| Sentence id start | Publication name | Publishing year | Link to Fenno-Ugrica | Link to Komi Nebögain | 
|-------------------------------------------------------------------------------|---------------------------------------------------------------------------------|------------------------------------------|--------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------| 
| belykh1997a | Иван Белых 1997: Шера зэр | 1997 | | http://komikyv.org/kpv/content/шера-зэр | 
| belykh2005a | Иван Белых 2005: Таысь унаыс оз и ков | 2005 | | http://komikyv.org/kpv/node/26865 | 
| falkner1927a | Фалькнер В.Н. 1927: Лоам ми ёнӧсь, дзоньвидзаӧсь да!: мӧд нига" | 1927 | http://urn.fi/URN:NBN:fi-fe2014102045431 | http://komikyv.org/kpv/contents/loam-mi-yonos-dzonvidzaos-da | |
| goffensefer1927a | Гоффеншефер С. 1927: Чакотка | 1927 | http://urn.fi/URN:NBN:fi-fe201604159701 | http://komikyv.org/kpv/contents/chahotka |  
| koskabyr1925a | Кос Кабыр 1925: Мувыв тӧдмалӧм. Медводдза нига = Ывлавыв тӧдмалӧм. Арся уджъяс. | 1925 | http://urn.fi/URN:NBN:fi-fe2014070132058 | http://komikyv.org/kpv/contents/yvlavyv-todmalom-1 | 
| kpv_1-7_Vyl_tujod_1939_09_10_0001 | Выль туйӧд 9.10.1939, page 1 | 1939 | http://urn.fi/URN:NBN:fi-fe201802013020 | | | 
| kpv_1-7_Vyl_tujod_1939_09_10_0002 | Выль туйӧд 9.10.1939, page 2 | 1939 | http://urn.fi/URN:NBN:fi-fe201802013020 | | | 
| rossinskiy1925a | Российскӧй Д. 1925: Гут разӧдӧ висьӧмъяс | 1925 | http://urn.fi/URN:NBN:fi-fe2014070332096 | http://komikyv.org/kpv/content/гут-разӧдӧ-висьӧмъяс | 
| uspensky1940a | Успенский, Лев 1940: Нёль боевӧй случай | 1940 | http://urn.fi/URN:NBN:fi-fe2014102045428 | | | 


# Changelog

- 2019-04-30
    - Annotations harmonized
- 2018-11-01
  - README file updated and various corrections done
- 2018-10-18
  - New sentences from various sources added

<pre>
=== Machine-readable metadata (DO NOT REMOVE!) ================================
Data available since: UD v2.2
License: CC BY-SA 4.0
Includes text: yes
Genre: fiction
Lemmas:	automatic with corrections
UPOS: converted with corrections
XPOS: automatic with corrections
Features: automatic with corrections
Relations: manual native
Contributors: Partanen, Niko; Lim, KyungTae; Poibeau, Thierry
Contributing: here
Contact: nikotapiopartanen@gmail.com
===============================================================================
</pre>
