import express from 'express';
import { 
    addOrderItems,
    getMyOrders,
    GetOrderById,
    updateOrderToPaid,
    updateOrderToDelivered,
    getOrders
 } from '../controllers/orderController.js';
import { protect, admin } from '../middleware/authMiddelware.js';

const router = express.Router();

router.route('/').post(protect, addOrderItems).get(protect, admin, getOrders);
router.route('/mine').get(protect, getMyOrders);
router.route('/:id').get(protect, GetOrderById);
router.route('/:id/pay').put(protect, updateOrderToPaid);
router.route('/:id/deliver').put(protect, admin, updateOrderToDelivered);

export default router;