# Contributing to Errbit

Thanks for your interest in improving Errbit. We'd love to have you as a
contributor. Guidelines for contributing code to Errbit depend on the
nature of your contribution. If your contribution adds a new feature to
Errbit, the section on 'Feature Requests' does apply. Otherwise, just
follow the guidelines under 'All Contributions' below.

## All Contributions

All code change contributions should be made through the following steps:

1. Fork `errbit/errbit` on GitHub
2. Create a branch with a descriptive name
3. Make your changes
4. Submit a pull request with a clear explanation of what you have
   changed and why

For code changes:
- Update the tests to prevent regressions and prove your changes work
- Update the documentation in the `docs/` folder
- For anything that should be configurable, use environment variables and
  update the [configuration documentation](docs/configuration.md)

## Feature Requests

If you'd like to add a feature to Errbit, please start by opening an
issue on GitHub with a description of what you'd like to add and why. If
your feature requires a deeper level of discussion, talk it over with
the other maintainers.

In general, new features should add value without detracting
significantly from usability, security, performance, ease of deployment
and maintainability. Keep in mind that by putting in a pull request for
a new feature, you are asking other people to maintain your code
indefinitely. Your feature is more likely to become part of Errbit if it
appears easy to maintain and if you are able to help maintain it.

Errbit maintainers do review all contributions, but certain kinds of
contributions take priority. Security-related changes, bug fixes, test
improvements, documentation improvements, and usability enhancements all
take priority over feature requests. But we are open to adding new
features, so if you have a good one in mind, just open a GitHub issue so
we can start a conversation.
