# frozen_string_literal: true

module NotificationServices
  class CampfireService < NotificationService
    LABEL = "campfire"
    FIELDS += [
      [:subdomain, {
        label: "Subdomain",
        placeholder: "subdomain from http://{{subdomain}}.campfirenow.com"
      }],
      [:api_token, {
        label: "API Token",
        placeholder: "123456789abcdef123456789abcdef"
      }],
      [:room_id, {
        label: "Room ID",
        placeholder: "123456"
      }]
    ]

    def check_params
      if FIELDS.detect { |f| self[f[0]].blank? }
        errors.add :base, "You must specify your Campfire Subdomain, API token and Room ID"
      end
    end

    def url
      "http://#{subdomain}.campfirenow.com/"
    end

    def create_notification(problem)
      # build the campfire client
      campy = Campy::Room.new(account: subdomain, token: api_token, room_id: room_id)
      # post the issue to the campfire room
      campy.speak "[errbit] #{problem.app.name} #{notification_description problem} - https://#{Errbit::Config.host}/apps/#{problem.app.id}/problems/#{problem.id}"
    end
  end
end
