# v0.10.0 Release notes

Hello,

I am Igor (Ihor) Zubkov, new maintainer of Errbit.

**Self-promotion:**

If you need help with Ruby and Ruby on Rails, please, contact [me](https://github.com/biow0lf).
I am available for hire. I am a full-stack developer with 10+ years of experience.

## Notable changes

### Improvements

* Upgraded Ruby and Ruby on Rails gives us huge performance boost.
* Less memory, faster application due `# frozen_string_literal: true`.
* Mostly everything, upgraded. No more known CVE in dependencies.

## Security Improvements

* Devise: change bcrypt cost from `11` to `12`.
* Devise: change password_length from `6..128` to `8..128`.
* Bundler: enable checksums.

## All changes

1. Upgrade Ruby from 2.5.1 to 3.4.3
2. Upgrade Ruby on Rails from 4.2.11.1 to 7.2.2.1
3. Upgrade RubyGems to 3.6.8
4. Upgrade Bundler to 2.6.8
5. Enable Bundler 2.6 feature checksums
6. Enable bootsnap
7. Migrate to zeitwerk
8. Migrate to `# frozen_string_literal: true`. Less memory, faster application.
9. You can run Errbit with JRuby 9.4. Experimental. We need help with docker jruby container to mark it as production-ready.
10. Flowdock support was removed. This service is no longer running.
11. We migrate from Circle CI (Sorry, Circle CI!) to GitHub Actions
12. Test suite much faster and stable. But, we are still working on stability. Especially, for JRuby 9.4.
13. We integrate `vcr` and `webmock` to test suite to external calls.
14. Remove all bundler binstubs that is not in use
15. Dependabot: take care of any security and not security updates
16. Integrate thruster in docker image. So, you can run Errbit in docker without reverse proxy.

## Deprecations and removals

### Custom user gemfile name

Support of custom user gemfile name deprecated and removed. From now,
always use `UserGemfile` as custom user gemfile. So, if you have
`USER_GEMFILE` env, just remove it. And rename custom user gemfile to
`UserGemfile`.

### Force SSL/TLS

From v0.10.0, Errbit requires reverse proxy with SSL/TLS support.

So, we enable `config.force_ssl = true` in `config/environments/production.rb`.

`ERRBIT_ENFORCE_SSL` env support and related code removed.

We recommend to use Traefik as reverse proxy. Or, you can run
Errbit with [`thruster`](https://github.com/basecamp/thruster).
Thruster integrated in our docker image.

`ERRBIT_PROTOCOL` and `ERRBIT_PORT` env support and related code was
removed too. It doesn't have any sense. `ERRBIT_PROTOCOL` is always
`https` and `ERRBIT_PORT` is always `443`.

### `SERVE_STATIC_ASSETS` env

Support of `SERVE_STATIC_ASSETS` env was removed. Just remove it
from configuration.

If you run Errbit behind reverse proxy in docker container,
thruster will serve static assets.

If you run Errbit without reverse proxy, docker container has
thruster inside. It will serve static assets and take care
about HTTPS (ACME).

### `RACK_ENV` env

`RACK_ENV` env support was removed. Use `RAILS_ENV` env for this.

### `ERRBIT_LOG_LEVEL` env

`ERRBIT_LOG_LEVEL` env support was removed. Use `RAILS_LOG_LEVEL`
for this.

### MongoDB support

* MongoDB 4.0 is reached EOL on 21 Jun 2018. 4.0 support will be removed after v0.10.0 release.
* MongoDB 4.2 is reached EOL on 09 Aug 2019. 4.2 support will be removed after v0.10.0 release.
* MongoDB 4.4 is reached EOL an 25 Jul 2020. 4.4 support will be removed after v0.10.0 release.
* MongoDB 5.0 is reached EOL on 08 Jul 2021. 5.0 support will be removed after v0.10.0 release.

So, after upgrading Errbit to v0.10.0, upgrade MongoDB to 6.0 or later.

## Docker

Docker image is recommended way to run Errbit.

You can run Errbit with reverse proxy like Traefik or with
thruster. Thruster is integrated in our docker image.

Read our new Quick Start Guide.

## Support plan

We plan support Errbit v0.10 branch for 6 months til next release. Bug-fixes
and security. And 3 month after release of v0.11 with security fixes.
