// Copyright 2024 FastLabs Developers
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//! Core structs and functions for the logforth logging framework.

#![cfg_attr(docsrs, feature(doc_cfg))]

pub mod append;
pub mod diagnostic;
pub mod filter;
pub mod kv;
pub mod layout;
pub mod record;
pub mod trap;

pub use self::append::Append;
pub use self::diagnostic::Diagnostic;
pub use self::filter::Filter;
pub use self::layout::Layout;
pub use self::trap::Trap;

mod error;
pub use self::error::*;

mod logger;
pub use self::logger::*;

mod str;
