// Copyright 2024 FastLabs Developers
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//! An example of logging with a specific logger instance.

use logforth::append;
use logforth::bridge::log::OwnedLogProxy;

fn main() {
    log::set_max_level(log::LevelFilter::Trace);

    let l = logforth::core::builder()
        .dispatch(|d| d.append(append::Stdout::default()))
        .build();

    let l = OwnedLogProxy::new(l);
    log::error!(logger: l, "Hello error!");
    log::warn!(logger: l, "Hello warn!");
    log::info!(logger: l, "Hello info!");
    log::debug!(logger: l, "Hello debug!");
    log::trace!(logger: l, "Hello trace!");
}
