## API Report File for "@firebase/ai"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { AppCheckTokenResult } from '@firebase/app-check-interop-types';
import { FirebaseApp } from '@firebase/app';
import { FirebaseAuthTokenData } from '@firebase/auth-interop-types';
import { FirebaseError } from '@firebase/util';

// @public
export interface AI {
    app: FirebaseApp;
    backend: Backend;
    // @deprecated (undocumented)
    location: string;
    options?: AIOptions;
}

// @public
export class AIError extends FirebaseError {
    constructor(code: AIErrorCode, message: string, customErrorData?: CustomErrorData | undefined);
    // (undocumented)
    readonly code: AIErrorCode;
    // (undocumented)
    readonly customErrorData?: CustomErrorData | undefined;
}

// @public
export const AIErrorCode: {
    readonly ERROR: "error";
    readonly REQUEST_ERROR: "request-error";
    readonly RESPONSE_ERROR: "response-error";
    readonly FETCH_ERROR: "fetch-error";
    readonly SESSION_CLOSED: "session-closed";
    readonly INVALID_CONTENT: "invalid-content";
    readonly API_NOT_ENABLED: "api-not-enabled";
    readonly INVALID_SCHEMA: "invalid-schema";
    readonly NO_API_KEY: "no-api-key";
    readonly NO_APP_ID: "no-app-id";
    readonly NO_MODEL: "no-model";
    readonly NO_PROJECT_ID: "no-project-id";
    readonly PARSE_FAILED: "parse-failed";
    readonly UNSUPPORTED: "unsupported";
};

// @public
export type AIErrorCode = (typeof AIErrorCode)[keyof typeof AIErrorCode];

// @public
export abstract class AIModel {
    // @internal
    protected constructor(ai: AI, modelName: string);
    // Warning: (ae-forgotten-export) The symbol "ApiSettings" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _apiSettings: ApiSettings;
    readonly model: string;
    // @internal
    static normalizeModelName(modelName: string, backendType: BackendType): string;
    }

// @public
export interface AIOptions {
    backend?: Backend;
    useLimitedUseAppCheckTokens?: boolean;
}

// @public
export class AnyOfSchema extends Schema {
    constructor(schemaParams: SchemaParams & {
        anyOf: TypedSchema[];
    });
    // (undocumented)
    anyOf: TypedSchema[];
    // @internal (undocumented)
    toJSON(): SchemaRequest;
}

// @public
export class ArraySchema extends Schema {
    constructor(schemaParams: SchemaParams, items: TypedSchema);
    // (undocumented)
    items: TypedSchema;
    // @internal (undocumented)
    toJSON(): SchemaRequest;
}

// @beta
export interface AudioConversationController {
    stop: () => Promise<void>;
}

// @public
export interface AudioTranscriptionConfig {
}

// @public
export abstract class Backend {
    protected constructor(type: BackendType);
    readonly backendType: BackendType;
    // @internal (undocumented)
    abstract _getModelPath(project: string, model: string): string;
    // @internal (undocumented)
    abstract _getTemplatePath(project: string, templateId: string): string;
}

// @public
export const BackendType: {
    readonly VERTEX_AI: "VERTEX_AI";
    readonly GOOGLE_AI: "GOOGLE_AI";
};

// @public
export type BackendType = (typeof BackendType)[keyof typeof BackendType];

// @public
export interface BaseParams {
    // (undocumented)
    generationConfig?: GenerationConfig;
    // (undocumented)
    safetySettings?: SafetySetting[];
}

// @public
export const BlockReason: {
    readonly SAFETY: "SAFETY";
    readonly OTHER: "OTHER";
    readonly BLOCKLIST: "BLOCKLIST";
    readonly PROHIBITED_CONTENT: "PROHIBITED_CONTENT";
};

// @public
export type BlockReason = (typeof BlockReason)[keyof typeof BlockReason];

// @public
export class BooleanSchema extends Schema {
    constructor(schemaParams?: SchemaParams);
}

// @public
export class ChatSession {
    // Warning: (ae-incompatible-release-tags) The symbol "__constructor" is marked as @public, but its signature references "ChromeAdapter" which is marked as @beta
    constructor(apiSettings: ApiSettings, model: string, chromeAdapter?: ChromeAdapter | undefined, params?: StartChatParams | undefined, requestOptions?: RequestOptions | undefined);
    getHistory(): Promise<Content[]>;
    // (undocumented)
    model: string;
    // (undocumented)
    params?: StartChatParams | undefined;
    // (undocumented)
    requestOptions?: RequestOptions | undefined;
    sendMessage(request: string | Array<string | Part>): Promise<GenerateContentResult>;
    sendMessageStream(request: string | Array<string | Part>): Promise<GenerateContentStreamResult>;
    }

// @beta
export interface ChromeAdapter {
    // @internal (undocumented)
    countTokens(request: CountTokensRequest): Promise<Response>;
    generateContent(request: GenerateContentRequest): Promise<Response>;
    generateContentStream(request: GenerateContentRequest): Promise<Response>;
    isAvailable(request: GenerateContentRequest): Promise<boolean>;
    // @internal (undocumented)
    mode: InferenceMode;
}

// @public
export interface Citation {
    // (undocumented)
    endIndex?: number;
    // (undocumented)
    license?: string;
    publicationDate?: Date_2;
    // (undocumented)
    startIndex?: number;
    title?: string;
    // (undocumented)
    uri?: string;
}

// @public
export interface CitationMetadata {
    // (undocumented)
    citations: Citation[];
}

// @beta
export interface CodeExecutionResult {
    outcome?: Outcome;
    output?: string;
}

// @beta
export interface CodeExecutionResultPart {
    // (undocumented)
    codeExecutionResult?: CodeExecutionResult;
    // (undocumented)
    executableCode?: never;
    // (undocumented)
    fileData: never;
    // (undocumented)
    functionCall?: never;
    // (undocumented)
    functionResponse?: never;
    // (undocumented)
    inlineData?: never;
    // (undocumented)
    text?: never;
    // (undocumented)
    thought?: never;
    // @internal (undocumented)
    thoughtSignature?: never;
}

// @beta
export interface CodeExecutionTool {
    codeExecution: {};
}

// @public
export interface Content {
    // (undocumented)
    parts: Part[];
    // (undocumented)
    role: Role;
}

// @public
export interface CountTokensRequest {
    // (undocumented)
    contents: Content[];
    generationConfig?: GenerationConfig;
    systemInstruction?: string | Part | Content;
    tools?: Tool[];
}

// @public
export interface CountTokensResponse {
    promptTokensDetails?: ModalityTokenCount[];
    // @deprecated (undocumented)
    totalBillableCharacters?: number;
    totalTokens: number;
}

// @public
export interface CustomErrorData {
    errorDetails?: ErrorDetails[];
    response?: GenerateContentResponse;
    status?: number;
    statusText?: string;
}

// @public
interface Date_2 {
    // (undocumented)
    day: number;
    // (undocumented)
    month: number;
    // (undocumented)
    year: number;
}

export { Date_2 as Date }

// @public
export interface EnhancedGenerateContentResponse extends GenerateContentResponse {
    functionCalls: () => FunctionCall[] | undefined;
    // @beta
    inferenceSource?: InferenceSource;
    inlineDataParts: () => InlineDataPart[] | undefined;
    text: () => string;
    thoughtSummary: () => string | undefined;
}

// @public
export interface ErrorDetails {
    // (undocumented)
    '@type'?: string;
    [key: string]: unknown;
    domain?: string;
    metadata?: Record<string, unknown>;
    reason?: string;
}

// @beta
export interface ExecutableCode {
    code?: string;
    language?: Language;
}

// @beta
export interface ExecutableCodePart {
    // (undocumented)
    codeExecutionResult?: never;
    // (undocumented)
    executableCode?: ExecutableCode;
    // (undocumented)
    fileData: never;
    // (undocumented)
    functionCall?: never;
    // (undocumented)
    functionResponse?: never;
    // (undocumented)
    inlineData?: never;
    // (undocumented)
    text?: never;
    // (undocumented)
    thought?: never;
    // @internal (undocumented)
    thoughtSignature?: never;
}

// @public
export interface FileData {
    // (undocumented)
    fileUri: string;
    // (undocumented)
    mimeType: string;
}

// @public
export interface FileDataPart {
    // (undocumented)
    codeExecutionResult?: never;
    // (undocumented)
    executableCode?: never;
    // (undocumented)
    fileData: FileData;
    // (undocumented)
    functionCall?: never;
    // (undocumented)
    functionResponse?: never;
    // (undocumented)
    inlineData?: never;
    // (undocumented)
    text?: never;
    // (undocumented)
    thought?: boolean;
    // @internal (undocumented)
    thoughtSignature?: never;
}

// @public
export const FinishReason: {
    readonly STOP: "STOP";
    readonly MAX_TOKENS: "MAX_TOKENS";
    readonly SAFETY: "SAFETY";
    readonly RECITATION: "RECITATION";
    readonly OTHER: "OTHER";
    readonly BLOCKLIST: "BLOCKLIST";
    readonly PROHIBITED_CONTENT: "PROHIBITED_CONTENT";
    readonly SPII: "SPII";
    readonly MALFORMED_FUNCTION_CALL: "MALFORMED_FUNCTION_CALL";
};

// @public
export type FinishReason = (typeof FinishReason)[keyof typeof FinishReason];

// @public
export interface FunctionCall {
    // (undocumented)
    args: object;
    id?: string;
    // (undocumented)
    name: string;
}

// @public (undocumented)
export interface FunctionCallingConfig {
    // (undocumented)
    allowedFunctionNames?: string[];
    // (undocumented)
    mode?: FunctionCallingMode;
}

// @public (undocumented)
export const FunctionCallingMode: {
    readonly AUTO: "AUTO";
    readonly ANY: "ANY";
    readonly NONE: "NONE";
};

// @public (undocumented)
export type FunctionCallingMode = (typeof FunctionCallingMode)[keyof typeof FunctionCallingMode];

// @public
export interface FunctionCallPart {
    // (undocumented)
    codeExecutionResult?: never;
    // (undocumented)
    executableCode?: never;
    // (undocumented)
    functionCall: FunctionCall;
    // (undocumented)
    functionResponse?: never;
    // (undocumented)
    inlineData?: never;
    // (undocumented)
    text?: never;
    // (undocumented)
    thought?: boolean;
    // @internal (undocumented)
    thoughtSignature?: never;
}

// @public
export interface FunctionDeclaration {
    description: string;
    name: string;
    parameters?: ObjectSchema | ObjectSchemaRequest;
}

// @public
export interface FunctionDeclarationsTool {
    functionDeclarations?: FunctionDeclaration[];
}

// @public
export interface FunctionResponse {
    id?: string;
    // (undocumented)
    name: string;
    // (undocumented)
    response: object;
}

// @public
export interface FunctionResponsePart {
    // (undocumented)
    codeExecutionResult?: never;
    // (undocumented)
    executableCode?: never;
    // (undocumented)
    functionCall?: never;
    // (undocumented)
    functionResponse: FunctionResponse;
    // (undocumented)
    inlineData?: never;
    // (undocumented)
    text?: never;
    // (undocumented)
    thought?: boolean;
    // @internal (undocumented)
    thoughtSignature?: never;
}

// @public
export interface GenerateContentCandidate {
    // (undocumented)
    citationMetadata?: CitationMetadata;
    // (undocumented)
    content: Content;
    // (undocumented)
    finishMessage?: string;
    // (undocumented)
    finishReason?: FinishReason;
    // (undocumented)
    groundingMetadata?: GroundingMetadata;
    // (undocumented)
    index: number;
    // (undocumented)
    safetyRatings?: SafetyRating[];
    // Warning: (ae-incompatible-release-tags) The symbol "urlContextMetadata" is marked as @public, but its signature references "URLContextMetadata" which is marked as @beta
    //
    // (undocumented)
    urlContextMetadata?: URLContextMetadata;
}

// @public
export interface GenerateContentRequest extends BaseParams {
    // (undocumented)
    contents: Content[];
    // (undocumented)
    systemInstruction?: string | Part | Content;
    // (undocumented)
    toolConfig?: ToolConfig;
    // (undocumented)
    tools?: Tool[];
}

// @public
export interface GenerateContentResponse {
    // (undocumented)
    candidates?: GenerateContentCandidate[];
    // (undocumented)
    promptFeedback?: PromptFeedback;
    // (undocumented)
    usageMetadata?: UsageMetadata;
}

// @public
export interface GenerateContentResult {
    // (undocumented)
    response: EnhancedGenerateContentResponse;
}

// @public
export interface GenerateContentStreamResult {
    // (undocumented)
    response: Promise<EnhancedGenerateContentResponse>;
    // (undocumented)
    stream: AsyncGenerator<EnhancedGenerateContentResponse>;
}

// @public
export interface GenerationConfig {
    // (undocumented)
    candidateCount?: number;
    // (undocumented)
    frequencyPenalty?: number;
    // (undocumented)
    maxOutputTokens?: number;
    // (undocumented)
    presencePenalty?: number;
    responseMimeType?: string;
    // @beta
    responseModalities?: ResponseModality[];
    responseSchema?: TypedSchema | SchemaRequest;
    // (undocumented)
    stopSequences?: string[];
    // (undocumented)
    temperature?: number;
    thinkingConfig?: ThinkingConfig;
    // (undocumented)
    topK?: number;
    // (undocumented)
    topP?: number;
}

// @public
export interface GenerativeContentBlob {
    data: string;
    // (undocumented)
    mimeType: string;
}

// @public
export class GenerativeModel extends AIModel {
    // Warning: (ae-incompatible-release-tags) The symbol "__constructor" is marked as @public, but its signature references "ChromeAdapter" which is marked as @beta
    constructor(ai: AI, modelParams: ModelParams, requestOptions?: RequestOptions, chromeAdapter?: ChromeAdapter | undefined);
    countTokens(request: CountTokensRequest | string | Array<string | Part>): Promise<CountTokensResponse>;
    generateContent(request: GenerateContentRequest | string | Array<string | Part>): Promise<GenerateContentResult>;
    generateContentStream(request: GenerateContentRequest | string | Array<string | Part>): Promise<GenerateContentStreamResult>;
    // (undocumented)
    generationConfig: GenerationConfig;
    // (undocumented)
    requestOptions?: RequestOptions;
    // (undocumented)
    safetySettings: SafetySetting[];
    startChat(startChatParams?: StartChatParams): ChatSession;
    // (undocumented)
    systemInstruction?: Content;
    // (undocumented)
    toolConfig?: ToolConfig;
    // (undocumented)
    tools?: Tool[];
}

// @public
export function getAI(app?: FirebaseApp, options?: AIOptions): AI;

// Warning: (ae-incompatible-release-tags) The symbol "getGenerativeModel" is marked as @public, but its signature references "HybridParams" which is marked as @beta
//
// @public
export function getGenerativeModel(ai: AI, modelParams: ModelParams | HybridParams, requestOptions?: RequestOptions): GenerativeModel;

// @public
export function getImagenModel(ai: AI, modelParams: ImagenModelParams, requestOptions?: RequestOptions): ImagenModel;

// @beta
export function getLiveGenerativeModel(ai: AI, modelParams: LiveModelParams): LiveGenerativeModel;

// @beta
export function getTemplateGenerativeModel(ai: AI, requestOptions?: RequestOptions): TemplateGenerativeModel;

// @beta
export function getTemplateImagenModel(ai: AI, requestOptions?: RequestOptions): TemplateImagenModel;

// @public
export class GoogleAIBackend extends Backend {
    constructor();
    // @internal (undocumented)
    _getModelPath(project: string, model: string): string;
    // @internal (undocumented)
    _getTemplatePath(project: string, templateId: string): string;
}

// Warning: (ae-internal-missing-underscore) The name "GoogleAICitationMetadata" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface GoogleAICitationMetadata {
    // (undocumented)
    citationSources: Citation[];
}

// Warning: (ae-internal-missing-underscore) The name "GoogleAICountTokensRequest" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface GoogleAICountTokensRequest {
    // (undocumented)
    generateContentRequest: {
        model: string;
        contents: Content[];
        systemInstruction?: string | Part | Content;
        tools?: Tool[];
        generationConfig?: GenerationConfig;
    };
}

// Warning: (ae-internal-missing-underscore) The name "GoogleAIGenerateContentCandidate" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface GoogleAIGenerateContentCandidate {
    // (undocumented)
    citationMetadata?: GoogleAICitationMetadata;
    // (undocumented)
    content: Content;
    // (undocumented)
    finishMessage?: string;
    // (undocumented)
    finishReason?: FinishReason;
    // (undocumented)
    groundingMetadata?: GroundingMetadata;
    // (undocumented)
    index: number;
    // (undocumented)
    safetyRatings?: SafetyRating[];
    // (undocumented)
    urlContextMetadata?: URLContextMetadata;
}

// Warning: (ae-internal-missing-underscore) The name "GoogleAIGenerateContentResponse" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export interface GoogleAIGenerateContentResponse {
    // (undocumented)
    candidates?: GoogleAIGenerateContentCandidate[];
    // (undocumented)
    promptFeedback?: PromptFeedback;
    // (undocumented)
    usageMetadata?: UsageMetadata;
}

// @public
export interface GoogleSearch {
}

// @public
export interface GoogleSearchTool {
    googleSearch: GoogleSearch;
}

// @public
export interface GroundingChunk {
    web?: WebGroundingChunk;
}

// @public
export interface GroundingMetadata {
    groundingChunks?: GroundingChunk[];
    groundingSupports?: GroundingSupport[];
    // @deprecated (undocumented)
    retrievalQueries?: string[];
    searchEntryPoint?: SearchEntrypoint;
    webSearchQueries?: string[];
}

// @public
export interface GroundingSupport {
    groundingChunkIndices?: number[];
    segment?: Segment;
}

// @public
export const HarmBlockMethod: {
    readonly SEVERITY: "SEVERITY";
    readonly PROBABILITY: "PROBABILITY";
};

// @public
export type HarmBlockMethod = (typeof HarmBlockMethod)[keyof typeof HarmBlockMethod];

// @public
export const HarmBlockThreshold: {
    readonly BLOCK_LOW_AND_ABOVE: "BLOCK_LOW_AND_ABOVE";
    readonly BLOCK_MEDIUM_AND_ABOVE: "BLOCK_MEDIUM_AND_ABOVE";
    readonly BLOCK_ONLY_HIGH: "BLOCK_ONLY_HIGH";
    readonly BLOCK_NONE: "BLOCK_NONE";
    readonly OFF: "OFF";
};

// @public
export type HarmBlockThreshold = (typeof HarmBlockThreshold)[keyof typeof HarmBlockThreshold];

// @public
export const HarmCategory: {
    readonly HARM_CATEGORY_HATE_SPEECH: "HARM_CATEGORY_HATE_SPEECH";
    readonly HARM_CATEGORY_SEXUALLY_EXPLICIT: "HARM_CATEGORY_SEXUALLY_EXPLICIT";
    readonly HARM_CATEGORY_HARASSMENT: "HARM_CATEGORY_HARASSMENT";
    readonly HARM_CATEGORY_DANGEROUS_CONTENT: "HARM_CATEGORY_DANGEROUS_CONTENT";
};

// @public
export type HarmCategory = (typeof HarmCategory)[keyof typeof HarmCategory];

// @public
export const HarmProbability: {
    readonly NEGLIGIBLE: "NEGLIGIBLE";
    readonly LOW: "LOW";
    readonly MEDIUM: "MEDIUM";
    readonly HIGH: "HIGH";
};

// @public
export type HarmProbability = (typeof HarmProbability)[keyof typeof HarmProbability];

// @public
export const HarmSeverity: {
    readonly HARM_SEVERITY_NEGLIGIBLE: "HARM_SEVERITY_NEGLIGIBLE";
    readonly HARM_SEVERITY_LOW: "HARM_SEVERITY_LOW";
    readonly HARM_SEVERITY_MEDIUM: "HARM_SEVERITY_MEDIUM";
    readonly HARM_SEVERITY_HIGH: "HARM_SEVERITY_HIGH";
    readonly HARM_SEVERITY_UNSUPPORTED: "HARM_SEVERITY_UNSUPPORTED";
};

// @public
export type HarmSeverity = (typeof HarmSeverity)[keyof typeof HarmSeverity];

// @beta
export interface HybridParams {
    inCloudParams?: ModelParams;
    mode: InferenceMode;
    onDeviceParams?: OnDeviceParams;
}

// @public
export const ImagenAspectRatio: {
    readonly SQUARE: "1:1";
    readonly LANDSCAPE_3x4: "3:4";
    readonly PORTRAIT_4x3: "4:3";
    readonly LANDSCAPE_16x9: "16:9";
    readonly PORTRAIT_9x16: "9:16";
};

// @public
export type ImagenAspectRatio = (typeof ImagenAspectRatio)[keyof typeof ImagenAspectRatio];

// @public
export interface ImagenGCSImage {
    gcsURI: string;
    mimeType: string;
}

// @public
export interface ImagenGenerationConfig {
    addWatermark?: boolean;
    aspectRatio?: ImagenAspectRatio;
    imageFormat?: ImagenImageFormat;
    negativePrompt?: string;
    numberOfImages?: number;
}

// @public
export interface ImagenGenerationResponse<T extends ImagenInlineImage | ImagenGCSImage> {
    filteredReason?: string;
    images: T[];
}

// @public
export class ImagenImageFormat {
    compressionQuality?: number;
    static jpeg(compressionQuality?: number): ImagenImageFormat;
    mimeType: string;
    static png(): ImagenImageFormat;
}

// @public
export interface ImagenInlineImage {
    bytesBase64Encoded: string;
    mimeType: string;
}

// @public
export class ImagenModel extends AIModel {
    constructor(ai: AI, modelParams: ImagenModelParams, requestOptions?: RequestOptions | undefined);
    generateImages(prompt: string): Promise<ImagenGenerationResponse<ImagenInlineImage>>;
    // @internal
    generateImagesGCS(prompt: string, gcsURI: string): Promise<ImagenGenerationResponse<ImagenGCSImage>>;
    generationConfig?: ImagenGenerationConfig;
    // (undocumented)
    requestOptions?: RequestOptions | undefined;
    safetySettings?: ImagenSafetySettings;
}

// @public
export interface ImagenModelParams {
    generationConfig?: ImagenGenerationConfig;
    model: string;
    safetySettings?: ImagenSafetySettings;
}

// @public
export const ImagenPersonFilterLevel: {
    readonly BLOCK_ALL: "dont_allow";
    readonly ALLOW_ADULT: "allow_adult";
    readonly ALLOW_ALL: "allow_all";
};

// @public
export type ImagenPersonFilterLevel = (typeof ImagenPersonFilterLevel)[keyof typeof ImagenPersonFilterLevel];

// @public
export const ImagenSafetyFilterLevel: {
    readonly BLOCK_LOW_AND_ABOVE: "block_low_and_above";
    readonly BLOCK_MEDIUM_AND_ABOVE: "block_medium_and_above";
    readonly BLOCK_ONLY_HIGH: "block_only_high";
    readonly BLOCK_NONE: "block_none";
};

// @public
export type ImagenSafetyFilterLevel = (typeof ImagenSafetyFilterLevel)[keyof typeof ImagenSafetyFilterLevel];

// @public
export interface ImagenSafetySettings {
    personFilterLevel?: ImagenPersonFilterLevel;
    safetyFilterLevel?: ImagenSafetyFilterLevel;
}

// @beta
export const InferenceMode: {
    readonly PREFER_ON_DEVICE: "prefer_on_device";
    readonly ONLY_ON_DEVICE: "only_on_device";
    readonly ONLY_IN_CLOUD: "only_in_cloud";
    readonly PREFER_IN_CLOUD: "prefer_in_cloud";
};

// @beta
export type InferenceMode = (typeof InferenceMode)[keyof typeof InferenceMode];

// @beta
export const InferenceSource: {
    readonly ON_DEVICE: "on_device";
    readonly IN_CLOUD: "in_cloud";
};

// @beta
export type InferenceSource = (typeof InferenceSource)[keyof typeof InferenceSource];

// @public
export interface InlineDataPart {
    // (undocumented)
    codeExecutionResult?: never;
    // (undocumented)
    executableCode?: never;
    // (undocumented)
    functionCall?: never;
    // (undocumented)
    functionResponse?: never;
    // (undocumented)
    inlineData: GenerativeContentBlob;
    // (undocumented)
    text?: never;
    // (undocumented)
    thought?: boolean;
    // @internal (undocumented)
    thoughtSignature?: never;
    videoMetadata?: VideoMetadata;
}

// @public
export class IntegerSchema extends Schema {
    constructor(schemaParams?: SchemaParams);
}

// @beta
export const Language: {
    UNSPECIFIED: string;
    PYTHON: string;
};

// @beta
export type Language = (typeof Language)[keyof typeof Language];

// @beta
export interface LanguageModelCreateCoreOptions {
    // (undocumented)
    expectedInputs?: LanguageModelExpected[];
    // (undocumented)
    temperature?: number;
    // (undocumented)
    topK?: number;
}

// @beta
export interface LanguageModelCreateOptions extends LanguageModelCreateCoreOptions {
    // (undocumented)
    initialPrompts?: LanguageModelMessage[];
    // (undocumented)
    signal?: AbortSignal;
}

// @beta
export interface LanguageModelExpected {
    // (undocumented)
    languages?: string[];
    // (undocumented)
    type: LanguageModelMessageType;
}

// @beta
export interface LanguageModelMessage {
    // (undocumented)
    content: LanguageModelMessageContent[];
    // (undocumented)
    role: LanguageModelMessageRole;
}

// @beta
export interface LanguageModelMessageContent {
    // (undocumented)
    type: LanguageModelMessageType;
    // (undocumented)
    value: LanguageModelMessageContentValue;
}

// @beta
export type LanguageModelMessageContentValue = ImageBitmapSource | AudioBuffer | BufferSource | string;

// @beta
export type LanguageModelMessageRole = 'system' | 'user' | 'assistant';

// @beta
export type LanguageModelMessageType = 'text' | 'image' | 'audio';

// @beta
export interface LanguageModelPromptOptions {
    // (undocumented)
    responseConstraint?: object;
}

// @beta
export interface LiveGenerationConfig {
    frequencyPenalty?: number;
    inputAudioTranscription?: AudioTranscriptionConfig;
    maxOutputTokens?: number;
    outputAudioTranscription?: AudioTranscriptionConfig;
    presencePenalty?: number;
    responseModalities?: ResponseModality[];
    speechConfig?: SpeechConfig;
    temperature?: number;
    topK?: number;
    topP?: number;
}

// @beta
export class LiveGenerativeModel extends AIModel {
    // Warning: (ae-forgotten-export) The symbol "WebSocketHandler" needs to be exported by the entry point index.d.ts
    //
    // @internal
    constructor(ai: AI, modelParams: LiveModelParams,
    _webSocketHandler: WebSocketHandler);
    connect(): Promise<LiveSession>;
    // (undocumented)
    generationConfig: LiveGenerationConfig;
    // (undocumented)
    systemInstruction?: Content;
    // (undocumented)
    toolConfig?: ToolConfig;
    // (undocumented)
    tools?: Tool[];
    }

// @beta
export interface LiveModelParams {
    // (undocumented)
    generationConfig?: LiveGenerationConfig;
    // (undocumented)
    model: string;
    // (undocumented)
    systemInstruction?: string | Part | Content;
    // (undocumented)
    toolConfig?: ToolConfig;
    // (undocumented)
    tools?: Tool[];
}

// @beta
export const LiveResponseType: {
    SERVER_CONTENT: string;
    TOOL_CALL: string;
    TOOL_CALL_CANCELLATION: string;
};

// @beta
export type LiveResponseType = (typeof LiveResponseType)[keyof typeof LiveResponseType];

// @beta
export interface LiveServerContent {
    inputTranscription?: Transcription;
    interrupted?: boolean;
    modelTurn?: Content;
    outputTranscription?: Transcription;
    turnComplete?: boolean;
    // (undocumented)
    type: 'serverContent';
}

// @beta
export interface LiveServerToolCall {
    functionCalls: FunctionCall[];
    // (undocumented)
    type: 'toolCall';
}

// @beta
export interface LiveServerToolCallCancellation {
    functionIds: string[];
    // (undocumented)
    type: 'toolCallCancellation';
}

// @beta
export class LiveSession {
    // @internal
    constructor(webSocketHandler: WebSocketHandler, serverMessages: AsyncGenerator<unknown>);
    close(): Promise<void>;
    inConversation: boolean;
    isClosed: boolean;
    receive(): AsyncGenerator<LiveServerContent | LiveServerToolCall | LiveServerToolCallCancellation>;
    send(request: string | Array<string | Part>, turnComplete?: boolean): Promise<void>;
    sendAudioRealtime(blob: GenerativeContentBlob): Promise<void>;
    sendFunctionResponses(functionResponses: FunctionResponse[]): Promise<void>;
    // @deprecated
    sendMediaChunks(mediaChunks: GenerativeContentBlob[]): Promise<void>;
    // @deprecated (undocumented)
    sendMediaStream(mediaChunkStream: ReadableStream<GenerativeContentBlob>): Promise<void>;
    sendTextRealtime(text: string): Promise<void>;
    sendVideoRealtime(blob: GenerativeContentBlob): Promise<void>;
    }

// @public
export const Modality: {
    readonly MODALITY_UNSPECIFIED: "MODALITY_UNSPECIFIED";
    readonly TEXT: "TEXT";
    readonly IMAGE: "IMAGE";
    readonly VIDEO: "VIDEO";
    readonly AUDIO: "AUDIO";
    readonly DOCUMENT: "DOCUMENT";
};

// @public
export type Modality = (typeof Modality)[keyof typeof Modality];

// @public
export interface ModalityTokenCount {
    modality: Modality;
    tokenCount: number;
}

// @public
export interface ModelParams extends BaseParams {
    // (undocumented)
    model: string;
    // (undocumented)
    systemInstruction?: string | Part | Content;
    // (undocumented)
    toolConfig?: ToolConfig;
    // (undocumented)
    tools?: Tool[];
}

// @public
export class NumberSchema extends Schema {
    constructor(schemaParams?: SchemaParams);
}

// @public
export class ObjectSchema extends Schema {
    constructor(schemaParams: SchemaParams, properties: {
        [k: string]: TypedSchema;
    }, optionalProperties?: string[]);
    // (undocumented)
    optionalProperties: string[];
    // (undocumented)
    properties: {
        [k: string]: TypedSchema;
    };
    // @internal (undocumented)
    toJSON(): SchemaRequest;
}

// @public
export interface ObjectSchemaRequest extends SchemaRequest {
    optionalProperties?: never;
    // (undocumented)
    type: 'object';
}

// @beta
export interface OnDeviceParams {
    // (undocumented)
    createOptions?: LanguageModelCreateOptions;
    // (undocumented)
    promptOptions?: LanguageModelPromptOptions;
}

// @beta
export const Outcome: {
    UNSPECIFIED: string;
    OK: string;
    FAILED: string;
    DEADLINE_EXCEEDED: string;
};

// @beta
export type Outcome = (typeof Outcome)[keyof typeof Outcome];

// Warning: (ae-incompatible-release-tags) The symbol "Part" is marked as @public, but its signature references "ExecutableCodePart" which is marked as @beta
// Warning: (ae-incompatible-release-tags) The symbol "Part" is marked as @public, but its signature references "CodeExecutionResultPart" which is marked as @beta
//
// @public
export type Part = TextPart | InlineDataPart | FunctionCallPart | FunctionResponsePart | FileDataPart | ExecutableCodePart | CodeExecutionResultPart;

// @public
export const POSSIBLE_ROLES: readonly ["user", "model", "function", "system"];

// @beta
export interface PrebuiltVoiceConfig {
    voiceName?: string;
}

// @public
export interface PromptFeedback {
    // (undocumented)
    blockReason?: BlockReason;
    blockReasonMessage?: string;
    // (undocumented)
    safetyRatings: SafetyRating[];
}

// @public
export interface RequestOptions {
    baseUrl?: string;
    timeout?: number;
}

// @beta
export const ResponseModality: {
    readonly TEXT: "TEXT";
    readonly IMAGE: "IMAGE";
    readonly AUDIO: "AUDIO";
};

// @beta
export type ResponseModality = (typeof ResponseModality)[keyof typeof ResponseModality];

// @public (undocumented)
export interface RetrievedContextAttribution {
    // (undocumented)
    title: string;
    // (undocumented)
    uri: string;
}

// @public
export type Role = (typeof POSSIBLE_ROLES)[number];

// @public
export interface SafetyRating {
    // (undocumented)
    blocked: boolean;
    // (undocumented)
    category: HarmCategory;
    // (undocumented)
    probability: HarmProbability;
    probabilityScore: number;
    severity: HarmSeverity;
    severityScore: number;
}

// @public
export interface SafetySetting {
    // (undocumented)
    category: HarmCategory;
    method?: HarmBlockMethod;
    // (undocumented)
    threshold: HarmBlockThreshold;
}

// @public
export abstract class Schema implements SchemaInterface {
    constructor(schemaParams: SchemaInterface);
    [key: string]: unknown;
    // (undocumented)
    static anyOf(anyOfParams: SchemaParams & {
        anyOf: TypedSchema[];
    }): AnyOfSchema;
    // (undocumented)
    static array(arrayParams: SchemaParams & {
        items: Schema;
    }): ArraySchema;
    // (undocumented)
    static boolean(booleanParams?: SchemaParams): BooleanSchema;
    description?: string;
    // (undocumented)
    static enumString(stringParams: SchemaParams & {
        enum: string[];
    }): StringSchema;
    example?: unknown;
    format?: string;
    // (undocumented)
    static integer(integerParams?: SchemaParams): IntegerSchema;
    items?: SchemaInterface;
    maxItems?: number;
    minItems?: number;
    nullable: boolean;
    // (undocumented)
    static number(numberParams?: SchemaParams): NumberSchema;
    // (undocumented)
    static object(objectParams: SchemaParams & {
        properties: {
            [k: string]: Schema;
        };
        optionalProperties?: string[];
    }): ObjectSchema;
    // (undocumented)
    static string(stringParams?: SchemaParams): StringSchema;
    // @internal
    toJSON(): SchemaRequest;
    type?: SchemaType;
}

// @public
export interface SchemaInterface extends SchemaShared<SchemaInterface> {
    type?: SchemaType;
}

// @public
export interface SchemaParams extends SchemaShared<SchemaInterface> {
}

// @public
export interface SchemaRequest extends SchemaShared<SchemaRequest> {
    required?: string[];
    type?: SchemaType;
}

// @public
export interface SchemaShared<T> {
    // (undocumented)
    [key: string]: unknown;
    anyOf?: T[];
    description?: string;
    enum?: string[];
    example?: unknown;
    format?: string;
    items?: T;
    maximum?: number;
    maxItems?: number;
    minimum?: number;
    minItems?: number;
    nullable?: boolean;
    properties?: {
        [k: string]: T;
    };
    propertyOrdering?: string[];
    title?: string;
}

// @public
export const SchemaType: {
    readonly STRING: "string";
    readonly NUMBER: "number";
    readonly INTEGER: "integer";
    readonly BOOLEAN: "boolean";
    readonly ARRAY: "array";
    readonly OBJECT: "object";
};

// @public
export type SchemaType = (typeof SchemaType)[keyof typeof SchemaType];

// @public
export interface SearchEntrypoint {
    renderedContent?: string;
}

// @public
export interface Segment {
    endIndex: number;
    partIndex: number;
    startIndex: number;
    text: string;
}

// @beta
export interface SpeechConfig {
    voiceConfig?: VoiceConfig;
}

// @beta
export function startAudioConversation(liveSession: LiveSession, options?: StartAudioConversationOptions): Promise<AudioConversationController>;

// @beta
export interface StartAudioConversationOptions {
    functionCallingHandler?: (functionCalls: FunctionCall[]) => Promise<FunctionResponse>;
}

// @public
export interface StartChatParams extends BaseParams {
    // (undocumented)
    history?: Content[];
    // (undocumented)
    systemInstruction?: string | Part | Content;
    // (undocumented)
    toolConfig?: ToolConfig;
    // (undocumented)
    tools?: Tool[];
}

// @public
export class StringSchema extends Schema {
    constructor(schemaParams?: SchemaParams, enumValues?: string[]);
    // (undocumented)
    enum?: string[];
    // @internal (undocumented)
    toJSON(): SchemaRequest;
}

// @beta
export class TemplateGenerativeModel {
    constructor(ai: AI, requestOptions?: RequestOptions);
    // @internal (undocumented)
    _apiSettings: ApiSettings;
    generateContent(templateId: string, templateVariables: object): Promise<GenerateContentResult>;
    generateContentStream(templateId: string, templateVariables: object): Promise<GenerateContentStreamResult>;
    requestOptions?: RequestOptions;
}

// @beta
export class TemplateImagenModel {
    constructor(ai: AI, requestOptions?: RequestOptions);
    // @internal (undocumented)
    _apiSettings: ApiSettings;
    generateImages(templateId: string, templateVariables: object): Promise<ImagenGenerationResponse<ImagenInlineImage>>;
    requestOptions?: RequestOptions;
}

// @public
export interface TextPart {
    // (undocumented)
    codeExecutionResult?: never;
    // (undocumented)
    executableCode?: never;
    // (undocumented)
    functionCall?: never;
    // (undocumented)
    functionResponse?: never;
    // (undocumented)
    inlineData?: never;
    // (undocumented)
    text: string;
    // (undocumented)
    thought?: boolean;
    // @internal (undocumented)
    thoughtSignature?: string;
}

// @public
export interface ThinkingConfig {
    includeThoughts?: boolean;
    thinkingBudget?: number;
}

// Warning: (ae-incompatible-release-tags) The symbol "Tool" is marked as @public, but its signature references "CodeExecutionTool" which is marked as @beta
// Warning: (ae-incompatible-release-tags) The symbol "Tool" is marked as @public, but its signature references "URLContextTool" which is marked as @beta
//
// @public
export type Tool = FunctionDeclarationsTool | GoogleSearchTool | CodeExecutionTool | URLContextTool;

// @public
export interface ToolConfig {
    // (undocumented)
    functionCallingConfig?: FunctionCallingConfig;
}

// @beta
export interface Transcription {
    text?: string;
}

// @public
export type TypedSchema = IntegerSchema | NumberSchema | StringSchema | BooleanSchema | ObjectSchema | ArraySchema | AnyOfSchema;

// @beta
export interface URLContext {
}

// @beta
export interface URLContextMetadata {
    urlMetadata: URLMetadata[];
}

// @beta
export interface URLContextTool {
    urlContext: URLContext;
}

// @beta
export interface URLMetadata {
    retrievedUrl?: string;
    urlRetrievalStatus?: URLRetrievalStatus;
}

// @beta
export const URLRetrievalStatus: {
    URL_RETRIEVAL_STATUS_UNSPECIFIED: string;
    URL_RETRIEVAL_STATUS_SUCCESS: string;
    URL_RETRIEVAL_STATUS_ERROR: string;
    URL_RETRIEVAL_STATUS_PAYWALL: string;
    URL_RETRIEVAL_STATUS_UNSAFE: string;
};

// @beta
export type URLRetrievalStatus = (typeof URLRetrievalStatus)[keyof typeof URLRetrievalStatus];

// @public
export interface UsageMetadata {
    // (undocumented)
    candidatesTokenCount: number;
    // (undocumented)
    candidatesTokensDetails?: ModalityTokenCount[];
    // (undocumented)
    promptTokenCount: number;
    // (undocumented)
    promptTokensDetails?: ModalityTokenCount[];
    thoughtsTokenCount?: number;
    toolUsePromptTokenCount?: number;
    toolUsePromptTokensDetails?: ModalityTokenCount[];
    // (undocumented)
    totalTokenCount: number;
}

// @public
export class VertexAIBackend extends Backend {
    constructor(location?: string);
    // @internal (undocumented)
    _getModelPath(project: string, model: string): string;
    // @internal (undocumented)
    _getTemplatePath(project: string, templateId: string): string;
    readonly location: string;
}

// @public
export interface VideoMetadata {
    endOffset: string;
    startOffset: string;
}

// @beta
export interface VoiceConfig {
    prebuiltVoiceConfig?: PrebuiltVoiceConfig;
}

// @public (undocumented)
export interface WebAttribution {
    // (undocumented)
    title: string;
    // (undocumented)
    uri: string;
}

// @public
export interface WebGroundingChunk {
    domain?: string;
    title?: string;
    uri?: string;
}


```
