## API Report File for "@firebase/analytics"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { FirebaseApp } from '@firebase/app';

// @public
export interface Analytics {
    app: FirebaseApp;
}

// @public
export interface AnalyticsCallOptions {
    global: boolean;
}

// @public
export interface AnalyticsSettings {
    config?: GtagConfigParams | EventParams;
}

// @public
export interface ConsentSettings {
    // (undocumented)
    [key: string]: unknown;
    ad_personalization?: ConsentStatusString;
    ad_storage?: ConsentStatusString;
    ad_user_data?: ConsentStatusString;
    analytics_storage?: ConsentStatusString;
    functionality_storage?: ConsentStatusString;
    personalization_storage?: ConsentStatusString;
    security_storage?: ConsentStatusString;
}

// @public
export type ConsentStatusString = 'granted' | 'denied';

// @public
export interface ControlParams {
    // (undocumented)
    event_callback?: () => void;
    // (undocumented)
    event_timeout?: number;
    // (undocumented)
    groups?: string | string[];
    // (undocumented)
    send_to?: string | string[];
}

// @public
export type Currency = string | number;

// @public
export type CustomEventName<T> = T extends EventNameString ? never : T;

// @public
export interface CustomParams {
    // (undocumented)
    [key: string]: unknown;
}

// @public
export type EventNameString = 'add_payment_info' | 'add_shipping_info' | 'add_to_cart' | 'add_to_wishlist' | 'begin_checkout' | 'checkout_progress' | 'exception' | 'generate_lead' | 'login' | 'page_view' | 'purchase' | 'refund' | 'remove_from_cart' | 'screen_view' | 'search' | 'select_content' | 'select_item' | 'select_promotion' | 'set_checkout_option' | 'share' | 'sign_up' | 'timing_complete' | 'view_cart' | 'view_item' | 'view_item_list' | 'view_promotion' | 'view_search_results';

// @public
export interface EventParams {
    // (undocumented)
    [key: string]: unknown;
    // (undocumented)
    affiliation?: string;
    // (undocumented)
    checkout_option?: string;
    // (undocumented)
    checkout_step?: number;
    // (undocumented)
    content_type?: string;
    // (undocumented)
    coupon?: string;
    // (undocumented)
    currency?: string;
    // (undocumented)
    description?: string;
    // (undocumented)
    event_category?: string;
    // (undocumented)
    event_label?: string;
    // (undocumented)
    fatal?: boolean;
    firebase_screen?: string;
    firebase_screen_class?: string;
    // (undocumented)
    item_id?: string;
    // (undocumented)
    item_list_id?: string;
    // (undocumented)
    item_list_name?: string;
    // (undocumented)
    items?: Item[];
    // (undocumented)
    method?: string;
    // (undocumented)
    number?: string;
    // (undocumented)
    page_location?: string;
    // (undocumented)
    page_path?: string;
    // (undocumented)
    page_title?: string;
    // (undocumented)
    payment_type?: string;
    // (undocumented)
    promotion_id?: string;
    // (undocumented)
    promotion_name?: string;
    // (undocumented)
    promotions?: Promotion[];
    // (undocumented)
    screen_name?: string;
    // (undocumented)
    search_term?: string;
    // (undocumented)
    shipping?: Currency;
    // (undocumented)
    shipping_tier?: string;
    // (undocumented)
    tax?: Currency;
    // (undocumented)
    transaction_id?: string;
    // (undocumented)
    value?: number;
}

// @public
export function getAnalytics(app?: FirebaseApp): Analytics;

// @public
export function getGoogleAnalyticsClientId(analyticsInstance: Analytics): Promise<string>;

// @public
export interface GtagConfigParams {
    // (undocumented)
    [key: string]: unknown;
    'allow_ad_personalization_signals'?: boolean;
    'allow_google_signals'?: boolean;
    'cookie_domain'?: string;
    'cookie_expires'?: number;
    'cookie_flags'?: string;
    'cookie_prefix'?: string;
    'cookie_update'?: boolean;
    'page_location'?: string;
    'page_title'?: string;
    'send_page_view'?: boolean;
}

// @public
export function initializeAnalytics(app: FirebaseApp, options?: AnalyticsSettings): Analytics;

// @public
export function isSupported(): Promise<boolean>;

// @public
export interface Item {
    // (undocumented)
    affiliation?: string;
    // @deprecated (undocumented)
    brand?: string;
    // @deprecated (undocumented)
    category?: string;
    // (undocumented)
    coupon?: string;
    // (undocumented)
    creative_name?: string;
    // (undocumented)
    creative_slot?: string;
    // (undocumented)
    discount?: Currency;
    // @deprecated (undocumented)
    id?: string;
    // (undocumented)
    index?: number;
    // (undocumented)
    item_brand?: string;
    // (undocumented)
    item_category?: string;
    // (undocumented)
    item_category2?: string;
    // (undocumented)
    item_category3?: string;
    // (undocumented)
    item_category4?: string;
    // (undocumented)
    item_category5?: string;
    // (undocumented)
    item_id?: string;
    // (undocumented)
    item_list_id?: string;
    // (undocumented)
    item_list_name?: string;
    // (undocumented)
    item_name?: string;
    // (undocumented)
    item_variant?: string;
    // (undocumented)
    location_id?: string;
    // @deprecated (undocumented)
    name?: string;
    // (undocumented)
    price?: Currency;
    // (undocumented)
    promotion_id?: string;
    // (undocumented)
    promotion_name?: string;
    // (undocumented)
    quantity?: number;
}

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'add_payment_info', eventParams?: {
    coupon?: EventParams['coupon'];
    currency?: EventParams['currency'];
    items?: EventParams['items'];
    payment_type?: EventParams['payment_type'];
    value?: EventParams['value'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'add_shipping_info', eventParams?: {
    coupon?: EventParams['coupon'];
    currency?: EventParams['currency'];
    items?: EventParams['items'];
    shipping_tier?: EventParams['shipping_tier'];
    value?: EventParams['value'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'add_to_cart' | 'add_to_wishlist' | 'remove_from_cart', eventParams?: {
    currency?: EventParams['currency'];
    value?: EventParams['value'];
    items?: EventParams['items'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'begin_checkout', eventParams?: {
    currency?: EventParams['currency'];
    coupon?: EventParams['coupon'];
    value?: EventParams['value'];
    items?: EventParams['items'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'checkout_progress', eventParams?: {
    currency?: EventParams['currency'];
    coupon?: EventParams['coupon'];
    value?: EventParams['value'];
    items?: EventParams['items'];
    checkout_step?: EventParams['checkout_step'];
    checkout_option?: EventParams['checkout_option'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'exception', eventParams?: {
    description?: EventParams['description'];
    fatal?: EventParams['fatal'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'generate_lead', eventParams?: {
    value?: EventParams['value'];
    currency?: EventParams['currency'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'login', eventParams?: {
    method?: EventParams['method'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'page_view', eventParams?: {
    page_title?: string;
    page_location?: string;
    page_path?: string;
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'purchase' | 'refund', eventParams?: {
    value?: EventParams['value'];
    currency?: EventParams['currency'];
    transaction_id: EventParams['transaction_id'];
    tax?: EventParams['tax'];
    shipping?: EventParams['shipping'];
    items?: EventParams['items'];
    coupon?: EventParams['coupon'];
    affiliation?: EventParams['affiliation'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'screen_view', eventParams?: {
    firebase_screen: EventParams['firebase_screen'];
    firebase_screen_class: EventParams['firebase_screen_class'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'search' | 'view_search_results', eventParams?: {
    search_term?: EventParams['search_term'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'select_content', eventParams?: {
    content_type?: EventParams['content_type'];
    item_id?: EventParams['item_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'select_item', eventParams?: {
    items?: EventParams['items'];
    item_list_name?: EventParams['item_list_name'];
    item_list_id?: EventParams['item_list_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'select_promotion' | 'view_promotion', eventParams?: {
    items?: EventParams['items'];
    promotion_id?: EventParams['promotion_id'];
    promotion_name?: EventParams['promotion_name'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'set_checkout_option', eventParams?: {
    checkout_step?: EventParams['checkout_step'];
    checkout_option?: EventParams['checkout_option'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'share', eventParams?: {
    method?: EventParams['method'];
    content_type?: EventParams['content_type'];
    item_id?: EventParams['item_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'sign_up', eventParams?: {
    method?: EventParams['method'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'timing_complete', eventParams?: {
    name: string;
    value: number;
    event_category?: string;
    event_label?: string;
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'view_cart' | 'view_item', eventParams?: {
    currency?: EventParams['currency'];
    items?: EventParams['items'];
    value?: EventParams['value'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent(analyticsInstance: Analytics, eventName: 'view_item_list', eventParams?: {
    items?: EventParams['items'];
    item_list_name?: EventParams['item_list_name'];
    item_list_id?: EventParams['item_list_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public
export function logEvent<T extends string>(analyticsInstance: Analytics, eventName: CustomEventName<T>, eventParams?: {
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;

// @public @deprecated
export interface Promotion {
    // (undocumented)
    creative_name?: string;
    // (undocumented)
    creative_slot?: string;
    // (undocumented)
    id?: string;
    // (undocumented)
    name?: string;
}

// @public
export function setAnalyticsCollectionEnabled(analyticsInstance: Analytics, enabled: boolean): void;

// @public
export function setConsent(consentSettings: ConsentSettings): void;

// @public @deprecated
export function setCurrentScreen(analyticsInstance: Analytics, screenName: string, options?: AnalyticsCallOptions): void;

// @public
export function setDefaultEventParameters(customParams: CustomParams): void;

// @public
export function settings(options: SettingsOptions): void;

// @public
export interface SettingsOptions {
    dataLayerName?: string;
    gtagName?: string;
}

// @public
export function setUserId(analyticsInstance: Analytics, id: string | null, options?: AnalyticsCallOptions): void;

// @public
export function setUserProperties(analyticsInstance: Analytics, properties: CustomParams, options?: AnalyticsCallOptions): void;


```
