## API Report File for "@firebase/auth"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { CompleteFn } from '@firebase/util';
import { ErrorFactory } from '@firebase/util';
import { ErrorFn } from '@firebase/util';
import { FirebaseApp } from '@firebase/app';
import { FirebaseError } from '@firebase/util';
import { NextFn } from '@firebase/util';
import { Observer } from '@firebase/util';
import { Unsubscribe } from '@firebase/util';

// @public
export interface ActionCodeInfo {
    data: {
        email?: string | null;
        multiFactorInfo?: MultiFactorInfo | null;
        previousEmail?: string | null;
    };
    operation: (typeof ActionCodeOperation)[keyof typeof ActionCodeOperation];
}

// @public
export const ActionCodeOperation: {
    readonly EMAIL_SIGNIN: "EMAIL_SIGNIN";
    readonly PASSWORD_RESET: "PASSWORD_RESET";
    readonly RECOVER_EMAIL: "RECOVER_EMAIL";
    readonly REVERT_SECOND_FACTOR_ADDITION: "REVERT_SECOND_FACTOR_ADDITION";
    readonly VERIFY_AND_CHANGE_EMAIL: "VERIFY_AND_CHANGE_EMAIL";
    readonly VERIFY_EMAIL: "VERIFY_EMAIL";
};

// @public
export interface ActionCodeSettings {
    android?: {
        installApp?: boolean;
        minimumVersion?: string;
        packageName: string;
    };
    // @deprecated
    dynamicLinkDomain?: string;
    handleCodeInApp?: boolean;
    iOS?: {
        bundleId: string;
    };
    linkDomain?: string;
    url: string;
}

// @public
export class ActionCodeURL {
    // @internal
    constructor(actionLink: string);
    readonly apiKey: string;
    readonly code: string;
    readonly continueUrl: string | null;
    readonly languageCode: string | null;
    readonly operation: string;
    static parseLink(link: string): ActionCodeURL | null;
    readonly tenantId: string | null;
}

// @public
export interface AdditionalUserInfo {
    readonly isNewUser: boolean;
    readonly profile: Record<string, unknown> | null;
    readonly providerId: string | null;
    readonly username?: string | null;
}

// @public
export interface ApplicationVerifier {
    readonly type: string;
    verify(): Promise<string>;
}

// @public
export function applyActionCode(auth: Auth, oobCode: string): Promise<void>;

// @public
export interface Auth {
    readonly app: FirebaseApp;
    authStateReady(): Promise<void>;
    beforeAuthStateChanged(callback: (user: User | null) => void | Promise<void>, onAbort?: () => void): Unsubscribe;
    readonly config: Config;
    readonly currentUser: User | null;
    readonly emulatorConfig: EmulatorConfig | null;
    languageCode: string | null;
    readonly name: string;
    onAuthStateChanged(nextOrObserver: NextOrObserver<User | null>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;
    onIdTokenChanged(nextOrObserver: NextOrObserver<User | null>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;
    setPersistence(persistence: Persistence): Promise<void>;
    readonly settings: AuthSettings;
    signOut(): Promise<void>;
    tenantId: string | null;
    updateCurrentUser(user: User | null): Promise<void>;
    useDeviceLanguage(): void;
}

// @public
export class AuthCredential {
    // @internal
    protected constructor(
    providerId: string,
    signInMethod: string);
    // Warning: (ae-forgotten-export) The symbol "AuthInternal" needs to be exported by the entry point index.d.ts
    // Warning: (ae-forgotten-export) The symbol "PhoneOrOauthTokenResponse" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _getIdTokenResponse(_auth: AuthInternal): Promise<PhoneOrOauthTokenResponse>;
    // @internal (undocumented)
    _getReauthenticationResolver(_auth: AuthInternal): Promise<IdTokenResponse>;
    // Warning: (ae-forgotten-export) The symbol "IdTokenResponse" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _linkToIdToken(_auth: AuthInternal, _idToken: string): Promise<IdTokenResponse>;
    readonly providerId: string;
    readonly signInMethod: string;
    toJSON(): object;
}

// @public
export interface AuthError extends FirebaseError {
    readonly customData: {
        readonly appName: string;
        readonly email?: string;
        readonly phoneNumber?: string;
        readonly tenantId?: string;
    };
}

// @public
export const AuthErrorCodes: {
    readonly ADMIN_ONLY_OPERATION: "auth/admin-restricted-operation";
    readonly ARGUMENT_ERROR: "auth/argument-error";
    readonly APP_NOT_AUTHORIZED: "auth/app-not-authorized";
    readonly APP_NOT_INSTALLED: "auth/app-not-installed";
    readonly CAPTCHA_CHECK_FAILED: "auth/captcha-check-failed";
    readonly CODE_EXPIRED: "auth/code-expired";
    readonly CORDOVA_NOT_READY: "auth/cordova-not-ready";
    readonly CORS_UNSUPPORTED: "auth/cors-unsupported";
    readonly CREDENTIAL_ALREADY_IN_USE: "auth/credential-already-in-use";
    readonly CREDENTIAL_MISMATCH: "auth/custom-token-mismatch";
    readonly CREDENTIAL_TOO_OLD_LOGIN_AGAIN: "auth/requires-recent-login";
    readonly DEPENDENT_SDK_INIT_BEFORE_AUTH: "auth/dependent-sdk-initialized-before-auth";
    readonly DYNAMIC_LINK_NOT_ACTIVATED: "auth/dynamic-link-not-activated";
    readonly EMAIL_CHANGE_NEEDS_VERIFICATION: "auth/email-change-needs-verification";
    readonly EMAIL_EXISTS: "auth/email-already-in-use";
    readonly EMULATOR_CONFIG_FAILED: "auth/emulator-config-failed";
    readonly EXPIRED_OOB_CODE: "auth/expired-action-code";
    readonly EXPIRED_POPUP_REQUEST: "auth/cancelled-popup-request";
    readonly INTERNAL_ERROR: "auth/internal-error";
    readonly INVALID_API_KEY: "auth/invalid-api-key";
    readonly INVALID_APP_CREDENTIAL: "auth/invalid-app-credential";
    readonly INVALID_APP_ID: "auth/invalid-app-id";
    readonly INVALID_AUTH: "auth/invalid-user-token";
    readonly INVALID_AUTH_EVENT: "auth/invalid-auth-event";
    readonly INVALID_CERT_HASH: "auth/invalid-cert-hash";
    readonly INVALID_CODE: "auth/invalid-verification-code";
    readonly INVALID_CONTINUE_URI: "auth/invalid-continue-uri";
    readonly INVALID_CORDOVA_CONFIGURATION: "auth/invalid-cordova-configuration";
    readonly INVALID_CUSTOM_TOKEN: "auth/invalid-custom-token";
    readonly INVALID_DYNAMIC_LINK_DOMAIN: "auth/invalid-dynamic-link-domain";
    readonly INVALID_EMAIL: "auth/invalid-email";
    readonly INVALID_EMULATOR_SCHEME: "auth/invalid-emulator-scheme";
    readonly INVALID_IDP_RESPONSE: "auth/invalid-credential";
    readonly INVALID_LOGIN_CREDENTIALS: "auth/invalid-credential";
    readonly INVALID_MESSAGE_PAYLOAD: "auth/invalid-message-payload";
    readonly INVALID_MFA_SESSION: "auth/invalid-multi-factor-session";
    readonly INVALID_OAUTH_CLIENT_ID: "auth/invalid-oauth-client-id";
    readonly INVALID_OAUTH_PROVIDER: "auth/invalid-oauth-provider";
    readonly INVALID_OOB_CODE: "auth/invalid-action-code";
    readonly INVALID_ORIGIN: "auth/unauthorized-domain";
    readonly INVALID_PASSWORD: "auth/wrong-password";
    readonly INVALID_PERSISTENCE: "auth/invalid-persistence-type";
    readonly INVALID_PHONE_NUMBER: "auth/invalid-phone-number";
    readonly INVALID_PROVIDER_ID: "auth/invalid-provider-id";
    readonly INVALID_RECIPIENT_EMAIL: "auth/invalid-recipient-email";
    readonly INVALID_SENDER: "auth/invalid-sender";
    readonly INVALID_SESSION_INFO: "auth/invalid-verification-id";
    readonly INVALID_TENANT_ID: "auth/invalid-tenant-id";
    readonly MFA_INFO_NOT_FOUND: "auth/multi-factor-info-not-found";
    readonly MFA_REQUIRED: "auth/multi-factor-auth-required";
    readonly MISSING_ANDROID_PACKAGE_NAME: "auth/missing-android-pkg-name";
    readonly MISSING_APP_CREDENTIAL: "auth/missing-app-credential";
    readonly MISSING_AUTH_DOMAIN: "auth/auth-domain-config-required";
    readonly MISSING_CODE: "auth/missing-verification-code";
    readonly MISSING_CONTINUE_URI: "auth/missing-continue-uri";
    readonly MISSING_IFRAME_START: "auth/missing-iframe-start";
    readonly MISSING_IOS_BUNDLE_ID: "auth/missing-ios-bundle-id";
    readonly MISSING_OR_INVALID_NONCE: "auth/missing-or-invalid-nonce";
    readonly MISSING_MFA_INFO: "auth/missing-multi-factor-info";
    readonly MISSING_MFA_SESSION: "auth/missing-multi-factor-session";
    readonly MISSING_PHONE_NUMBER: "auth/missing-phone-number";
    readonly MISSING_PASSWORD: "auth/missing-password";
    readonly MISSING_SESSION_INFO: "auth/missing-verification-id";
    readonly MODULE_DESTROYED: "auth/app-deleted";
    readonly NEED_CONFIRMATION: "auth/account-exists-with-different-credential";
    readonly NETWORK_REQUEST_FAILED: "auth/network-request-failed";
    readonly NULL_USER: "auth/null-user";
    readonly NO_AUTH_EVENT: "auth/no-auth-event";
    readonly NO_SUCH_PROVIDER: "auth/no-such-provider";
    readonly OPERATION_NOT_ALLOWED: "auth/operation-not-allowed";
    readonly OPERATION_NOT_SUPPORTED: "auth/operation-not-supported-in-this-environment";
    readonly POPUP_BLOCKED: "auth/popup-blocked";
    readonly POPUP_CLOSED_BY_USER: "auth/popup-closed-by-user";
    readonly PROVIDER_ALREADY_LINKED: "auth/provider-already-linked";
    readonly QUOTA_EXCEEDED: "auth/quota-exceeded";
    readonly REDIRECT_CANCELLED_BY_USER: "auth/redirect-cancelled-by-user";
    readonly REDIRECT_OPERATION_PENDING: "auth/redirect-operation-pending";
    readonly REJECTED_CREDENTIAL: "auth/rejected-credential";
    readonly SECOND_FACTOR_ALREADY_ENROLLED: "auth/second-factor-already-in-use";
    readonly SECOND_FACTOR_LIMIT_EXCEEDED: "auth/maximum-second-factor-count-exceeded";
    readonly TENANT_ID_MISMATCH: "auth/tenant-id-mismatch";
    readonly TIMEOUT: "auth/timeout";
    readonly TOKEN_EXPIRED: "auth/user-token-expired";
    readonly TOO_MANY_ATTEMPTS_TRY_LATER: "auth/too-many-requests";
    readonly UNAUTHORIZED_DOMAIN: "auth/unauthorized-continue-uri";
    readonly UNSUPPORTED_FIRST_FACTOR: "auth/unsupported-first-factor";
    readonly UNSUPPORTED_PERSISTENCE: "auth/unsupported-persistence-type";
    readonly UNSUPPORTED_TENANT_OPERATION: "auth/unsupported-tenant-operation";
    readonly UNVERIFIED_EMAIL: "auth/unverified-email";
    readonly USER_CANCELLED: "auth/user-cancelled";
    readonly USER_DELETED: "auth/user-not-found";
    readonly USER_DISABLED: "auth/user-disabled";
    readonly USER_MISMATCH: "auth/user-mismatch";
    readonly USER_SIGNED_OUT: "auth/user-signed-out";
    readonly WEAK_PASSWORD: "auth/weak-password";
    readonly WEB_STORAGE_UNSUPPORTED: "auth/web-storage-unsupported";
    readonly ALREADY_INITIALIZED: "auth/already-initialized";
    readonly RECAPTCHA_NOT_ENABLED: "auth/recaptcha-not-enabled";
    readonly MISSING_RECAPTCHA_TOKEN: "auth/missing-recaptcha-token";
    readonly INVALID_RECAPTCHA_TOKEN: "auth/invalid-recaptcha-token";
    readonly INVALID_RECAPTCHA_ACTION: "auth/invalid-recaptcha-action";
    readonly MISSING_CLIENT_TYPE: "auth/missing-client-type";
    readonly MISSING_RECAPTCHA_VERSION: "auth/missing-recaptcha-version";
    readonly INVALID_RECAPTCHA_VERSION: "auth/invalid-recaptcha-version";
    readonly INVALID_REQ_TYPE: "auth/invalid-req-type";
    readonly INVALID_HOSTING_LINK_DOMAIN: "auth/invalid-hosting-link-domain";
};

// @public
export interface AuthErrorMap {
}

// @public
export interface AuthProvider {
    readonly providerId: string;
}

// @public
export interface AuthSettings {
    appVerificationDisabledForTesting: boolean;
}

// @public
export function beforeAuthStateChanged(auth: Auth, callback: (user: User | null) => void | Promise<void>, onAbort?: () => void): Unsubscribe;

// @beta
export const browserCookiePersistence: Persistence;

// @public
export const browserLocalPersistence: Persistence;

// @public
export const browserPopupRedirectResolver: PopupRedirectResolver;

// @public
export const browserSessionPersistence: Persistence;

// @public
export function checkActionCode(auth: Auth, oobCode: string): Promise<ActionCodeInfo>;

export { CompleteFn }

// @public
export interface Config {
    apiHost: string;
    apiKey: string;
    apiScheme: string;
    authDomain?: string;
    sdkClientVersion: string;
    tokenApiHost: string;
}

// @public
export interface ConfirmationResult {
    confirm(verificationCode: string): Promise<UserCredential>;
    readonly verificationId: string;
}

// @public
export function confirmPasswordReset(auth: Auth, oobCode: string, newPassword: string): Promise<void>;

// @public
export function connectAuthEmulator(auth: Auth, url: string, options?: {
    disableWarnings: boolean;
}): void;

// @public
export function createUserWithEmailAndPassword(auth: Auth, email: string, password: string): Promise<UserCredential>;

// @public
export type CustomParameters = Record<string, string>;

// @public
export const debugErrorMap: AuthErrorMap;

// @public
export function deleteUser(user: User): Promise<void>;

// @public
export interface Dependencies {
    errorMap?: AuthErrorMap;
    persistence?: Persistence | Persistence[];
    popupRedirectResolver?: PopupRedirectResolver;
}

// @public
export class EmailAuthCredential extends AuthCredential {
    // @internal (undocumented)
    readonly _email: string;
    // @internal (undocumented)
    static _fromEmailAndCode(email: string, oobCode: string, tenantId?: string | null): EmailAuthCredential;
    // @internal (undocumented)
    static _fromEmailAndPassword(email: string, password: string): EmailAuthCredential;
    static fromJSON(json: object | string): EmailAuthCredential | null;
    // @internal (undocumented)
    _getIdTokenResponse(auth: AuthInternal): Promise<IdTokenResponse>;
    // @internal (undocumented)
    _getReauthenticationResolver(auth: AuthInternal): Promise<IdTokenResponse>;
    // @internal (undocumented)
    _linkToIdToken(auth: AuthInternal, idToken: string): Promise<IdTokenResponse>;
    // @internal (undocumented)
    readonly _password: string;
    // @internal (undocumented)
    readonly _tenantId: string | null;
    toJSON(): object;
}

// @public
export class EmailAuthProvider implements AuthProvider {
    static credential(email: string, password: string): EmailAuthCredential;
    static credentialWithLink(email: string, emailLink: string): EmailAuthCredential;
    static readonly EMAIL_LINK_SIGN_IN_METHOD: 'emailLink';
    static readonly EMAIL_PASSWORD_SIGN_IN_METHOD: 'password';
    static readonly PROVIDER_ID: 'password';
    readonly providerId: "password";
}

// @public
export interface EmulatorConfig {
    readonly host: string;
    readonly options: {
        readonly disableWarnings: boolean;
    };
    readonly port: number | null;
    readonly protocol: string;
}

export { ErrorFn }

// Warning: (ae-forgotten-export) The symbol "BaseOAuthProvider" needs to be exported by the entry point index.d.ts
//
// @public
export class FacebookAuthProvider extends BaseOAuthProvider {
    constructor();
    static credential(accessToken: string): OAuthCredential;
    static credentialFromError(error: FirebaseError): OAuthCredential | null;
    static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
    static readonly FACEBOOK_SIGN_IN_METHOD: 'facebook.com';
    static readonly PROVIDER_ID: 'facebook.com';
}

// @public
export const FactorId: {
    readonly PHONE: "phone";
    readonly TOTP: "totp";
};

// @public
export function fetchSignInMethodsForEmail(auth: Auth, email: string): Promise<string[]>;

// @public
export function getAdditionalUserInfo(userCredential: UserCredential): AdditionalUserInfo | null;

// @public
export function getAuth(app?: FirebaseApp): Auth;

// @public
export function getIdToken(user: User, forceRefresh?: boolean): Promise<string>;

// @public
export function getIdTokenResult(user: User, forceRefresh?: boolean): Promise<IdTokenResult>;

// @public
export function getMultiFactorResolver(auth: Auth, error: MultiFactorError): MultiFactorResolver;

// @public
export function getRedirectResult(auth: Auth, resolver?: PopupRedirectResolver): Promise<UserCredential | null>;

// @public
export class GithubAuthProvider extends BaseOAuthProvider {
    constructor();
    static credential(accessToken: string): OAuthCredential;
    static credentialFromError(error: FirebaseError): OAuthCredential | null;
    static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
    static readonly GITHUB_SIGN_IN_METHOD: 'github.com';
    static readonly PROVIDER_ID: 'github.com';
}

// @public
export class GoogleAuthProvider extends BaseOAuthProvider {
    constructor();
    static credential(idToken?: string | null, accessToken?: string | null): OAuthCredential;
    static credentialFromError(error: FirebaseError): OAuthCredential | null;
    static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
    static readonly GOOGLE_SIGN_IN_METHOD: 'google.com';
    static readonly PROVIDER_ID: 'google.com';
}

// @public
export interface IdTokenResult {
    authTime: string;
    claims: ParsedToken;
    expirationTime: string;
    issuedAtTime: string;
    signInProvider: string | null;
    signInSecondFactor: string | null;
    token: string;
}

// @public
export const indexedDBLocalPersistence: Persistence;

// @public
export function initializeAuth(app: FirebaseApp, deps?: Dependencies): Auth;

// @public
export function initializeRecaptchaConfig(auth: Auth): Promise<void>;

// @public
export const inMemoryPersistence: Persistence;

// @public
export function isSignInWithEmailLink(auth: Auth, emailLink: string): boolean;

// @public
export function linkWithCredential(user: User, credential: AuthCredential): Promise<UserCredential>;

// @public
export function linkWithPhoneNumber(user: User, phoneNumber: string, appVerifier?: ApplicationVerifier): Promise<ConfirmationResult>;

// @public
export function linkWithPopup(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<UserCredential>;

// @public
export function linkWithRedirect(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<never>;

// @public
export function multiFactor(user: User): MultiFactorUser;

// @public
export interface MultiFactorAssertion {
    readonly factorId: (typeof FactorId)[keyof typeof FactorId];
}

// @public
export interface MultiFactorError extends AuthError {
    readonly customData: AuthError['customData'] & {
        readonly operationType: (typeof OperationType)[keyof typeof OperationType];
    };
}

// @public
export interface MultiFactorInfo {
    readonly displayName?: string | null;
    readonly enrollmentTime: string;
    readonly factorId: (typeof FactorId)[keyof typeof FactorId];
    readonly uid: string;
}

// @public
export interface MultiFactorResolver {
    readonly hints: MultiFactorInfo[];
    resolveSignIn(assertion: MultiFactorAssertion): Promise<UserCredential>;
    readonly session: MultiFactorSession;
}

// @public
export interface MultiFactorSession {
}

// @public
export interface MultiFactorUser {
    enroll(assertion: MultiFactorAssertion, displayName?: string | null): Promise<void>;
    readonly enrolledFactors: MultiFactorInfo[];
    getSession(): Promise<MultiFactorSession>;
    unenroll(option: MultiFactorInfo | string): Promise<void>;
}

export { NextFn }

// @public
export type NextOrObserver<T> = NextFn<T | null> | Observer<T | null>;

// @public
export class OAuthCredential extends AuthCredential {
    accessToken?: string;
    static fromJSON(json: string | object): OAuthCredential | null;
    // Warning: (ae-forgotten-export) The symbol "OAuthCredentialParams" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    static _fromParams(params: OAuthCredentialParams): OAuthCredential;
    // @internal (undocumented)
    _getIdTokenResponse(auth: AuthInternal): Promise<IdTokenResponse>;
    // @internal (undocumented)
    _getReauthenticationResolver(auth: AuthInternal): Promise<IdTokenResponse>;
    idToken?: string;
    // @internal (undocumented)
    _linkToIdToken(auth: AuthInternal, idToken: string): Promise<IdTokenResponse>;
    secret?: string;
    toJSON(): object;
}

// @public
export interface OAuthCredentialOptions {
    accessToken?: string;
    idToken?: string;
    rawNonce?: string;
}

// @public
export class OAuthProvider extends BaseOAuthProvider {
    credential(params: OAuthCredentialOptions): OAuthCredential;
    static credentialFromError(error: FirebaseError): OAuthCredential | null;
    static credentialFromJSON(json: object | string): OAuthCredential;
    static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
    }

// @public
export function onAuthStateChanged(auth: Auth, nextOrObserver: NextOrObserver<User>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;

// @public
export function onIdTokenChanged(auth: Auth, nextOrObserver: NextOrObserver<User>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;

// @public
export const OperationType: {
    readonly LINK: "link";
    readonly REAUTHENTICATE: "reauthenticate";
    readonly SIGN_IN: "signIn";
};

// @public
export function parseActionCodeURL(link: string): ActionCodeURL | null;

// @public
export interface ParsedToken {
    [key: string]: unknown;
    'auth_time'?: string;
    'exp'?: string;
    'firebase'?: {
        'sign_in_provider'?: string;
        'sign_in_second_factor'?: string;
        'identities'?: Record<string, string>;
    };
    'iat'?: string;
    'sub'?: string;
}

// @public
export interface PasswordPolicy {
    readonly allowedNonAlphanumericCharacters: string;
    readonly customStrengthOptions: {
        readonly minPasswordLength?: number;
        readonly maxPasswordLength?: number;
        readonly containsLowercaseLetter?: boolean;
        readonly containsUppercaseLetter?: boolean;
        readonly containsNumericCharacter?: boolean;
        readonly containsNonAlphanumericCharacter?: boolean;
    };
    readonly enforcementState: string;
    readonly forceUpgradeOnSignin: boolean;
}

// @public
export interface PasswordValidationStatus {
    readonly containsLowercaseLetter?: boolean;
    readonly containsNonAlphanumericCharacter?: boolean;
    readonly containsNumericCharacter?: boolean;
    readonly containsUppercaseLetter?: boolean;
    readonly isValid: boolean;
    readonly meetsMaxPasswordLength?: boolean;
    readonly meetsMinPasswordLength?: boolean;
    readonly passwordPolicy: PasswordPolicy;
}

// @public
export interface Persistence {
    readonly type: 'SESSION' | 'LOCAL' | 'NONE' | 'COOKIE';
}

// @public
export class PhoneAuthCredential extends AuthCredential {
    static fromJSON(json: object | string): PhoneAuthCredential | null;
    // @internal (undocumented)
    static _fromTokenResponse(phoneNumber: string, temporaryProof: string): PhoneAuthCredential;
    // @internal (undocumented)
    static _fromVerification(verificationId: string, verificationCode: string): PhoneAuthCredential;
    // @internal (undocumented)
    _getIdTokenResponse(auth: AuthInternal): Promise<PhoneOrOauthTokenResponse>;
    // @internal (undocumented)
    _getReauthenticationResolver(auth: AuthInternal): Promise<IdTokenResponse>;
    // @internal (undocumented)
    _linkToIdToken(auth: AuthInternal, idToken: string): Promise<IdTokenResponse>;
    // Warning: (ae-forgotten-export) The symbol "SignInWithPhoneNumberRequest" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _makeVerificationRequest(): SignInWithPhoneNumberRequest;
    toJSON(): object;
}

// @public
export class PhoneAuthProvider {
    constructor(auth: Auth);
    static credential(verificationId: string, verificationCode: string): PhoneAuthCredential;
    static credentialFromError(error: FirebaseError): AuthCredential | null;
    static credentialFromResult(userCredential: UserCredential): AuthCredential | null;
    static readonly PHONE_SIGN_IN_METHOD: 'phone';
    static readonly PROVIDER_ID: 'phone';
    readonly providerId: "phone";
    verifyPhoneNumber(phoneOptions: PhoneInfoOptions | string, applicationVerifier?: ApplicationVerifier): Promise<string>;
}

// @public
export type PhoneInfoOptions = PhoneSingleFactorInfoOptions | PhoneMultiFactorEnrollInfoOptions | PhoneMultiFactorSignInInfoOptions;

// @public
export interface PhoneMultiFactorAssertion extends MultiFactorAssertion {
}

// @public
export interface PhoneMultiFactorEnrollInfoOptions {
    phoneNumber: string;
    session: MultiFactorSession;
}

// @public
export class PhoneMultiFactorGenerator {
    static assertion(credential: PhoneAuthCredential): PhoneMultiFactorAssertion;
    static FACTOR_ID: string;
}

// @public
export interface PhoneMultiFactorInfo extends MultiFactorInfo {
    readonly phoneNumber: string;
}

// @public
export interface PhoneMultiFactorSignInInfoOptions {
    multiFactorHint?: MultiFactorInfo;
    multiFactorUid?: string;
    session: MultiFactorSession;
}

// @public
export interface PhoneSingleFactorInfoOptions {
    phoneNumber: string;
}

// @public
export interface PopupRedirectResolver {
}

// @public
export const prodErrorMap: AuthErrorMap;

// @public
export const ProviderId: {
    readonly FACEBOOK: "facebook.com";
    readonly GITHUB: "github.com";
    readonly GOOGLE: "google.com";
    readonly PASSWORD: "password";
    readonly PHONE: "phone";
    readonly TWITTER: "twitter.com";
};

// @public
export interface ReactNativeAsyncStorage {
    getItem(key: string): Promise<string | null>;
    removeItem(key: string): Promise<void>;
    setItem(key: string, value: string): Promise<void>;
}

// @public
export function reauthenticateWithCredential(user: User, credential: AuthCredential): Promise<UserCredential>;

// @public
export function reauthenticateWithPhoneNumber(user: User, phoneNumber: string, appVerifier?: ApplicationVerifier): Promise<ConfirmationResult>;

// @public
export function reauthenticateWithPopup(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<UserCredential>;

// @public
export function reauthenticateWithRedirect(user: User, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<never>;

// @public
export interface RecaptchaParameters {
    // (undocumented)
    [key: string]: any;
}

// Warning: (ae-forgotten-export) The symbol "ApplicationVerifierInternal" needs to be exported by the entry point index.d.ts
//
// @public
export class RecaptchaVerifier implements ApplicationVerifierInternal {
    constructor(authExtern: Auth, containerOrId: HTMLElement | string, parameters?: RecaptchaParameters);
    clear(): void;
    // Warning: (ae-forgotten-export) The symbol "ReCaptchaLoader" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    readonly _recaptchaLoader: ReCaptchaLoader;
    render(): Promise<number>;
    // @internal (undocumented)
    _reset(): void;
    readonly type = "recaptcha";
    verify(): Promise<string>;
    }

// @public
export function reload(user: User): Promise<void>;

// @public
export function revokeAccessToken(auth: Auth, token: string): Promise<void>;

// Warning: (ae-forgotten-export) The symbol "FederatedAuthProvider" needs to be exported by the entry point index.d.ts
//
// @public
export class SAMLAuthProvider extends FederatedAuthProvider {
    constructor(providerId: string);
    static credentialFromError(error: FirebaseError): AuthCredential | null;
    static credentialFromJSON(json: string | object): AuthCredential;
    static credentialFromResult(userCredential: UserCredential): AuthCredential | null;
    }

// @public
export function sendEmailVerification(user: User, actionCodeSettings?: ActionCodeSettings | null): Promise<void>;

// @public
export function sendPasswordResetEmail(auth: Auth, email: string, actionCodeSettings?: ActionCodeSettings): Promise<void>;

// @public
export function sendSignInLinkToEmail(auth: Auth, email: string, actionCodeSettings: ActionCodeSettings): Promise<void>;

// @public
export function setPersistence(auth: Auth, persistence: Persistence): Promise<void>;

// @public
export function signInAnonymously(auth: Auth): Promise<UserCredential>;

// @public
export const SignInMethod: {
    readonly EMAIL_LINK: "emailLink";
    readonly EMAIL_PASSWORD: "password";
    readonly FACEBOOK: "facebook.com";
    readonly GITHUB: "github.com";
    readonly GOOGLE: "google.com";
    readonly PHONE: "phone";
    readonly TWITTER: "twitter.com";
};

// @public
export function signInWithCredential(auth: Auth, credential: AuthCredential): Promise<UserCredential>;

// @public
export function signInWithCustomToken(auth: Auth, customToken: string): Promise<UserCredential>;

// @public
export function signInWithEmailAndPassword(auth: Auth, email: string, password: string): Promise<UserCredential>;

// @public
export function signInWithEmailLink(auth: Auth, email: string, emailLink?: string): Promise<UserCredential>;

// @public
export function signInWithPhoneNumber(auth: Auth, phoneNumber: string, appVerifier?: ApplicationVerifier): Promise<ConfirmationResult>;

// @public
export function signInWithPopup(auth: Auth, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<UserCredential>;

// @public
export function signInWithRedirect(auth: Auth, provider: AuthProvider, resolver?: PopupRedirectResolver): Promise<never>;

// @public
export function signOut(auth: Auth): Promise<void>;

// @public
export interface TotpMultiFactorAssertion extends MultiFactorAssertion {
}

// @public
export class TotpMultiFactorGenerator {
    static assertionForEnrollment(secret: TotpSecret, oneTimePassword: string): TotpMultiFactorAssertion;
    static assertionForSignIn(enrollmentId: string, oneTimePassword: string): TotpMultiFactorAssertion;
    static FACTOR_ID: 'totp';
    static generateSecret(session: MultiFactorSession): Promise<TotpSecret>;
}

// @public
export interface TotpMultiFactorInfo extends MultiFactorInfo {
}

// @public
export class TotpSecret {
    readonly codeIntervalSeconds: number;
    readonly codeLength: number;
    readonly enrollmentCompletionDeadline: string;
    // Warning: (ae-forgotten-export) The symbol "StartTotpMfaEnrollmentResponse" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    static _fromStartTotpMfaEnrollmentResponse(response: StartTotpMfaEnrollmentResponse, auth: AuthInternal): TotpSecret;
    generateQrCodeUrl(accountName?: string, issuer?: string): string;
    readonly hashingAlgorithm: string;
    // Warning: (ae-forgotten-export) The symbol "TotpVerificationInfo" needs to be exported by the entry point index.d.ts
    //
    // @internal (undocumented)
    _makeTotpVerificationInfo(otp: string): TotpVerificationInfo;
    readonly secretKey: string;
    }

// @public
export class TwitterAuthProvider extends BaseOAuthProvider {
    constructor();
    static credential(token: string, secret: string): OAuthCredential;
    static credentialFromError(error: FirebaseError): OAuthCredential | null;
    static credentialFromResult(userCredential: UserCredential): OAuthCredential | null;
    static readonly PROVIDER_ID: 'twitter.com';
    static readonly TWITTER_SIGN_IN_METHOD: 'twitter.com';
}

// @public
export function unlink(user: User, providerId: string): Promise<User>;

export { Unsubscribe }

// @public
export function updateCurrentUser(auth: Auth, user: User | null): Promise<void>;

// @public
export function updateEmail(user: User, newEmail: string): Promise<void>;

// @public
export function updatePassword(user: User, newPassword: string): Promise<void>;

// @public
export function updatePhoneNumber(user: User, credential: PhoneAuthCredential): Promise<void>;

// @public
export function updateProfile(user: User, { displayName, photoURL: photoUrl }: {
    displayName?: string | null;
    photoURL?: string | null;
}): Promise<void>;

// @public
export function useDeviceLanguage(auth: Auth): void;

// @public
export interface User extends UserInfo {
    delete(): Promise<void>;
    readonly emailVerified: boolean;
    getIdToken(forceRefresh?: boolean): Promise<string>;
    getIdTokenResult(forceRefresh?: boolean): Promise<IdTokenResult>;
    readonly isAnonymous: boolean;
    readonly metadata: UserMetadata;
    readonly providerData: UserInfo[];
    readonly refreshToken: string;
    reload(): Promise<void>;
    readonly tenantId: string | null;
    toJSON(): object;
}

// @public
export interface UserCredential {
    operationType: (typeof OperationType)[keyof typeof OperationType];
    providerId: string | null;
    user: User;
}

// @public
export interface UserInfo {
    readonly displayName: string | null;
    readonly email: string | null;
    readonly phoneNumber: string | null;
    readonly photoURL: string | null;
    readonly providerId: string;
    readonly uid: string;
}

// @public
export interface UserMetadata {
    readonly creationTime?: string;
    readonly lastSignInTime?: string;
}

// @public
export type UserProfile = Record<string, unknown>;

// @public
export function validatePassword(auth: Auth, password: string): Promise<PasswordValidationStatus>;

// @public
export function verifyBeforeUpdateEmail(user: User, newEmail: string, actionCodeSettings?: ActionCodeSettings | null): Promise<void>;

// @public
export function verifyPasswordResetCode(auth: Auth, code: string): Promise<string>;


```
