## API Report File for "@firebase/data-connect"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { AppCheckInternalComponentName } from '@firebase/app-check-interop-types';
import { FirebaseApp } from '@firebase/app';
import { FirebaseAuthInternalName } from '@firebase/auth-interop-types';
import { FirebaseError } from '@firebase/util';
import { LogLevelString } from '@firebase/logger';
import { Provider } from '@firebase/component';

// @public
export type CallerSdkType = 'Base' | 'Generated' | 'TanstackReactCore' | 'GeneratedReact' | 'TanstackAngularCore' | 'GeneratedAngular';

// @public (undocumented)
export const CallerSdkTypeEnum: {
    readonly Base: "Base";
    readonly Generated: "Generated";
    readonly TanstackReactCore: "TanstackReactCore";
    readonly GeneratedReact: "GeneratedReact";
    readonly TanstackAngularCore: "TanstackAngularCore";
    readonly GeneratedAngular: "GeneratedAngular";
};

// @public (undocumented)
export type Code = DataConnectErrorCode;

// @public (undocumented)
export const Code: {
    OTHER: DataConnectErrorCode;
    ALREADY_INITIALIZED: DataConnectErrorCode;
    NOT_INITIALIZED: DataConnectErrorCode;
    NOT_SUPPORTED: DataConnectErrorCode;
    INVALID_ARGUMENT: DataConnectErrorCode;
    PARTIAL_ERROR: DataConnectErrorCode;
    UNAUTHORIZED: DataConnectErrorCode;
};

// @public
export function connectDataConnectEmulator(dc: DataConnect, host: string, port?: number, sslEnabled?: boolean): void;

// @public
export interface ConnectorConfig {
    // (undocumented)
    connector: string;
    // (undocumented)
    location: string;
    // (undocumented)
    service: string;
}

// @public
export class DataConnect {
    constructor(app: FirebaseApp, dataConnectOptions: DataConnectOptions, _authProvider: Provider<FirebaseAuthInternalName>, _appCheckProvider: Provider<AppCheckInternalComponentName>);
    // (undocumented)
    readonly app: FirebaseApp;
    // (undocumented)
    enableEmulator(transportOptions: TransportOptions): void;
    // (undocumented)
    getSettings(): ConnectorConfig;
    // (undocumented)
    isEmulator: boolean;
    // (undocumented)
    setInitialized(): void;
}

// @public
export class DataConnectError extends FirebaseError {
    /* Excluded from this release type: name */
    constructor(code: Code, message: string);
}

// @public (undocumented)
export type DataConnectErrorCode = 'other' | 'already-initialized' | 'not-initialized' | 'not-supported' | 'invalid-argument' | 'partial-error' | 'unauthorized';

// @public
export class DataConnectOperationError extends DataConnectError {
    /* Excluded from this release type: name */
    readonly response: DataConnectOperationFailureResponse;
}

// @public (undocumented)
export interface DataConnectOperationFailureResponse {
    // (undocumented)
    readonly data?: Record<string, unknown> | null;
    // (undocumented)
    readonly errors: DataConnectOperationFailureResponseErrorInfo[];
}

// @public (undocumented)
export interface DataConnectOperationFailureResponseErrorInfo {
    // (undocumented)
    readonly message: string;
    // (undocumented)
    readonly path: Array<string | number>;
}

// @public
export interface DataConnectOptions extends ConnectorConfig {
    // (undocumented)
    projectId: string;
}

// @public (undocumented)
export interface DataConnectResult<Data, Variables> extends OpResult<Data> {
    // (undocumented)
    ref: OperationRef<Data, Variables>;
}

// @public (undocumented)
export type DataSource = typeof SOURCE_CACHE | typeof SOURCE_SERVER;

// @public
export function executeMutation<Data, Variables>(mutationRef: MutationRef<Data, Variables>): MutationPromise<Data, Variables>;

// @public
export function executeQuery<Data, Variables>(queryRef: QueryRef<Data, Variables>): QueryPromise<Data, Variables>;

// @public
export function getDataConnect(options: ConnectorConfig): DataConnect;

// @public
export function getDataConnect(app: FirebaseApp, options: ConnectorConfig): DataConnect;

// @public (undocumented)
export const MUTATION_STR = "mutation";

// @public
export interface MutationPromise<Data, Variables> extends Promise<MutationResult<Data, Variables>> {
}

// @public (undocumented)
export interface MutationRef<Data, Variables> extends OperationRef<Data, Variables> {
    // (undocumented)
    refType: typeof MUTATION_STR;
}

// @public
export function mutationRef<Data>(dcInstance: DataConnect, mutationName: string): MutationRef<Data, undefined>;

// @public (undocumented)
export function mutationRef<Data, Variables>(dcInstance: DataConnect, mutationName: string, variables: Variables): MutationRef<Data, Variables>;

// @public
export interface MutationResult<Data, Variables> extends DataConnectResult<Data, Variables> {
    // (undocumented)
    ref: MutationRef<Data, Variables>;
}

// @public
export type OnCompleteSubscription = () => void;

// @public
export type OnErrorSubscription = (err?: DataConnectError) => void;

// @public
export type OnResultSubscription<Data, Variables> = (res: QueryResult<Data, Variables>) => void;

// @public (undocumented)
export interface OperationRef<_Data, Variables> {
    // (undocumented)
    dataConnect: DataConnect;
    // (undocumented)
    name: string;
    // (undocumented)
    refType: ReferenceType;
    // (undocumented)
    variables: Variables;
}

// @public (undocumented)
export interface OpResult<Data> {
    // (undocumented)
    data: Data;
    // (undocumented)
    fetchTime: string;
    // (undocumented)
    source: DataSource;
}

// @public (undocumented)
export const QUERY_STR = "query";

// @public
export interface QueryPromise<Data, Variables> extends Promise<QueryResult<Data, Variables>> {
}

// @public
export interface QueryRef<Data, Variables> extends OperationRef<Data, Variables> {
    // (undocumented)
    refType: typeof QUERY_STR;
}

// @public
export function queryRef<Data>(dcInstance: DataConnect, queryName: string): QueryRef<Data, undefined>;

// @public
export function queryRef<Data, Variables>(dcInstance: DataConnect, queryName: string, variables: Variables): QueryRef<Data, Variables>;

// @public
export interface QueryResult<Data, Variables> extends DataConnectResult<Data, Variables> {
    // (undocumented)
    ref: QueryRef<Data, Variables>;
    // (undocumented)
    toJSON: () => SerializedRef<Data, Variables>;
}

// @public
export type QueryUnsubscribe = () => void;

// @public (undocumented)
export type ReferenceType = typeof QUERY_STR | typeof MUTATION_STR;

// @public
export interface RefInfo<Variables> {
    // (undocumented)
    connectorConfig: DataConnectOptions;
    // (undocumented)
    name: string;
    // (undocumented)
    variables: Variables;
}

// @public
export interface SerializedRef<Data, Variables> extends OpResult<Data> {
    // (undocumented)
    refInfo: RefInfo<Variables>;
}

// @public (undocumented)
export function setLogLevel(logLevel: LogLevelString): void;

// @public (undocumented)
export const SOURCE_CACHE = "CACHE";

// @public (undocumented)
export const SOURCE_SERVER = "SERVER";

// @public
export function subscribe<Data, Variables>(queryRefOrSerializedResult: QueryRef<Data, Variables> | SerializedRef<Data, Variables>, observer: SubscriptionOptions<Data, Variables>): QueryUnsubscribe;

// @public
export function subscribe<Data, Variables>(queryRefOrSerializedResult: QueryRef<Data, Variables> | SerializedRef<Data, Variables>, onNext: OnResultSubscription<Data, Variables>, onError?: OnErrorSubscription, onComplete?: OnCompleteSubscription): QueryUnsubscribe;

// @public
export interface SubscriptionOptions<Data, Variables> {
    // (undocumented)
    onComplete?: OnCompleteSubscription;
    // (undocumented)
    onErr?: OnErrorSubscription;
    // (undocumented)
    onNext?: OnResultSubscription<Data, Variables>;
}

// @public
export function terminate(dataConnect: DataConnect): Promise<void>;

// @public
export function toQueryRef<Data, Variables>(serializedRef: SerializedRef<Data, Variables>): QueryRef<Data, Variables>;

// @public
export interface TransportOptions {
    // (undocumented)
    host: string;
    // (undocumented)
    port?: number;
    // (undocumented)
    sslEnabled?: boolean;
}


```
