## API Report File for "@firebase/firestore"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { EmulatorMockTokenOptions } from '@firebase/util';
import { FirebaseApp } from '@firebase/app';
import { FirebaseError } from '@firebase/util';
import { LogLevelString as LogLevel } from '@firebase/logger';

// @public
export function addDoc<AppModelType, DbModelType extends DocumentData>(reference: CollectionReference<AppModelType, DbModelType>, data: WithFieldValue<AppModelType>): Promise<DocumentReference<AppModelType, DbModelType>>;

// @public
export type AddPrefixToKeys<Prefix extends string, T extends Record<string, unknown>> = {
    [K in keyof T & string as `${Prefix}.${K}`]+?: string extends K ? any : T[K];
};

// @public
export class AggregateField<T> {
    readonly aggregateType: AggregateType;
    readonly type = "AggregateField";
}

// @public
export function aggregateFieldEqual(left: AggregateField<unknown>, right: AggregateField<unknown>): boolean;

// @public
export type AggregateFieldType = ReturnType<typeof sum> | ReturnType<typeof average> | ReturnType<typeof count>;

// @public
export class AggregateQuerySnapshot<AggregateSpecType extends AggregateSpec, AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> {
    data(): AggregateSpecData<AggregateSpecType>;
    readonly query: Query<AppModelType, DbModelType>;
    readonly type = "AggregateQuerySnapshot";
}

// @public
export function aggregateQuerySnapshotEqual<AggregateSpecType extends AggregateSpec, AppModelType, DbModelType extends DocumentData>(left: AggregateQuerySnapshot<AggregateSpecType, AppModelType, DbModelType>, right: AggregateQuerySnapshot<AggregateSpecType, AppModelType, DbModelType>): boolean;

// @public
export interface AggregateSpec {
    // (undocumented)
    [field: string]: AggregateFieldType;
}

// @public
export type AggregateSpecData<T extends AggregateSpec> = {
    [P in keyof T]: T[P] extends AggregateField<infer U> ? U : never;
};

// @public
export type AggregateType = 'count' | 'avg' | 'sum';

// @public
export function and(...queryConstraints: QueryFilterConstraint[]): QueryCompositeFilterConstraint;

// @public
export function arrayRemove(...elements: unknown[]): FieldValue;

// @public
export function arrayUnion(...elements: unknown[]): FieldValue;

// @public
export function average(field: string | FieldPath): AggregateField<number | null>;

// @public
export class Bytes {
    static fromBase64String(base64: string): Bytes;
    static fromJSON(json: object): Bytes;
    static fromUint8Array(array: Uint8Array): Bytes;
    isEqual(other: Bytes): boolean;
    toBase64(): string;
    toJSON(): object;
    toString(): string;
    toUint8Array(): Uint8Array;
}

// @public
export const CACHE_SIZE_UNLIMITED = -1;

// @public
export type ChildUpdateFields<K extends string, V> = V extends Record<string, unknown> ? AddPrefixToKeys<K, UpdateData<V>> : never;

// @public
export function clearIndexedDbPersistence(firestore: Firestore): Promise<void>;

// @public
export function collection(firestore: Firestore, path: string, ...pathSegments: string[]): CollectionReference<DocumentData, DocumentData>;

// @public
export function collection<AppModelType, DbModelType extends DocumentData>(reference: CollectionReference<AppModelType, DbModelType>, path: string, ...pathSegments: string[]): CollectionReference<DocumentData, DocumentData>;

// @public
export function collection<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, path: string, ...pathSegments: string[]): CollectionReference<DocumentData, DocumentData>;

// @public
export function collectionGroup(firestore: Firestore, collectionId: string): Query<DocumentData, DocumentData>;

// @public
export class CollectionReference<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> extends Query<AppModelType, DbModelType> {
    get id(): string;
    get parent(): DocumentReference<DocumentData, DocumentData> | null;
    get path(): string;
    readonly type = "collection";
    withConverter<NewAppModelType, NewDbModelType extends DocumentData = DocumentData>(converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): CollectionReference<NewAppModelType, NewDbModelType>;
    withConverter(converter: null): CollectionReference<DocumentData, DocumentData>;
}

// @public
export function connectFirestoreEmulator(firestore: Firestore, host: string, port: number, options?: {
    mockUserToken?: EmulatorMockTokenOptions | string;
}): void;

// @public
export function count(): AggregateField<number>;

// @public
export function deleteAllPersistentCacheIndexes(indexManager: PersistentCacheIndexManager): void;

// @public
export function deleteDoc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>): Promise<void>;

// @public
export function deleteField(): FieldValue;

// @public
export function disableNetwork(firestore: Firestore): Promise<void>;

// @public
export function disablePersistentCacheIndexAutoCreation(indexManager: PersistentCacheIndexManager): void;

// @public
export function doc(firestore: Firestore, path: string, ...pathSegments: string[]): DocumentReference<DocumentData, DocumentData>;

// @public
export function doc<AppModelType, DbModelType extends DocumentData>(reference: CollectionReference<AppModelType, DbModelType>, path?: string, ...pathSegments: string[]): DocumentReference<AppModelType, DbModelType>;

// @public
export function doc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, path: string, ...pathSegments: string[]): DocumentReference<DocumentData, DocumentData>;

// @public
export interface DocumentChange<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> {
    readonly doc: QueryDocumentSnapshot<AppModelType, DbModelType>;
    readonly newIndex: number;
    readonly oldIndex: number;
    readonly type: DocumentChangeType;
}

// @public
export type DocumentChangeType = 'added' | 'removed' | 'modified';

// @public
export interface DocumentData {
    [field: string]: any;
}

// @public
export function documentId(): FieldPath;

// @public
export class DocumentReference<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> {
    readonly converter: FirestoreDataConverter<AppModelType, DbModelType> | null;
    readonly firestore: Firestore;
    static fromJSON(firestore: Firestore, json: object): DocumentReference;
    static fromJSON<NewAppModelType = DocumentData, NewDbModelType extends DocumentData = DocumentData>(firestore: Firestore, json: object, converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): DocumentReference<NewAppModelType, NewDbModelType>;
    get id(): string;
    get parent(): CollectionReference<AppModelType, DbModelType>;
    get path(): string;
    toJSON(): object;
    readonly type = "document";
    withConverter<NewAppModelType, NewDbModelType extends DocumentData = DocumentData>(converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): DocumentReference<NewAppModelType, NewDbModelType>;
    withConverter(converter: null): DocumentReference<DocumentData, DocumentData>;
}

// @public
export class DocumentSnapshot<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> {
    protected constructor();
    data(options?: SnapshotOptions): AppModelType | undefined;
    exists(): this is QueryDocumentSnapshot<AppModelType, DbModelType>;
    get(fieldPath: string | FieldPath, options?: SnapshotOptions): any;
    get id(): string;
    readonly metadata: SnapshotMetadata;
    get ref(): DocumentReference<AppModelType, DbModelType>;
    toJSON(): object;
}

// @public
export function documentSnapshotFromJSON(db: Firestore, json: object): DocumentSnapshot;

// @public
export function documentSnapshotFromJSON<AppModelType, DbModelType extends DocumentData = DocumentData>(db: Firestore, json: object, converter: FirestoreDataConverter<AppModelType, DbModelType>): DocumentSnapshot<AppModelType, DbModelType>;

export { EmulatorMockTokenOptions }

// @public @deprecated
export function enableIndexedDbPersistence(firestore: Firestore, persistenceSettings?: PersistenceSettings): Promise<void>;

// @public @deprecated
export function enableMultiTabIndexedDbPersistence(firestore: Firestore): Promise<void>;

// @public
export function enableNetwork(firestore: Firestore): Promise<void>;

// @public
export function enablePersistentCacheIndexAutoCreation(indexManager: PersistentCacheIndexManager): void;

// @public
export function endAt<AppModelType, DbModelType extends DocumentData>(snapshot: DocumentSnapshot<AppModelType, DbModelType>): QueryEndAtConstraint;

// @public
export function endAt(...fieldValues: unknown[]): QueryEndAtConstraint;

// @public
export function endBefore<AppModelType, DbModelType extends DocumentData>(snapshot: DocumentSnapshot<AppModelType, DbModelType>): QueryEndAtConstraint;

// @public
export function endBefore(...fieldValues: unknown[]): QueryEndAtConstraint;

// @public
export interface ExperimentalLongPollingOptions {
    timeoutSeconds?: number;
}

// @public
export class FieldPath {
    constructor(...fieldNames: string[]);
    isEqual(other: FieldPath): boolean;
}

// @public
export abstract class FieldValue {
    abstract isEqual(other: FieldValue): boolean;
}

// @public
export class Firestore {
    get app(): FirebaseApp;
    toJSON(): object;
    type: 'firestore-lite' | 'firestore';
}

// @public
export interface FirestoreDataConverter<AppModelType, DbModelType extends DocumentData = DocumentData> {
    fromFirestore(snapshot: QueryDocumentSnapshot<DocumentData, DocumentData>, options?: SnapshotOptions): AppModelType;
    toFirestore(modelObject: WithFieldValue<AppModelType>): WithFieldValue<DbModelType>;
    toFirestore(modelObject: PartialWithFieldValue<AppModelType>, options: SetOptions): PartialWithFieldValue<DbModelType>;
}

// @public
export class FirestoreError extends FirebaseError {
    readonly code: FirestoreErrorCode;
    readonly message: string;
    readonly stack?: string;
}

// @public
export type FirestoreErrorCode = 'cancelled' | 'unknown' | 'invalid-argument' | 'deadline-exceeded' | 'not-found' | 'already-exists' | 'permission-denied' | 'resource-exhausted' | 'failed-precondition' | 'aborted' | 'out-of-range' | 'unimplemented' | 'internal' | 'unavailable' | 'data-loss' | 'unauthenticated';

// @public
export type FirestoreLocalCache = MemoryLocalCache | PersistentLocalCache;

// @public
export interface FirestoreSettings {
    cacheSizeBytes?: number;
    experimentalAutoDetectLongPolling?: boolean;
    experimentalForceLongPolling?: boolean;
    experimentalLongPollingOptions?: ExperimentalLongPollingOptions;
    host?: string;
    ignoreUndefinedProperties?: boolean;
    localCache?: FirestoreLocalCache;
    ssl?: boolean;
}

// @public
export class GeoPoint {
    constructor(latitude: number, longitude: number);
    static fromJSON(json: object): GeoPoint;
    isEqual(other: GeoPoint): boolean;
    get latitude(): number;
    get longitude(): number;
    toJSON(): {
        latitude: number;
        longitude: number;
        type: string;
    };
}

// @public
export function getAggregateFromServer<AggregateSpecType extends AggregateSpec, AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, aggregateSpec: AggregateSpecType): Promise<AggregateQuerySnapshot<AggregateSpecType, AppModelType, DbModelType>>;

// @public
export function getCountFromServer<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>): Promise<AggregateQuerySnapshot<{
    count: AggregateField<number>;
}, AppModelType, DbModelType>>;

// @public
export function getDoc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>): Promise<DocumentSnapshot<AppModelType, DbModelType>>;

// @public
export function getDocFromCache<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>): Promise<DocumentSnapshot<AppModelType, DbModelType>>;

// @public
export function getDocFromServer<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>): Promise<DocumentSnapshot<AppModelType, DbModelType>>;

// @public
export function getDocs<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>): Promise<QuerySnapshot<AppModelType, DbModelType>>;

// @public
export function getDocsFromCache<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>): Promise<QuerySnapshot<AppModelType, DbModelType>>;

// @public
export function getDocsFromServer<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>): Promise<QuerySnapshot<AppModelType, DbModelType>>;

// @public
export function getFirestore(): Firestore;

// @public
export function getFirestore(app: FirebaseApp): Firestore;

// @beta
export function getFirestore(databaseId: string): Firestore;

// @beta
export function getFirestore(app: FirebaseApp, databaseId: string): Firestore;

// @public
export function getPersistentCacheIndexManager(firestore: Firestore): PersistentCacheIndexManager | null;

// @public
export function increment(n: number): FieldValue;

// @beta @deprecated
export interface Index {
    // (undocumented)
    [key: string]: unknown;
    readonly collectionGroup: string;
    readonly fields?: IndexField[];
}

// @beta @deprecated
export interface IndexConfiguration {
    // (undocumented)
    [key: string]: unknown;
    readonly indexes?: Index[];
}

// @beta @deprecated
export interface IndexField {
    // (undocumented)
    [key: string]: unknown;
    readonly arrayConfig?: 'CONTAINS';
    readonly fieldPath: string;
    readonly order?: 'ASCENDING' | 'DESCENDING';
}

// @public
export function initializeFirestore(app: FirebaseApp, settings: FirestoreSettings, databaseId?: string): Firestore;

// @public
export function limit(limit: number): QueryLimitConstraint;

// @public
export function limitToLast(limit: number): QueryLimitConstraint;

// @public
export type ListenSource = 'default' | 'cache';

// @public
export function loadBundle(firestore: Firestore, bundleData: ReadableStream<Uint8Array> | ArrayBuffer | string): LoadBundleTask;

// @public
export class LoadBundleTask implements PromiseLike<LoadBundleTaskProgress> {
    catch<R>(onRejected: (a: Error) => R | PromiseLike<R>): Promise<R | LoadBundleTaskProgress>;
    onProgress(next?: (progress: LoadBundleTaskProgress) => unknown, error?: (err: Error) => unknown, complete?: () => void): void;
    then<T, R>(onFulfilled?: (a: LoadBundleTaskProgress) => T | PromiseLike<T>, onRejected?: (a: Error) => R | PromiseLike<R>): Promise<T | R>;
}

// @public
export interface LoadBundleTaskProgress {
    bytesLoaded: number;
    documentsLoaded: number;
    taskState: TaskState;
    totalBytes: number;
    totalDocuments: number;
}

export { LogLevel }

// @public
export interface MemoryCacheSettings {
    garbageCollector?: MemoryGarbageCollector;
}

// @public
export interface MemoryEagerGarbageCollector {
    // (undocumented)
    kind: 'memoryEager';
}

// @public
export function memoryEagerGarbageCollector(): MemoryEagerGarbageCollector;

// @public
export type MemoryGarbageCollector = MemoryEagerGarbageCollector | MemoryLruGarbageCollector;

// @public
export interface MemoryLocalCache {
    // (undocumented)
    kind: 'memory';
}

// @public
export function memoryLocalCache(settings?: MemoryCacheSettings): MemoryLocalCache;

// @public
export interface MemoryLruGarbageCollector {
    // (undocumented)
    kind: 'memoryLru';
}

// @public
export function memoryLruGarbageCollector(settings?: {
    cacheSizeBytes?: number;
}): MemoryLruGarbageCollector;

// @public
export function namedQuery(firestore: Firestore, name: string): Promise<Query | null>;

// @public
export type NestedUpdateFields<T extends Record<string, unknown>> = UnionToIntersection<{
    [K in keyof T & string]: ChildUpdateFields<K, T[K]>;
}[keyof T & string]>;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, observer: {
    next?: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, options: SnapshotListenOptions, observer: {
    next?: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, onNext: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, options: SnapshotListenOptions, onNext: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, observer: {
    next?: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, options: SnapshotListenOptions, observer: {
    next?: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, onNext: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshot<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, options: SnapshotListenOptions, onNext: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, onNext: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, onNext: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, options: SnapshotListenOptions, onNext: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, options: SnapshotListenOptions, onNext: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void, onError?: (error: FirestoreError) => void, onCompletion?: () => void, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, observer: {
    next: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, observer: {
    next: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, options: SnapshotListenOptions, observer: {
    next: (snapshot: QuerySnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotResume<AppModelType, DbModelType extends DocumentData>(firestore: Firestore, snapshotJson: object, options: SnapshotListenOptions, observer: {
    next: (snapshot: DocumentSnapshot<AppModelType, DbModelType>) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}, converter?: FirestoreDataConverter<DbModelType>): Unsubscribe;

// @public
export function onSnapshotsInSync(firestore: Firestore, observer: {
    next?: (value: void) => void;
    error?: (error: FirestoreError) => void;
    complete?: () => void;
}): Unsubscribe;

// @public
export function onSnapshotsInSync(firestore: Firestore, onSync: () => void): Unsubscribe;

// @public
export function or(...queryConstraints: QueryFilterConstraint[]): QueryCompositeFilterConstraint;

// @public
export function orderBy(fieldPath: string | FieldPath, directionStr?: OrderByDirection): QueryOrderByConstraint;

// @public
export type OrderByDirection = 'desc' | 'asc';

// @public
export type PartialWithFieldValue<T> = Partial<T> | (T extends Primitive ? T : T extends {} ? {
    [K in keyof T]?: PartialWithFieldValue<T[K]> | FieldValue;
} : never);

// @public
export interface PersistenceSettings {
    forceOwnership?: boolean;
}

// @public
export class PersistentCacheIndexManager {
    readonly type: 'PersistentCacheIndexManager';
}

// @public
export interface PersistentCacheSettings {
    cacheSizeBytes?: number;
    tabManager?: PersistentTabManager;
}

// @public
export interface PersistentLocalCache {
    // (undocumented)
    kind: 'persistent';
}

// @public
export function persistentLocalCache(settings?: PersistentCacheSettings): PersistentLocalCache;

// @public
export interface PersistentMultipleTabManager {
    // (undocumented)
    kind: 'PersistentMultipleTab';
}

// @public
export function persistentMultipleTabManager(): PersistentMultipleTabManager;

// @public
export interface PersistentSingleTabManager {
    // (undocumented)
    kind: 'persistentSingleTab';
}

// @public
export function persistentSingleTabManager(settings: PersistentSingleTabManagerSettings | undefined): PersistentSingleTabManager;

// @public
export interface PersistentSingleTabManagerSettings {
    forceOwnership?: boolean;
}

// @public
export type PersistentTabManager = PersistentSingleTabManager | PersistentMultipleTabManager;

// @public
export type Primitive = string | number | boolean | undefined | null;

// @public
export class Query<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> {
    protected constructor();
    readonly converter: FirestoreDataConverter<AppModelType, DbModelType> | null;
    readonly firestore: Firestore;
    readonly type: 'query' | 'collection';
    withConverter(converter: null): Query<DocumentData, DocumentData>;
    withConverter<NewAppModelType, NewDbModelType extends DocumentData = DocumentData>(converter: FirestoreDataConverter<NewAppModelType, NewDbModelType>): Query<NewAppModelType, NewDbModelType>;
}

// @public
export function query<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, compositeFilter: QueryCompositeFilterConstraint, ...queryConstraints: QueryNonFilterConstraint[]): Query<AppModelType, DbModelType>;

// @public
export function query<AppModelType, DbModelType extends DocumentData>(query: Query<AppModelType, DbModelType>, ...queryConstraints: QueryConstraint[]): Query<AppModelType, DbModelType>;

// @public
export class QueryCompositeFilterConstraint {
    readonly type: 'or' | 'and';
}

// @public
export abstract class QueryConstraint {
    abstract readonly type: QueryConstraintType;
}

// @public
export type QueryConstraintType = 'where' | 'orderBy' | 'limit' | 'limitToLast' | 'startAt' | 'startAfter' | 'endAt' | 'endBefore';

// @public
export class QueryDocumentSnapshot<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> extends DocumentSnapshot<AppModelType, DbModelType> {
    // @override
    data(options?: SnapshotOptions): AppModelType;
}

// @public
export class QueryEndAtConstraint extends QueryConstraint {
    readonly type: 'endBefore' | 'endAt';
}

// @public
export function queryEqual<AppModelType, DbModelType extends DocumentData>(left: Query<AppModelType, DbModelType>, right: Query<AppModelType, DbModelType>): boolean;

// @public
export class QueryFieldFilterConstraint extends QueryConstraint {
    readonly type = "where";
}

// @public
export type QueryFilterConstraint = QueryFieldFilterConstraint | QueryCompositeFilterConstraint;

// @public
export class QueryLimitConstraint extends QueryConstraint {
    readonly type: 'limit' | 'limitToLast';
}

// @public
export type QueryNonFilterConstraint = QueryOrderByConstraint | QueryLimitConstraint | QueryStartAtConstraint | QueryEndAtConstraint;

// @public
export class QueryOrderByConstraint extends QueryConstraint {
    readonly type = "orderBy";
}

// @public
export class QuerySnapshot<AppModelType = DocumentData, DbModelType extends DocumentData = DocumentData> {
    docChanges(options?: SnapshotListenOptions): Array<DocumentChange<AppModelType, DbModelType>>;
    get docs(): Array<QueryDocumentSnapshot<AppModelType, DbModelType>>;
    get empty(): boolean;
    forEach(callback: (result: QueryDocumentSnapshot<AppModelType, DbModelType>) => void, thisArg?: unknown): void;
    readonly metadata: SnapshotMetadata;
    readonly query: Query<AppModelType, DbModelType>;
    get size(): number;
    toJSON(): object;
}

// @public
export function querySnapshotFromJSON(db: Firestore, json: object): QuerySnapshot;

// @public
export function querySnapshotFromJSON<AppModelType, DbModelType extends DocumentData = DocumentData>(db: Firestore, json: object, converter: FirestoreDataConverter<AppModelType, DbModelType>): QuerySnapshot<AppModelType, DbModelType>;

// @public
export class QueryStartAtConstraint extends QueryConstraint {
    readonly type: 'startAt' | 'startAfter';
}

// @public
export function refEqual<AppModelType, DbModelType extends DocumentData>(left: DocumentReference<AppModelType, DbModelType> | CollectionReference<AppModelType, DbModelType>, right: DocumentReference<AppModelType, DbModelType> | CollectionReference<AppModelType, DbModelType>): boolean;

// @public
export function runTransaction<T>(firestore: Firestore, updateFunction: (transaction: Transaction) => Promise<T>, options?: TransactionOptions): Promise<T>;

// @public
export function serverTimestamp(): FieldValue;

// @public
export function setDoc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, data: WithFieldValue<AppModelType>): Promise<void>;

// @public
export function setDoc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, data: PartialWithFieldValue<AppModelType>, options: SetOptions): Promise<void>;

// @beta @deprecated
export function setIndexConfiguration(firestore: Firestore, configuration: IndexConfiguration): Promise<void>;

// @beta @deprecated
export function setIndexConfiguration(firestore: Firestore, json: string): Promise<void>;

// @public
export function setLogLevel(logLevel: LogLevel): void;

// @public
export type SetOptions = {
    readonly merge?: boolean;
} | {
    readonly mergeFields?: Array<string | FieldPath>;
};

// @public
export function snapshotEqual<AppModelType, DbModelType extends DocumentData>(left: DocumentSnapshot<AppModelType, DbModelType> | QuerySnapshot<AppModelType, DbModelType>, right: DocumentSnapshot<AppModelType, DbModelType> | QuerySnapshot<AppModelType, DbModelType>): boolean;

// @public
export interface SnapshotListenOptions {
    readonly includeMetadataChanges?: boolean;
    readonly source?: ListenSource;
}

// @public
export class SnapshotMetadata {
    readonly fromCache: boolean;
    readonly hasPendingWrites: boolean;
    isEqual(other: SnapshotMetadata): boolean;
}

// @public
export interface SnapshotOptions {
    readonly serverTimestamps?: 'estimate' | 'previous' | 'none';
}

// @public
export function startAfter<AppModelType, DbModelType extends DocumentData>(snapshot: DocumentSnapshot<AppModelType, DbModelType>): QueryStartAtConstraint;

// @public
export function startAfter(...fieldValues: unknown[]): QueryStartAtConstraint;

// @public
export function startAt<AppModelType, DbModelType extends DocumentData>(snapshot: DocumentSnapshot<AppModelType, DbModelType>): QueryStartAtConstraint;

// @public
export function startAt(...fieldValues: unknown[]): QueryStartAtConstraint;

// @public
export function sum(field: string | FieldPath): AggregateField<number>;

// @public
export type TaskState = 'Error' | 'Running' | 'Success';

// @public
export function terminate(firestore: Firestore): Promise<void>;

// @public
export class Timestamp {
    constructor(
    seconds: number,
    nanoseconds: number);
    static fromDate(date: Date): Timestamp;
    static fromJSON(json: object): Timestamp;
    static fromMillis(milliseconds: number): Timestamp;
    isEqual(other: Timestamp): boolean;
    readonly nanoseconds: number;
    static now(): Timestamp;
    readonly seconds: number;
    toDate(): Date;
    toJSON(): {
        seconds: number;
        nanoseconds: number;
        type: string;
    };
    toMillis(): number;
    toString(): string;
    valueOf(): string;
}

// @public
export class Transaction {
    delete<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>): this;
    get<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>): Promise<DocumentSnapshot<AppModelType, DbModelType>>;
    set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: WithFieldValue<AppModelType>): this;
    set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: PartialWithFieldValue<AppModelType>, options: SetOptions): this;
    update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: UpdateData<DbModelType>): this;
    update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): this;
}

// @public
export interface TransactionOptions {
    readonly maxAttempts?: number;
}

// @public
export type UnionToIntersection<U> = (U extends unknown ? (k: U) => void : never) extends (k: infer I) => void ? I : never;

// @public
export interface Unsubscribe {
    (): void;
}

// @public
export type UpdateData<T> = T extends Primitive ? T : T extends {} ? {
    [K in keyof T]?: UpdateData<T[K]> | FieldValue;
} & NestedUpdateFields<T> : Partial<T>;

// @public
export function updateDoc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, data: UpdateData<DbModelType>): Promise<void>;

// @public
export function updateDoc<AppModelType, DbModelType extends DocumentData>(reference: DocumentReference<AppModelType, DbModelType>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): Promise<void>;

// @public
export function vector(values?: number[]): VectorValue;

// @public
export class VectorValue {
    /* Excluded from this release type: __constructor */
    static fromJSON(json: object): VectorValue;
    isEqual(other: VectorValue): boolean;
    toArray(): number[];
    toJSON(): object;
}

// @public
export function waitForPendingWrites(firestore: Firestore): Promise<void>;

// @public
export function where(fieldPath: string | FieldPath, opStr: WhereFilterOp, value: unknown): QueryFieldFilterConstraint;

// @public
export type WhereFilterOp = '<' | '<=' | '==' | '!=' | '>=' | '>' | 'array-contains' | 'in' | 'array-contains-any' | 'not-in';

// @public
export type WithFieldValue<T> = T | (T extends Primitive ? T : T extends {} ? {
    [K in keyof T]: WithFieldValue<T[K]> | FieldValue;
} : never);

// @public
export class WriteBatch {
    commit(): Promise<void>;
    delete<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>): WriteBatch;
    set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: WithFieldValue<AppModelType>): WriteBatch;
    set<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: PartialWithFieldValue<AppModelType>, options: SetOptions): WriteBatch;
    update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, data: UpdateData<DbModelType>): WriteBatch;
    update<AppModelType, DbModelType extends DocumentData>(documentRef: DocumentReference<AppModelType, DbModelType>, field: string | FieldPath, value: unknown, ...moreFieldsAndValues: unknown[]): WriteBatch;
}

// @public
export function writeBatch(firestore: Firestore): WriteBatch;


```
