## API Report File for "@firebase/functions"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { FirebaseApp } from '@firebase/app';
import { FirebaseError } from '@firebase/util';

// @public
export function connectFunctionsEmulator(functionsInstance: Functions, host: string, port: number): void;

// @public
export interface Functions {
    app: FirebaseApp;
    customDomain: string | null;
    region: string;
}

// @public
export class FunctionsError extends FirebaseError {
    constructor(
    code: FunctionsErrorCodeCore, message?: string,
    details?: unknown);
    readonly details?: unknown;
}

// @public
export type FunctionsErrorCode = `functions/${FunctionsErrorCodeCore}`;

// @public
export type FunctionsErrorCodeCore = 'ok' | 'cancelled' | 'unknown' | 'invalid-argument' | 'deadline-exceeded' | 'not-found' | 'already-exists' | 'permission-denied' | 'resource-exhausted' | 'failed-precondition' | 'aborted' | 'out-of-range' | 'unimplemented' | 'internal' | 'unavailable' | 'data-loss' | 'unauthenticated';

// @public
export function getFunctions(app?: FirebaseApp, regionOrCustomDomain?: string): Functions;

// @public
export interface HttpsCallable<RequestData = unknown, ResponseData = unknown, StreamData = unknown> {
    // (undocumented)
    (data?: RequestData | null): Promise<HttpsCallableResult<ResponseData>>;
    // (undocumented)
    stream: (data?: RequestData | null, options?: HttpsCallableStreamOptions) => Promise<HttpsCallableStreamResult<ResponseData, StreamData>>;
}

// @public
export function httpsCallable<RequestData = unknown, ResponseData = unknown, StreamData = unknown>(functionsInstance: Functions, name: string, options?: HttpsCallableOptions): HttpsCallable<RequestData, ResponseData, StreamData>;

// @public
export function httpsCallableFromURL<RequestData = unknown, ResponseData = unknown, StreamData = unknown>(functionsInstance: Functions, url: string, options?: HttpsCallableOptions): HttpsCallable<RequestData, ResponseData, StreamData>;

// @public
export interface HttpsCallableOptions {
    limitedUseAppCheckTokens?: boolean;
    timeout?: number;
}

// @public
export interface HttpsCallableResult<ResponseData = unknown> {
    readonly data: ResponseData;
}

// @public
export interface HttpsCallableStreamOptions {
    limitedUseAppCheckTokens?: boolean;
    signal?: AbortSignal;
}

// @public
export interface HttpsCallableStreamResult<ResponseData = unknown, StreamData = unknown> {
    // (undocumented)
    readonly data: Promise<ResponseData>;
    // (undocumented)
    readonly stream: AsyncIterable<StreamData>;
}


```
