## API Report File for "@firebase/rules-unit-testing"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { default as firebase_2 } from 'firebase/compat/app';
import { FirebaseSignInProvider } from '@firebase/util';

// @public
export function assertFails(pr: Promise<any>): Promise<any>;

// @public
export function assertSucceeds<T>(pr: Promise<T>): Promise<T>;

// @public
export type EmulatorConfig = {
    rules?: string;
} & (HostAndPort | {});

// @public
export interface HostAndPort {
    host: string;
    port: number;
}

// @public
export function initializeTestEnvironment(config: TestEnvironmentConfig): Promise<RulesTestEnvironment>;

// @public
export interface RulesTestContext {
    database(databaseURL?: string): firebase_2.database.Database;
    firestore(settings?: firebase_2.firestore.Settings): firebase_2.firestore.Firestore;
    storage(bucketUrl?: string): firebase_2.storage.Storage;
}

// @public
export interface RulesTestEnvironment {
    authenticatedContext(user_id: string, tokenOptions?: TokenOptions): RulesTestContext;
    cleanup(): Promise<void>;
    clearDatabase(): Promise<void>;
    clearFirestore(): Promise<void>;
    clearStorage(): Promise<void>;
    readonly emulators: {
        database?: HostAndPort;
        firestore?: HostAndPort;
        storage?: HostAndPort;
    };
    readonly projectId: string;
    unauthenticatedContext(): RulesTestContext;
    // (undocumented)
    withSecurityRulesDisabled(callback: (context: RulesTestContext) => Promise<void>): Promise<void>;
}

// @public
export interface TestEnvironmentConfig {
    database?: EmulatorConfig;
    firestore?: EmulatorConfig;
    hub?: HostAndPort;
    projectId?: string;
    storage?: EmulatorConfig;
}

// @public
export type TokenOptions = {
    iat?: number;
    exp?: number;
    auth_time?: number;
    provider_id?: 'anonymous';
    email?: string;
    email_verified?: boolean;
    phone_number?: string;
    name?: string;
    picture?: string;
    firebase?: {
        sign_in_provider: FirebaseSignInProvider;
        identities?: {
            [provider in FirebaseSignInProvider]?: string[];
        };
    };
    aud?: string;
    iss?: string;
    [claim: string]: unknown;
    uid?: never;
    sub?: never;
    user_id?: never;
};

// @public
export function withFunctionTriggersDisabled<TResult>(fn: () => TResult | Promise<TResult>): Promise<TResult>;

// @public
export function withFunctionTriggersDisabled<TResult>(hub: {
    host: string;
    port: number;
}, fn: () => TResult | Promise<TResult>): Promise<TResult>;


// (No @packageDocumentation comment for this package)

```
