Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ChatSession class
ChatSession class that enables sending chat messages and stores history of sent and received messages so far.

<b>Signature:</b>

```typescript
export declare class ChatSession 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(apiSettings, model, chromeAdapter, params, requestOptions)](./ai.chatsession.md#chatsessionconstructor) |  | Constructs a new instance of the <code>ChatSession</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [model](./ai.chatsession.md#chatsessionmodel) |  | string |  |
|  [params](./ai.chatsession.md#chatsessionparams) |  | [StartChatParams](./ai.startchatparams.md#startchatparams_interface) \| undefined |  |
|  [requestOptions](./ai.chatsession.md#chatsessionrequestoptions) |  | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) \| undefined |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [getHistory()](./ai.chatsession.md#chatsessiongethistory) |  | Gets the chat history so far. Blocked prompts are not added to history. Neither blocked candidates nor the prompts that generated them are added to history. |
|  [sendMessage(request)](./ai.chatsession.md#chatsessionsendmessage) |  | Sends a chat message and receives a non-streaming [GenerateContentResult](./ai.generatecontentresult.md#generatecontentresult_interface) |
|  [sendMessageStream(request)](./ai.chatsession.md#chatsessionsendmessagestream) |  | Sends a chat message and receives the response as a [GenerateContentStreamResult](./ai.generatecontentstreamresult.md#generatecontentstreamresult_interface) containing an iterable stream and a response promise. |

## ChatSession.(constructor)

Constructs a new instance of the `ChatSession` class

<b>Signature:</b>

```typescript
constructor(apiSettings: ApiSettings, model: string, chromeAdapter?: ChromeAdapter | undefined, params?: StartChatParams | undefined, requestOptions?: RequestOptions | undefined);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  apiSettings | ApiSettings |  |
|  model | string |  |
|  chromeAdapter | [ChromeAdapter](./ai.chromeadapter.md#chromeadapter_interface) \| undefined |  |
|  params | [StartChatParams](./ai.startchatparams.md#startchatparams_interface) \| undefined |  |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) \| undefined |  |

## ChatSession.model

<b>Signature:</b>

```typescript
model: string;
```

## ChatSession.params

<b>Signature:</b>

```typescript
params?: StartChatParams | undefined;
```

## ChatSession.requestOptions

<b>Signature:</b>

```typescript
requestOptions?: RequestOptions | undefined;
```

## ChatSession.getHistory()

Gets the chat history so far. Blocked prompts are not added to history. Neither blocked candidates nor the prompts that generated them are added to history.

<b>Signature:</b>

```typescript
getHistory(): Promise<Content[]>;
```
<b>Returns:</b>

Promise&lt;[Content](./ai.content.md#content_interface)<!-- -->\[\]&gt;

## ChatSession.sendMessage()

Sends a chat message and receives a non-streaming [GenerateContentResult](./ai.generatecontentresult.md#generatecontentresult_interface)

<b>Signature:</b>

```typescript
sendMessage(request: string | Array<string | Part>): Promise<GenerateContentResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | string \| Array&lt;string \| [Part](./ai.md#part)<!-- -->&gt; |  |

<b>Returns:</b>

Promise&lt;[GenerateContentResult](./ai.generatecontentresult.md#generatecontentresult_interface)<!-- -->&gt;

## ChatSession.sendMessageStream()

Sends a chat message and receives the response as a [GenerateContentStreamResult](./ai.generatecontentstreamresult.md#generatecontentstreamresult_interface) containing an iterable stream and a response promise.

<b>Signature:</b>

```typescript
sendMessageStream(request: string | Array<string | Part>): Promise<GenerateContentStreamResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | string \| Array&lt;string \| [Part](./ai.md#part)<!-- -->&gt; |  |

<b>Returns:</b>

Promise&lt;[GenerateContentStreamResult](./ai.generatecontentstreamresult.md#generatecontentstreamresult_interface)<!-- -->&gt;

