Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ChromeAdapter interface
> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Defines an inference "backend" that uses Chrome's on-device model, and encapsulates logic for detecting when on-device inference is possible.

These methods should not be called directly by the user.

<b>Signature:</b>

```typescript
export interface ChromeAdapter 
```

## Methods

|  Method | Description |
|  --- | --- |
|  [generateContent(request)](./ai.chromeadapter.md#chromeadaptergeneratecontent) | <b><i>(Public Preview)</i></b> Generates content using on-device inference. |
|  [generateContentStream(request)](./ai.chromeadapter.md#chromeadaptergeneratecontentstream) | <b><i>(Public Preview)</i></b> Generates a content stream using on-device inference. |
|  [isAvailable(request)](./ai.chromeadapter.md#chromeadapterisavailable) | <b><i>(Public Preview)</i></b> Checks if the on-device model is capable of handling a given request. |

## ChromeAdapter.generateContent()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Generates content using on-device inference.

This is comparable to [GenerativeModel.generateContent()](./ai.generativemodel.md#generativemodelgeneratecontent) for generating content using in-cloud inference.

<b>Signature:</b>

```typescript
generateContent(request: GenerateContentRequest): Promise<Response>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) | a standard Firebase AI [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) |

<b>Returns:</b>

Promise&lt;Response&gt;

## ChromeAdapter.generateContentStream()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Generates a content stream using on-device inference.

This is comparable to [GenerativeModel.generateContentStream()](./ai.generativemodel.md#generativemodelgeneratecontentstream) for generating a content stream using in-cloud inference.

<b>Signature:</b>

```typescript
generateContentStream(request: GenerateContentRequest): Promise<Response>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) | a standard Firebase AI [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) |

<b>Returns:</b>

Promise&lt;Response&gt;

## ChromeAdapter.isAvailable()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Checks if the on-device model is capable of handling a given request.

<b>Signature:</b>

```typescript
isAvailable(request: GenerateContentRequest): Promise<boolean>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) | A potential request to be passed to the model. |

<b>Returns:</b>

Promise&lt;boolean&gt;

