Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# GenerationConfig interface
Config options for content-related requests

<b>Signature:</b>

```typescript
export interface GenerationConfig 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [candidateCount](./ai.generationconfig.md#generationconfigcandidatecount) | number |  |
|  [frequencyPenalty](./ai.generationconfig.md#generationconfigfrequencypenalty) | number |  |
|  [maxOutputTokens](./ai.generationconfig.md#generationconfigmaxoutputtokens) | number |  |
|  [presencePenalty](./ai.generationconfig.md#generationconfigpresencepenalty) | number |  |
|  [responseMimeType](./ai.generationconfig.md#generationconfigresponsemimetype) | string | Output response MIME type of the generated candidate text. Supported MIME types are <code>text/plain</code> (default, text output), <code>application/json</code> (JSON response in the candidates), and <code>text/x.enum</code>. |
|  [responseModalities](./ai.generationconfig.md#generationconfigresponsemodalities) | [ResponseModality](./ai.md#responsemodality)<!-- -->\[\] | <b><i>(Public Preview)</i></b> Generation modalities to be returned in generation responses. |
|  [responseSchema](./ai.generationconfig.md#generationconfigresponseschema) | [TypedSchema](./ai.md#typedschema) \| [SchemaRequest](./ai.schemarequest.md#schemarequest_interface) | Output response schema of the generated candidate text. This value can be a class generated with a [Schema](./ai.schema.md#schema_class) static method like <code>Schema.string()</code> or <code>Schema.object()</code> or it can be a plain JS object matching the [SchemaRequest](./ai.schemarequest.md#schemarequest_interface) interface. <br/>Note: This only applies when the specified <code>responseMimeType</code> supports a schema; currently this is limited to <code>application/json</code> and <code>text/x.enum</code>. |
|  [stopSequences](./ai.generationconfig.md#generationconfigstopsequences) | string\[\] |  |
|  [temperature](./ai.generationconfig.md#generationconfigtemperature) | number |  |
|  [thinkingConfig](./ai.generationconfig.md#generationconfigthinkingconfig) | [ThinkingConfig](./ai.thinkingconfig.md#thinkingconfig_interface) | Configuration for "thinking" behavior of compatible Gemini models. |
|  [topK](./ai.generationconfig.md#generationconfigtopk) | number |  |
|  [topP](./ai.generationconfig.md#generationconfigtopp) | number |  |

## GenerationConfig.candidateCount

<b>Signature:</b>

```typescript
candidateCount?: number;
```

## GenerationConfig.frequencyPenalty

<b>Signature:</b>

```typescript
frequencyPenalty?: number;
```

## GenerationConfig.maxOutputTokens

<b>Signature:</b>

```typescript
maxOutputTokens?: number;
```

## GenerationConfig.presencePenalty

<b>Signature:</b>

```typescript
presencePenalty?: number;
```

## GenerationConfig.responseMimeType

Output response MIME type of the generated candidate text. Supported MIME types are `text/plain` (default, text output), `application/json` (JSON response in the candidates), and `text/x.enum`<!-- -->.

<b>Signature:</b>

```typescript
responseMimeType?: string;
```

## GenerationConfig.responseModalities

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Generation modalities to be returned in generation responses.

- Multimodal response generation is only supported by some Gemini models and versions; see [model versions](https://firebase.google.com/docs/vertex-ai/models)<!-- -->. - Only image generation (`ResponseModality.IMAGE`<!-- -->) is supported.

<b>Signature:</b>

```typescript
responseModalities?: ResponseModality[];
```

## GenerationConfig.responseSchema

Output response schema of the generated candidate text. This value can be a class generated with a [Schema](./ai.schema.md#schema_class) static method like `Schema.string()` or `Schema.object()` or it can be a plain JS object matching the [SchemaRequest](./ai.schemarequest.md#schemarequest_interface) interface. <br/>Note: This only applies when the specified `responseMimeType` supports a schema; currently this is limited to `application/json` and `text/x.enum`<!-- -->.

<b>Signature:</b>

```typescript
responseSchema?: TypedSchema | SchemaRequest;
```

## GenerationConfig.stopSequences

<b>Signature:</b>

```typescript
stopSequences?: string[];
```

## GenerationConfig.temperature

<b>Signature:</b>

```typescript
temperature?: number;
```

## GenerationConfig.thinkingConfig

Configuration for "thinking" behavior of compatible Gemini models.

<b>Signature:</b>

```typescript
thinkingConfig?: ThinkingConfig;
```

## GenerationConfig.topK

<b>Signature:</b>

```typescript
topK?: number;
```

## GenerationConfig.topP

<b>Signature:</b>

```typescript
topP?: number;
```
