Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# GenerativeModel class
Class for generative model APIs.

<b>Signature:</b>

```typescript
export declare class GenerativeModel extends AIModel 
```
<b>Extends:</b> [AIModel](./ai.aimodel.md#aimodel_class)

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(ai, modelParams, requestOptions, chromeAdapter)](./ai.generativemodel.md#generativemodelconstructor) |  | Constructs a new instance of the <code>GenerativeModel</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [generationConfig](./ai.generativemodel.md#generativemodelgenerationconfig) |  | [GenerationConfig](./ai.generationconfig.md#generationconfig_interface) |  |
|  [requestOptions](./ai.generativemodel.md#generativemodelrequestoptions) |  | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) |  |
|  [safetySettings](./ai.generativemodel.md#generativemodelsafetysettings) |  | [SafetySetting](./ai.safetysetting.md#safetysetting_interface)<!-- -->\[\] |  |
|  [systemInstruction](./ai.generativemodel.md#generativemodelsysteminstruction) |  | [Content](./ai.content.md#content_interface) |  |
|  [toolConfig](./ai.generativemodel.md#generativemodeltoolconfig) |  | [ToolConfig](./ai.toolconfig.md#toolconfig_interface) |  |
|  [tools](./ai.generativemodel.md#generativemodeltools) |  | [Tool](./ai.md#tool)<!-- -->\[\] |  |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [countTokens(request)](./ai.generativemodel.md#generativemodelcounttokens) |  | Counts the tokens in the provided request. |
|  [generateContent(request)](./ai.generativemodel.md#generativemodelgeneratecontent) |  | Makes a single non-streaming call to the model and returns an object containing a single [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface)<!-- -->. |
|  [generateContentStream(request)](./ai.generativemodel.md#generativemodelgeneratecontentstream) |  | Makes a single streaming call to the model and returns an object containing an iterable stream that iterates over all chunks in the streaming response as well as a promise that returns the final aggregated response. |
|  [startChat(startChatParams)](./ai.generativemodel.md#generativemodelstartchat) |  | Gets a new [ChatSession](./ai.chatsession.md#chatsession_class) instance which can be used for multi-turn chats. |

## GenerativeModel.(constructor)

Constructs a new instance of the `GenerativeModel` class

<b>Signature:</b>

```typescript
constructor(ai: AI, modelParams: ModelParams, requestOptions?: RequestOptions, chromeAdapter?: ChromeAdapter | undefined);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) |  |
|  modelParams | [ModelParams](./ai.modelparams.md#modelparams_interface) |  |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) |  |
|  chromeAdapter | [ChromeAdapter](./ai.chromeadapter.md#chromeadapter_interface) \| undefined |  |

## GenerativeModel.generationConfig

<b>Signature:</b>

```typescript
generationConfig: GenerationConfig;
```

## GenerativeModel.requestOptions

<b>Signature:</b>

```typescript
requestOptions?: RequestOptions;
```

## GenerativeModel.safetySettings

<b>Signature:</b>

```typescript
safetySettings: SafetySetting[];
```

## GenerativeModel.systemInstruction

<b>Signature:</b>

```typescript
systemInstruction?: Content;
```

## GenerativeModel.toolConfig

<b>Signature:</b>

```typescript
toolConfig?: ToolConfig;
```

## GenerativeModel.tools

<b>Signature:</b>

```typescript
tools?: Tool[];
```

## GenerativeModel.countTokens()

Counts the tokens in the provided request.

<b>Signature:</b>

```typescript
countTokens(request: CountTokensRequest | string | Array<string | Part>): Promise<CountTokensResponse>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | [CountTokensRequest](./ai.counttokensrequest.md#counttokensrequest_interface) \| string \| Array&lt;string \| [Part](./ai.md#part)<!-- -->&gt; |  |

<b>Returns:</b>

Promise&lt;[CountTokensResponse](./ai.counttokensresponse.md#counttokensresponse_interface)<!-- -->&gt;

## GenerativeModel.generateContent()

Makes a single non-streaming call to the model and returns an object containing a single [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface)<!-- -->.

<b>Signature:</b>

```typescript
generateContent(request: GenerateContentRequest | string | Array<string | Part>): Promise<GenerateContentResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) \| string \| Array&lt;string \| [Part](./ai.md#part)<!-- -->&gt; |  |

<b>Returns:</b>

Promise&lt;[GenerateContentResult](./ai.generatecontentresult.md#generatecontentresult_interface)<!-- -->&gt;

## GenerativeModel.generateContentStream()

Makes a single streaming call to the model and returns an object containing an iterable stream that iterates over all chunks in the streaming response as well as a promise that returns the final aggregated response.

<b>Signature:</b>

```typescript
generateContentStream(request: GenerateContentRequest | string | Array<string | Part>): Promise<GenerateContentStreamResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) \| string \| Array&lt;string \| [Part](./ai.md#part)<!-- -->&gt; |  |

<b>Returns:</b>

Promise&lt;[GenerateContentStreamResult](./ai.generatecontentstreamresult.md#generatecontentstreamresult_interface)<!-- -->&gt;

## GenerativeModel.startChat()

Gets a new [ChatSession](./ai.chatsession.md#chatsession_class) instance which can be used for multi-turn chats.

<b>Signature:</b>

```typescript
startChat(startChatParams?: StartChatParams): ChatSession;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  startChatParams | [StartChatParams](./ai.startchatparams.md#startchatparams_interface) |  |

<b>Returns:</b>

[ChatSession](./ai.chatsession.md#chatsession_class)

