Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# GroundingSupport interface
Provides information about how a specific segment of the model's response is supported by the retrieved grounding chunks.

<b>Signature:</b>

```typescript
export interface GroundingSupport 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [groundingChunkIndices](./ai.groundingsupport.md#groundingsupportgroundingchunkindices) | number\[\] | A list of indices that refer to specific [GroundingChunk](./ai.groundingchunk.md#groundingchunk_interface) objects within the [GroundingMetadata.groundingChunks](./ai.groundingmetadata.md#groundingmetadatagroundingchunks) array. These referenced chunks are the sources that support the claim made in the associated <code>segment</code> of the response. For example, an array <code>[1, 3, 4]</code> means that <code>groundingChunks[1]</code>, <code>groundingChunks[3]</code>, and <code>groundingChunks[4]</code> are the retrieved content supporting this part of the response. |
|  [segment](./ai.groundingsupport.md#groundingsupportsegment) | [Segment](./ai.segment.md#segment_interface) | Specifies the segment of the model's response content that this grounding support pertains to. |

## GroundingSupport.groundingChunkIndices

A list of indices that refer to specific [GroundingChunk](./ai.groundingchunk.md#groundingchunk_interface) objects within the [GroundingMetadata.groundingChunks](./ai.groundingmetadata.md#groundingmetadatagroundingchunks) array. These referenced chunks are the sources that support the claim made in the associated `segment` of the response. For example, an array `[1, 3, 4]` means that `groundingChunks[1]`<!-- -->, `groundingChunks[3]`<!-- -->, and `groundingChunks[4]` are the retrieved content supporting this part of the response.

<b>Signature:</b>

```typescript
groundingChunkIndices?: number[];
```

## GroundingSupport.segment

Specifies the segment of the model's response content that this grounding support pertains to.

<b>Signature:</b>

```typescript
segment?: Segment;
```
