Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ImagenImageFormat class
Defines the image format for images generated by Imagen.

Use this class to specify the desired format (JPEG or PNG) and compression quality for images generated by Imagen. This is typically included as part of [ImagenModelParams](./ai.imagenmodelparams.md#imagenmodelparams_interface)<!-- -->.

<b>Signature:</b>

```typescript
export declare class ImagenImageFormat 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [compressionQuality](./ai.imagenimageformat.md#imagenimageformatcompressionquality) |  | number | The level of compression (a number between 0 and 100). |
|  [mimeType](./ai.imagenimageformat.md#imagenimageformatmimetype) |  | string | The MIME type. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [jpeg(compressionQuality)](./ai.imagenimageformat.md#imagenimageformatjpeg) | <code>static</code> | Creates an [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) for a JPEG image. |
|  [png()](./ai.imagenimageformat.md#imagenimageformatpng) | <code>static</code> | Creates an [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) for a PNG image. |

## ImagenImageFormat.compressionQuality

The level of compression (a number between 0 and 100).

<b>Signature:</b>

```typescript
compressionQuality?: number;
```

## ImagenImageFormat.mimeType

The MIME type.

<b>Signature:</b>

```typescript
mimeType: string;
```

## ImagenImageFormat.jpeg()

Creates an [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) for a JPEG image.

<b>Signature:</b>

```typescript
static jpeg(compressionQuality?: number): ImagenImageFormat;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  compressionQuality | number | The level of compression (a number between 0 and 100). |

<b>Returns:</b>

[ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class)

An [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) object for a JPEG image.

## ImagenImageFormat.png()

Creates an [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) for a PNG image.

<b>Signature:</b>

```typescript
static png(): ImagenImageFormat;
```
<b>Returns:</b>

[ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class)

An [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) object for a PNG image.

### Example


```javascript
const imagenModelParams = {
  // ... other ImagenModelParams
  imageFormat: ImagenImageFormat.jpeg(75) // JPEG with a compression level of 75.
}

```

