Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ImagenModel class
Class for Imagen model APIs.

This class provides methods for generating images using the Imagen model.

<b>Signature:</b>

```typescript
export declare class ImagenModel extends AIModel 
```
<b>Extends:</b> [AIModel](./ai.aimodel.md#aimodel_class)

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(ai, modelParams, requestOptions)](./ai.imagenmodel.md#imagenmodelconstructor) |  | Constructs a new instance of the [ImagenModel](./ai.imagenmodel.md#imagenmodel_class) class. |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [generationConfig](./ai.imagenmodel.md#imagenmodelgenerationconfig) |  | [ImagenGenerationConfig](./ai.imagengenerationconfig.md#imagengenerationconfig_interface) | The Imagen generation configuration. |
|  [requestOptions](./ai.imagenmodel.md#imagenmodelrequestoptions) |  | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) \| undefined |  |
|  [safetySettings](./ai.imagenmodel.md#imagenmodelsafetysettings) |  | [ImagenSafetySettings](./ai.imagensafetysettings.md#imagensafetysettings_interface) | Safety settings for filtering inappropriate content. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [generateImages(prompt)](./ai.imagenmodel.md#imagenmodelgenerateimages) |  | Generates images using the Imagen model and returns them as base64-encoded strings. |

## ImagenModel.(constructor)

Constructs a new instance of the [ImagenModel](./ai.imagenmodel.md#imagenmodel_class) class.

<b>Signature:</b>

```typescript
constructor(ai: AI, modelParams: ImagenModelParams, requestOptions?: RequestOptions | undefined);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) | an [AI](./ai.ai.md#ai_interface) instance. |
|  modelParams | [ImagenModelParams](./ai.imagenmodelparams.md#imagenmodelparams_interface) | Parameters to use when making requests to Imagen. |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) \| undefined | Additional options to use when making requests. |

#### Exceptions

If the `apiKey` or `projectId` fields are missing in your Firebase config.

## ImagenModel.generationConfig

The Imagen generation configuration.

<b>Signature:</b>

```typescript
generationConfig?: ImagenGenerationConfig;
```

## ImagenModel.requestOptions

<b>Signature:</b>

```typescript
requestOptions?: RequestOptions | undefined;
```

## ImagenModel.safetySettings

Safety settings for filtering inappropriate content.

<b>Signature:</b>

```typescript
safetySettings?: ImagenSafetySettings;
```

## ImagenModel.generateImages()

Generates images using the Imagen model and returns them as base64-encoded strings.

If the prompt was not blocked, but one or more of the generated images were filtered, the returned object will have a `filteredReason` property. If all images are filtered, the `images` array will be empty.

<b>Signature:</b>

```typescript
generateImages(prompt: string): Promise<ImagenGenerationResponse<ImagenInlineImage>>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  prompt | string | A text prompt describing the image(s) to generate. |

<b>Returns:</b>

Promise&lt;[ImagenGenerationResponse](./ai.imagengenerationresponse.md#imagengenerationresponse_interface)<!-- -->&lt;[ImagenInlineImage](./ai.imageninlineimage.md#imageninlineimage_interface)<!-- -->&gt;&gt;

A promise that resolves to an [ImagenGenerationResponse](./ai.imagengenerationresponse.md#imagengenerationresponse_interface) object containing the generated images.

#### Exceptions

If the request to generate images fails. This happens if the prompt is blocked.

### Example


```javascript
const imagen = new ImagenModel(
  ai,
  {
    model: 'imagen-3.0-generate-002'
  }
);

const response = await imagen.generateImages('A photo of a cat');
if (response.images.length > 0) {
  console.log(response.images[0].bytesBase64Encoded);
}

```

