Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# LiveSession class
> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Represents an active, real-time, bidirectional conversation with the model.

This class should only be instantiated by calling [LiveGenerativeModel.connect()](./ai.livegenerativemodel.md#livegenerativemodelconnect)<!-- -->.

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `LiveSession` class.

<b>Signature:</b>

```typescript
export declare class LiveSession 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [inConversation](./ai.livesession.md#livesessioninconversation) |  | boolean | <b><i>(Public Preview)</i></b> Indicates whether this Live session is being controlled by an <code>AudioConversationController</code>. |
|  [isClosed](./ai.livesession.md#livesessionisclosed) |  | boolean | <b><i>(Public Preview)</i></b> Indicates whether this Live session is closed. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [close()](./ai.livesession.md#livesessionclose) |  | <b><i>(Public Preview)</i></b> Closes this session. All methods on this session will throw an error once this resolves. |
|  [receive()](./ai.livesession.md#livesessionreceive) |  | <b><i>(Public Preview)</i></b> Yields messages received from the server. This can only be used by one consumer at a time. |
|  [send(request, turnComplete)](./ai.livesession.md#livesessionsend) |  | <b><i>(Public Preview)</i></b> Sends content to the server. |
|  [sendAudioRealtime(blob)](./ai.livesession.md#livesessionsendaudiorealtime) |  | <b><i>(Public Preview)</i></b> Sends audio data to the server in realtime. |
|  [sendFunctionResponses(functionResponses)](./ai.livesession.md#livesessionsendfunctionresponses) |  | <b><i>(Public Preview)</i></b> Sends function responses to the server. |
|  [sendMediaChunks(mediaChunks)](./ai.livesession.md#livesessionsendmediachunks) |  | <b><i>(Public Preview)</i></b> Sends realtime input to the server. |
|  [sendMediaStream(mediaChunkStream)](./ai.livesession.md#livesessionsendmediastream) |  | <b><i>(Public Preview)</i></b> |
|  [sendTextRealtime(text)](./ai.livesession.md#livesessionsendtextrealtime) |  | <b><i>(Public Preview)</i></b> Sends text to the server in realtime. |
|  [sendVideoRealtime(blob)](./ai.livesession.md#livesessionsendvideorealtime) |  | <b><i>(Public Preview)</i></b> Sends video data to the server in realtime. |

## LiveSession.inConversation

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Indicates whether this Live session is being controlled by an `AudioConversationController`<!-- -->.

<b>Signature:</b>

```typescript
inConversation: boolean;
```

## LiveSession.isClosed

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Indicates whether this Live session is closed.

<b>Signature:</b>

```typescript
isClosed: boolean;
```

## LiveSession.close()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Closes this session. All methods on this session will throw an error once this resolves.

<b>Signature:</b>

```typescript
close(): Promise<void>;
```
<b>Returns:</b>

Promise&lt;void&gt;

## LiveSession.receive()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Yields messages received from the server. This can only be used by one consumer at a time.

<b>Signature:</b>

```typescript
receive(): AsyncGenerator<LiveServerContent | LiveServerToolCall | LiveServerToolCallCancellation>;
```
<b>Returns:</b>

AsyncGenerator&lt;[LiveServerContent](./ai.liveservercontent.md#liveservercontent_interface) \| [LiveServerToolCall](./ai.liveservertoolcall.md#liveservertoolcall_interface) \| [LiveServerToolCallCancellation](./ai.liveservertoolcallcancellation.md#liveservertoolcallcancellation_interface)<!-- -->&gt;

An `AsyncGenerator` that yields server messages as they arrive.

#### Exceptions

If the session is already closed, or if we receive a response that we don't support.

## LiveSession.send()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Sends content to the server.

<b>Signature:</b>

```typescript
send(request: string | Array<string | Part>, turnComplete?: boolean): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  request | string \| Array&lt;string \| [Part](./ai.md#part)<!-- -->&gt; | The message to send to the model. |
|  turnComplete | boolean | Indicates if the turn is complete. Defaults to false. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

## LiveSession.sendAudioRealtime()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Sends audio data to the server in realtime.

The server requires that the audio data is base64-encoded 16-bit PCM at 16kHz little-endian.

<b>Signature:</b>

```typescript
sendAudioRealtime(blob: GenerativeContentBlob): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  blob | [GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface) | The base64-encoded PCM data to send to the server in realtime. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

### Example


```javascript
// const pcmData = ... base64-encoded 16-bit PCM at 16kHz little-endian.
const blob = { mimeType: "audio/pcm", data: pcmData };
liveSession.sendAudioRealtime(blob);

```

## LiveSession.sendFunctionResponses()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Sends function responses to the server.

<b>Signature:</b>

```typescript
sendFunctionResponses(functionResponses: FunctionResponse[]): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  functionResponses | [FunctionResponse](./ai.functionresponse.md#functionresponse_interface)<!-- -->\[\] | The function responses to send. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

## LiveSession.sendMediaChunks()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

> Warning: This API is now obsolete.
> 
> Use `sendTextRealtime()`<!-- -->, `sendAudioRealtime()`<!-- -->, and `sendVideoRealtime()` instead.
> 

Sends realtime input to the server.

<b>Signature:</b>

```typescript
sendMediaChunks(mediaChunks: GenerativeContentBlob[]): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  mediaChunks | [GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface)<!-- -->\[\] | The media chunks to send. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

## LiveSession.sendMediaStream()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

> Warning: This API is now obsolete.
> 
> Use `sendTextRealtime()`<!-- -->, `sendAudioRealtime()`<!-- -->, and `sendVideoRealtime()` instead.
> 
> Sends a stream of [GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface)<!-- -->.
> 

<b>Signature:</b>

```typescript
sendMediaStream(mediaChunkStream: ReadableStream<GenerativeContentBlob>): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  mediaChunkStream | ReadableStream&lt;[GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface)<!-- -->&gt; | The stream of [GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface) to send. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

## LiveSession.sendTextRealtime()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Sends text to the server in realtime.

<b>Signature:</b>

```typescript
sendTextRealtime(text: string): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  text | string | The text data to send. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

### Example


```javascript
liveSession.sendTextRealtime("Hello, how are you?");

```

## LiveSession.sendVideoRealtime()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Sends video data to the server in realtime.

The server requires that the video is sent as individual video frames at 1 FPS. It is recommended to set `mimeType` to `image/jpeg`<!-- -->.

<b>Signature:</b>

```typescript
sendVideoRealtime(blob: GenerativeContentBlob): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  blob | [GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface) | The base64-encoded video data to send to the server in realtime. |

<b>Returns:</b>

Promise&lt;void&gt;

#### Exceptions

If this session has been closed.

### Example


```javascript
// const videoFrame = ... base64-encoded JPEG data
const blob = { mimeType: "image/jpeg", data: videoFrame };
liveSession.sendVideoRealtime(blob);

```

