Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ai package
The Firebase AI Web SDK.

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getAI(app, options)](./ai.md#getai_a94a413) | Returns the default [AI](./ai.ai.md#ai_interface) instance that is associated with the provided [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)<!-- -->. If no instance exists, initializes a new instance with the default settings. |
|  <b>function(ai, ...)</b> |
|  [getGenerativeModel(ai, modelParams, requestOptions)](./ai.md#getgenerativemodel_c63f46a) | Returns a [GenerativeModel](./ai.generativemodel.md#generativemodel_class) class with methods for inference and other functionality. |
|  [getImagenModel(ai, modelParams, requestOptions)](./ai.md#getimagenmodel_e1f6645) | Returns an [ImagenModel](./ai.imagenmodel.md#imagenmodel_class) class with methods for using Imagen.<!-- -->Only Imagen 3 models (named <code>imagen-3.0-*</code>) are supported. |
|  [getLiveGenerativeModel(ai, modelParams)](./ai.md#getlivegenerativemodel_f2099ac) | <b><i>(Public Preview)</i></b> Returns a [LiveGenerativeModel](./ai.livegenerativemodel.md#livegenerativemodel_class) class for real-time, bidirectional communication.<!-- -->The Live API is only supported in modern browser windows and Node &gt;<!-- -->= 22. |
|  [getTemplateGenerativeModel(ai, requestOptions)](./ai.md#gettemplategenerativemodel_9476bbc) | <b><i>(Public Preview)</i></b> Returns a [TemplateGenerativeModel](./ai.templategenerativemodel.md#templategenerativemodel_class) class for executing server-side templates. |
|  [getTemplateImagenModel(ai, requestOptions)](./ai.md#gettemplateimagenmodel_9476bbc) | <b><i>(Public Preview)</i></b> Returns a [TemplateImagenModel](./ai.templateimagenmodel.md#templateimagenmodel_class) class for executing server-side Imagen templates. |
|  <b>function(liveSession, ...)</b> |
|  [startAudioConversation(liveSession, options)](./ai.md#startaudioconversation_01c8e7f) | <b><i>(Public Preview)</i></b> Starts a real-time, bidirectional audio conversation with the model. This helper function manages the complexities of microphone access, audio recording, playback, and interruptions. |

## Classes

|  Class | Description |
|  --- | --- |
|  [AIError](./ai.aierror.md#aierror_class) | Error class for the Firebase AI SDK. |
|  [AIModel](./ai.aimodel.md#aimodel_class) | Base class for Firebase AI model APIs.<!-- -->Instances of this class are associated with a specific Firebase AI [Backend](./ai.backend.md#backend_class) and provide methods for interacting with the configured generative model. |
|  [AnyOfSchema](./ai.anyofschema.md#anyofschema_class) | Schema class representing a value that can conform to any of the provided sub-schemas. This is useful when a field can accept multiple distinct types or structures. |
|  [ArraySchema](./ai.arrayschema.md#arrayschema_class) | Schema class for "array" types. The <code>items</code> param should refer to the type of item that can be a member of the array. |
|  [Backend](./ai.backend.md#backend_class) | Abstract base class representing the configuration for an AI service backend. This class should not be instantiated directly. Use its subclasses; [GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class) for the Gemini Developer API (via [Google AI](https://ai.google/)<!-- -->), and [VertexAIBackend](./ai.vertexaibackend.md#vertexaibackend_class) for the Vertex AI Gemini API. |
|  [BooleanSchema](./ai.booleanschema.md#booleanschema_class) | Schema class for "boolean" types. |
|  [ChatSession](./ai.chatsession.md#chatsession_class) | ChatSession class that enables sending chat messages and stores history of sent and received messages so far. |
|  [GenerativeModel](./ai.generativemodel.md#generativemodel_class) | Class for generative model APIs. |
|  [GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class) | Configuration class for the Gemini Developer API.<!-- -->Use this with [AIOptions](./ai.aioptions.md#aioptions_interface) when initializing the AI service via [getAI()](./ai.md#getai_a94a413) to specify the Gemini Developer API as the backend. |
|  [ImagenImageFormat](./ai.imagenimageformat.md#imagenimageformat_class) | Defines the image format for images generated by Imagen.<!-- -->Use this class to specify the desired format (JPEG or PNG) and compression quality for images generated by Imagen. This is typically included as part of [ImagenModelParams](./ai.imagenmodelparams.md#imagenmodelparams_interface)<!-- -->. |
|  [ImagenModel](./ai.imagenmodel.md#imagenmodel_class) | Class for Imagen model APIs.<!-- -->This class provides methods for generating images using the Imagen model. |
|  [IntegerSchema](./ai.integerschema.md#integerschema_class) | Schema class for "integer" types. |
|  [LiveGenerativeModel](./ai.livegenerativemodel.md#livegenerativemodel_class) | <b><i>(Public Preview)</i></b> Class for Live generative model APIs. The Live API enables low-latency, two-way multimodal interactions with Gemini.<!-- -->This class should only be instantiated with [getLiveGenerativeModel()](./ai.md#getlivegenerativemodel_f2099ac)<!-- -->. |
|  [LiveSession](./ai.livesession.md#livesession_class) | <b><i>(Public Preview)</i></b> Represents an active, real-time, bidirectional conversation with the model.<!-- -->This class should only be instantiated by calling [LiveGenerativeModel.connect()](./ai.livegenerativemodel.md#livegenerativemodelconnect)<!-- -->. |
|  [NumberSchema](./ai.numberschema.md#numberschema_class) | Schema class for "number" types. |
|  [ObjectSchema](./ai.objectschema.md#objectschema_class) | Schema class for "object" types. The <code>properties</code> param must be a map of <code>Schema</code> objects. |
|  [Schema](./ai.schema.md#schema_class) | Parent class encompassing all Schema types, with static methods that allow building specific Schema types. This class can be converted with <code>JSON.stringify()</code> into a JSON string accepted by Vertex AI REST endpoints. (This string conversion is automatically done when calling SDK methods.) |
|  [StringSchema](./ai.stringschema.md#stringschema_class) | Schema class for "string" types. Can be used with or without enum values. |
|  [TemplateGenerativeModel](./ai.templategenerativemodel.md#templategenerativemodel_class) | <b><i>(Public Preview)</i></b> [GenerativeModel](./ai.generativemodel.md#generativemodel_class) APIs that execute on a server-side template.<!-- -->This class should only be instantiated with [getTemplateGenerativeModel()](./ai.md#gettemplategenerativemodel_9476bbc)<!-- -->. |
|  [TemplateImagenModel](./ai.templateimagenmodel.md#templateimagenmodel_class) | <b><i>(Public Preview)</i></b> Class for Imagen model APIs that execute on a server-side template.<!-- -->This class should only be instantiated with [getTemplateImagenModel()](./ai.md#gettemplateimagenmodel_9476bbc)<!-- -->. |
|  [VertexAIBackend](./ai.vertexaibackend.md#vertexaibackend_class) | Configuration class for the Vertex AI Gemini API.<!-- -->Use this with [AIOptions](./ai.aioptions.md#aioptions_interface) when initializing the AI service via [getAI()](./ai.md#getai_a94a413) to specify the Vertex AI Gemini API as the backend. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [AI](./ai.ai.md#ai_interface) | An instance of the Firebase AI SDK.<!-- -->Do not create this instance directly. Instead, use [getAI()](./ai.md#getai_a94a413)<!-- -->. |
|  [AIOptions](./ai.aioptions.md#aioptions_interface) | Options for initializing the AI service using [getAI()](./ai.md#getai_a94a413)<!-- -->. This allows specifying which backend to use (Vertex AI Gemini API or Gemini Developer API) and configuring its specific options (like location for Vertex AI). |
|  [AudioConversationController](./ai.audioconversationcontroller.md#audioconversationcontroller_interface) | <b><i>(Public Preview)</i></b> A controller for managing an active audio conversation. |
|  [AudioTranscriptionConfig](./ai.audiotranscriptionconfig.md#audiotranscriptionconfig_interface) | The audio transcription configuration. |
|  [BaseParams](./ai.baseparams.md#baseparams_interface) | Base parameters for a number of methods. |
|  [ChromeAdapter](./ai.chromeadapter.md#chromeadapter_interface) | <b><i>(Public Preview)</i></b> Defines an inference "backend" that uses Chrome's on-device model, and encapsulates logic for detecting when on-device inference is possible.<!-- -->These methods should not be called directly by the user. |
|  [Citation](./ai.citation.md#citation_interface) | A single citation. |
|  [CitationMetadata](./ai.citationmetadata.md#citationmetadata_interface) | Citation metadata that may be found on a [GenerateContentCandidate](./ai.generatecontentcandidate.md#generatecontentcandidate_interface)<!-- -->. |
|  [CodeExecutionResult](./ai.codeexecutionresult.md#codeexecutionresult_interface) | <b><i>(Public Preview)</i></b> The results of code execution run by the model. |
|  [CodeExecutionResultPart](./ai.codeexecutionresultpart.md#codeexecutionresultpart_interface) | <b><i>(Public Preview)</i></b> Represents the code execution result from the model. |
|  [CodeExecutionTool](./ai.codeexecutiontool.md#codeexecutiontool_interface) | <b><i>(Public Preview)</i></b> A tool that enables the model to use code execution. |
|  [Content](./ai.content.md#content_interface) | Content type for both prompts and response candidates. |
|  [CountTokensRequest](./ai.counttokensrequest.md#counttokensrequest_interface) | Params for calling [GenerativeModel.countTokens()](./ai.generativemodel.md#generativemodelcounttokens) |
|  [CountTokensResponse](./ai.counttokensresponse.md#counttokensresponse_interface) | Response from calling [GenerativeModel.countTokens()](./ai.generativemodel.md#generativemodelcounttokens)<!-- -->. |
|  [CustomErrorData](./ai.customerrordata.md#customerrordata_interface) | Details object that contains data originating from a bad HTTP response. |
|  [Date\_2](./ai.date_2.md#date_2_interface) | Protobuf google.type.Date |
|  [EnhancedGenerateContentResponse](./ai.enhancedgeneratecontentresponse.md#enhancedgeneratecontentresponse_interface) | Response object wrapped with helper methods. |
|  [ErrorDetails](./ai.errordetails.md#errordetails_interface) | Details object that may be included in an error response. |
|  [ExecutableCode](./ai.executablecode.md#executablecode_interface) | <b><i>(Public Preview)</i></b> An interface for executable code returned by the model. |
|  [ExecutableCodePart](./ai.executablecodepart.md#executablecodepart_interface) | <b><i>(Public Preview)</i></b> Represents the code that is executed by the model. |
|  [FileData](./ai.filedata.md#filedata_interface) | Data pointing to a file uploaded on Google Cloud Storage. |
|  [FileDataPart](./ai.filedatapart.md#filedatapart_interface) | Content part interface if the part represents [FileData](./ai.filedata.md#filedata_interface) |
|  [FunctionCall](./ai.functioncall.md#functioncall_interface) | A predicted [FunctionCall](./ai.functioncall.md#functioncall_interface) returned from the model that contains a string representing the [FunctionDeclaration.name](./ai.functiondeclaration.md#functiondeclarationname) and a structured JSON object containing the parameters and their values. |
|  [FunctionCallingConfig](./ai.functioncallingconfig.md#functioncallingconfig_interface) |  |
|  [FunctionCallPart](./ai.functioncallpart.md#functioncallpart_interface) | Content part interface if the part represents a [FunctionCall](./ai.functioncall.md#functioncall_interface)<!-- -->. |
|  [FunctionDeclaration](./ai.functiondeclaration.md#functiondeclaration_interface) | Structured representation of a function declaration as defined by the [OpenAPI 3.0 specification](https://spec.openapis.org/oas/v3.0.3)<!-- -->. Included in this declaration are the function name and parameters. This <code>FunctionDeclaration</code> is a representation of a block of code that can be used as a Tool by the model and executed by the client. |
|  [FunctionDeclarationsTool](./ai.functiondeclarationstool.md#functiondeclarationstool_interface) | A <code>FunctionDeclarationsTool</code> is a piece of code that enables the system to interact with external systems to perform an action, or set of actions, outside of knowledge and scope of the model. |
|  [FunctionResponse](./ai.functionresponse.md#functionresponse_interface) | The result output from a [FunctionCall](./ai.functioncall.md#functioncall_interface) that contains a string representing the [FunctionDeclaration.name](./ai.functiondeclaration.md#functiondeclarationname) and a structured JSON object containing any output from the function is used as context to the model. This should contain the result of a [FunctionCall](./ai.functioncall.md#functioncall_interface) made based on model prediction. |
|  [FunctionResponsePart](./ai.functionresponsepart.md#functionresponsepart_interface) | Content part interface if the part represents [FunctionResponse](./ai.functionresponse.md#functionresponse_interface)<!-- -->. |
|  [GenerateContentCandidate](./ai.generatecontentcandidate.md#generatecontentcandidate_interface) | A candidate returned as part of a [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface)<!-- -->. |
|  [GenerateContentRequest](./ai.generatecontentrequest.md#generatecontentrequest_interface) | Request sent through [GenerativeModel.generateContent()](./ai.generativemodel.md#generativemodelgeneratecontent) |
|  [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface) | Individual response from [GenerativeModel.generateContent()](./ai.generativemodel.md#generativemodelgeneratecontent) and [GenerativeModel.generateContentStream()](./ai.generativemodel.md#generativemodelgeneratecontentstream)<!-- -->. <code>generateContentStream()</code> will return one in each chunk until the stream is done. |
|  [GenerateContentResult](./ai.generatecontentresult.md#generatecontentresult_interface) | Result object returned from [GenerativeModel.generateContent()](./ai.generativemodel.md#generativemodelgeneratecontent) call. |
|  [GenerateContentStreamResult](./ai.generatecontentstreamresult.md#generatecontentstreamresult_interface) | Result object returned from [GenerativeModel.generateContentStream()](./ai.generativemodel.md#generativemodelgeneratecontentstream) call. Iterate over <code>stream</code> to get chunks as they come in and/or use the <code>response</code> promise to get the aggregated response when the stream is done. |
|  [GenerationConfig](./ai.generationconfig.md#generationconfig_interface) | Config options for content-related requests |
|  [GenerativeContentBlob](./ai.generativecontentblob.md#generativecontentblob_interface) | Interface for sending an image. |
|  [GoogleSearch](./ai.googlesearch.md#googlesearch_interface) | Specifies the Google Search configuration. |
|  [GoogleSearchTool](./ai.googlesearchtool.md#googlesearchtool_interface) | A tool that allows a Gemini model to connect to Google Search to access and incorporate up-to-date information from the web into its responses.<!-- -->Important: If using Grounding with Google Search, you are required to comply with the "Grounding with Google Search" usage requirements for your chosen API provider: [Gemini Developer API](https://ai.google.dev/gemini-api/terms#grounding-with-google-search) or Vertex AI Gemini API (see [Service Terms](https://cloud.google.com/terms/service-terms) section within the Service Specific Terms). |
|  [GroundingChunk](./ai.groundingchunk.md#groundingchunk_interface) | Represents a chunk of retrieved data that supports a claim in the model's response. This is part of the grounding information provided when grounding is enabled. |
|  [GroundingMetadata](./ai.groundingmetadata.md#groundingmetadata_interface) | Metadata returned when grounding is enabled.<!-- -->Currently, only Grounding with Google Search is supported (see [GoogleSearchTool](./ai.googlesearchtool.md#googlesearchtool_interface)<!-- -->).<!-- -->Important: If using Grounding with Google Search, you are required to comply with the "Grounding with Google Search" usage requirements for your chosen API provider: [Gemini Developer API](https://ai.google.dev/gemini-api/terms#grounding-with-google-search) or Vertex AI Gemini API (see [Service Terms](https://cloud.google.com/terms/service-terms) section within the Service Specific Terms). |
|  [GroundingSupport](./ai.groundingsupport.md#groundingsupport_interface) | Provides information about how a specific segment of the model's response is supported by the retrieved grounding chunks. |
|  [HybridParams](./ai.hybridparams.md#hybridparams_interface) | <b><i>(Public Preview)</i></b> Configures hybrid inference. |
|  [ImagenGCSImage](./ai.imagengcsimage.md#imagengcsimage_interface) | An image generated by Imagen, stored in a Cloud Storage for Firebase bucket.<!-- -->This feature is not available yet. |
|  [ImagenGenerationConfig](./ai.imagengenerationconfig.md#imagengenerationconfig_interface) | Configuration options for generating images with Imagen.<!-- -->See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images-imagen) for more details. |
|  [ImagenGenerationResponse](./ai.imagengenerationresponse.md#imagengenerationresponse_interface) | The response from a request to generate images with Imagen. |
|  [ImagenInlineImage](./ai.imageninlineimage.md#imageninlineimage_interface) | An image generated by Imagen, represented as inline data. |
|  [ImagenModelParams](./ai.imagenmodelparams.md#imagenmodelparams_interface) | Parameters for configuring an [ImagenModel](./ai.imagenmodel.md#imagenmodel_class)<!-- -->. |
|  [ImagenSafetySettings](./ai.imagensafetysettings.md#imagensafetysettings_interface) | Settings for controlling the aggressiveness of filtering out sensitive content.<!-- -->See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) for more details. |
|  [InlineDataPart](./ai.inlinedatapart.md#inlinedatapart_interface) | Content part interface if the part represents an image. |
|  [LanguageModelCreateCoreOptions](./ai.languagemodelcreatecoreoptions.md#languagemodelcreatecoreoptions_interface) | <b><i>(Public Preview)</i></b> Configures the creation of an on-device language model session. |
|  [LanguageModelCreateOptions](./ai.languagemodelcreateoptions.md#languagemodelcreateoptions_interface) | <b><i>(Public Preview)</i></b> Configures the creation of an on-device language model session. |
|  [LanguageModelExpected](./ai.languagemodelexpected.md#languagemodelexpected_interface) | <b><i>(Public Preview)</i></b> Options for the expected inputs for an on-device language model. |
|  [LanguageModelMessage](./ai.languagemodelmessage.md#languagemodelmessage_interface) | <b><i>(Public Preview)</i></b> An on-device language model message. |
|  [LanguageModelMessageContent](./ai.languagemodelmessagecontent.md#languagemodelmessagecontent_interface) | <b><i>(Public Preview)</i></b> An on-device language model content object. |
|  [LanguageModelPromptOptions](./ai.languagemodelpromptoptions.md#languagemodelpromptoptions_interface) | <b><i>(Public Preview)</i></b> Options for an on-device language model prompt. |
|  [LiveGenerationConfig](./ai.livegenerationconfig.md#livegenerationconfig_interface) | <b><i>(Public Preview)</i></b> Configuration parameters used by [LiveGenerativeModel](./ai.livegenerativemodel.md#livegenerativemodel_class) to control live content generation. |
|  [LiveModelParams](./ai.livemodelparams.md#livemodelparams_interface) | <b><i>(Public Preview)</i></b> Params passed to [getLiveGenerativeModel()](./ai.md#getlivegenerativemodel_f2099ac)<!-- -->. |
|  [LiveServerContent](./ai.liveservercontent.md#liveservercontent_interface) | <b><i>(Public Preview)</i></b> An incremental content update from the model. |
|  [LiveServerToolCall](./ai.liveservertoolcall.md#liveservertoolcall_interface) | <b><i>(Public Preview)</i></b> A request from the model for the client to execute one or more functions. |
|  [LiveServerToolCallCancellation](./ai.liveservertoolcallcancellation.md#liveservertoolcallcancellation_interface) | <b><i>(Public Preview)</i></b> Notification to cancel a previous function call triggered by [LiveServerToolCall](./ai.liveservertoolcall.md#liveservertoolcall_interface)<!-- -->. |
|  [ModalityTokenCount](./ai.modalitytokencount.md#modalitytokencount_interface) | Represents token counting info for a single modality. |
|  [ModelParams](./ai.modelparams.md#modelparams_interface) | Params passed to [getGenerativeModel()](./ai.md#getgenerativemodel_c63f46a)<!-- -->. |
|  [ObjectSchemaRequest](./ai.objectschemarequest.md#objectschemarequest_interface) | Interface for JSON parameters in a schema of [SchemaType](./ai.md#schematype) "object" when not using the <code>Schema.object()</code> helper. |
|  [OnDeviceParams](./ai.ondeviceparams.md#ondeviceparams_interface) | <b><i>(Public Preview)</i></b> Encapsulates configuration for on-device inference. |
|  [PrebuiltVoiceConfig](./ai.prebuiltvoiceconfig.md#prebuiltvoiceconfig_interface) | <b><i>(Public Preview)</i></b> Configuration for a pre-built voice. |
|  [PromptFeedback](./ai.promptfeedback.md#promptfeedback_interface) | If the prompt was blocked, this will be populated with <code>blockReason</code> and the relevant <code>safetyRatings</code>. |
|  [RequestOptions](./ai.requestoptions.md#requestoptions_interface) | Params passed to [getGenerativeModel()](./ai.md#getgenerativemodel_c63f46a)<!-- -->. |
|  [RetrievedContextAttribution](./ai.retrievedcontextattribution.md#retrievedcontextattribution_interface) |  |
|  [SafetyRating](./ai.safetyrating.md#safetyrating_interface) | A safety rating associated with a [GenerateContentCandidate](./ai.generatecontentcandidate.md#generatecontentcandidate_interface) |
|  [SafetySetting](./ai.safetysetting.md#safetysetting_interface) | Safety setting that can be sent as part of request parameters. |
|  [SchemaInterface](./ai.schemainterface.md#schemainterface_interface) | Interface for [Schema](./ai.schema.md#schema_class) class. |
|  [SchemaParams](./ai.schemaparams.md#schemaparams_interface) | Params passed to [Schema](./ai.schema.md#schema_class) static methods to create specific [Schema](./ai.schema.md#schema_class) classes. |
|  [SchemaRequest](./ai.schemarequest.md#schemarequest_interface) | Final format for [Schema](./ai.schema.md#schema_class) params passed to backend requests. |
|  [SchemaShared](./ai.schemashared.md#schemashared_interface) | Basic [Schema](./ai.schema.md#schema_class) properties shared across several Schema-related types. |
|  [SearchEntrypoint](./ai.searchentrypoint.md#searchentrypoint_interface) | Google search entry point. |
|  [Segment](./ai.segment.md#segment_interface) | Represents a specific segment within a [Content](./ai.content.md#content_interface) object, often used to pinpoint the exact location of text or data that grounding information refers to. |
|  [SpeechConfig](./ai.speechconfig.md#speechconfig_interface) | <b><i>(Public Preview)</i></b> Configures speech synthesis. |
|  [StartAudioConversationOptions](./ai.startaudioconversationoptions.md#startaudioconversationoptions_interface) | <b><i>(Public Preview)</i></b> Options for [startAudioConversation()](./ai.md#startaudioconversation_01c8e7f)<!-- -->. |
|  [StartChatParams](./ai.startchatparams.md#startchatparams_interface) | Params for [GenerativeModel.startChat()](./ai.generativemodel.md#generativemodelstartchat)<!-- -->. |
|  [TextPart](./ai.textpart.md#textpart_interface) | Content part interface if the part represents a text string. |
|  [ThinkingConfig](./ai.thinkingconfig.md#thinkingconfig_interface) | Configuration for "thinking" behavior of compatible Gemini models.<!-- -->Certain models utilize a thinking process before generating a response. This allows them to reason through complex problems and plan a more coherent and accurate answer. |
|  [ToolConfig](./ai.toolconfig.md#toolconfig_interface) | Tool config. This config is shared for all tools provided in the request. |
|  [Transcription](./ai.transcription.md#transcription_interface) | <b><i>(Public Preview)</i></b> Transcription of audio. This can be returned from a [LiveGenerativeModel](./ai.livegenerativemodel.md#livegenerativemodel_class) if transcription is enabled with the <code>inputAudioTranscription</code> or <code>outputAudioTranscription</code> properties on the [LiveGenerationConfig](./ai.livegenerationconfig.md#livegenerationconfig_interface)<!-- -->. |
|  [URLContext](./ai.urlcontext.md#urlcontext_interface) | <b><i>(Public Preview)</i></b> Specifies the URL Context configuration. |
|  [URLContextMetadata](./ai.urlcontextmetadata.md#urlcontextmetadata_interface) | <b><i>(Public Preview)</i></b> Metadata related to [URLContextTool](./ai.urlcontexttool.md#urlcontexttool_interface)<!-- -->. |
|  [URLContextTool](./ai.urlcontexttool.md#urlcontexttool_interface) | <b><i>(Public Preview)</i></b> A tool that allows you to provide additional context to the models in the form of public web URLs. By including URLs in your request, the Gemini model will access the content from those pages to inform and enhance its response. |
|  [URLMetadata](./ai.urlmetadata.md#urlmetadata_interface) | <b><i>(Public Preview)</i></b> Metadata for a single URL retrieved by the [URLContextTool](./ai.urlcontexttool.md#urlcontexttool_interface) tool. |
|  [UsageMetadata](./ai.usagemetadata.md#usagemetadata_interface) | Usage metadata about a [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface)<!-- -->. |
|  [VideoMetadata](./ai.videometadata.md#videometadata_interface) | Describes the input video content. |
|  [VoiceConfig](./ai.voiceconfig.md#voiceconfig_interface) | <b><i>(Public Preview)</i></b> Configuration for the voice to used in speech synthesis. |
|  [WebAttribution](./ai.webattribution.md#webattribution_interface) |  |
|  [WebGroundingChunk](./ai.webgroundingchunk.md#webgroundingchunk_interface) | A grounding chunk from the web.<!-- -->Important: If using Grounding with Google Search, you are required to comply with the [Service Specific Terms](https://cloud.google.com/terms/service-terms) for "Grounding with Google Search". |

## Variables

|  Variable | Description |
|  --- | --- |
|  [AIErrorCode](./ai.md#aierrorcode) | Standardized error codes that [AIError](./ai.aierror.md#aierror_class) can have. |
|  [BackendType](./ai.md#backendtype) | An enum-like object containing constants that represent the supported backends for the Firebase AI SDK. This determines which backend service (Vertex AI Gemini API or Gemini Developer API) the SDK will communicate with.<!-- -->These values are assigned to the <code>backendType</code> property within the specific backend configuration objects ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class) or [VertexAIBackend](./ai.vertexaibackend.md#vertexaibackend_class)<!-- -->) to identify which service to target. |
|  [BlockReason](./ai.md#blockreason) | Reason that a prompt was blocked. |
|  [FinishReason](./ai.md#finishreason) | Reason that a candidate finished. |
|  [FunctionCallingMode](./ai.md#functioncallingmode) |  |
|  [HarmBlockMethod](./ai.md#harmblockmethod) | This property is not supported in the Gemini Developer API ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class)<!-- -->). |
|  [HarmBlockThreshold](./ai.md#harmblockthreshold) | Threshold above which a prompt or candidate will be blocked. |
|  [HarmCategory](./ai.md#harmcategory) | Harm categories that would cause prompts or candidates to be blocked. |
|  [HarmProbability](./ai.md#harmprobability) | Probability that a prompt or candidate matches a harm category. |
|  [HarmSeverity](./ai.md#harmseverity) | Harm severity levels. |
|  [ImagenAspectRatio](./ai.md#imagenaspectratio) | Aspect ratios for Imagen images.<!-- -->To specify an aspect ratio for generated images, set the <code>aspectRatio</code> property in your [ImagenGenerationConfig](./ai.imagengenerationconfig.md#imagengenerationconfig_interface)<!-- -->.<!-- -->See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) for more details and examples of the supported aspect ratios. |
|  [ImagenPersonFilterLevel](./ai.md#imagenpersonfilterlevel) | A filter level controlling whether generation of images containing people or faces is allowed.<!-- -->See the <a href="http://firebase.google.com/docs/vertex-ai/generate-images">personGeneration</a> documentation for more details. |
|  [ImagenSafetyFilterLevel](./ai.md#imagensafetyfilterlevel) | A filter level controlling how aggressively to filter sensitive content.<!-- -->Text prompts provided as inputs and images (generated or uploaded) through Imagen on Vertex AI are assessed against a list of safety filters, which include 'harmful categories' (for example, <code>violence</code>, <code>sexual</code>, <code>derogatory</code>, and <code>toxic</code>). This filter level controls how aggressively to filter out potentially harmful content from responses. See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) and the [Responsible AI and usage guidelines](https://cloud.google.com/vertex-ai/generative-ai/docs/image/responsible-ai-imagen#safety-filters) for more details. |
|  [InferenceMode](./ai.md#inferencemode) | <b><i>(Public Preview)</i></b> Determines whether inference happens on-device or in-cloud. |
|  [InferenceSource](./ai.md#inferencesource) | <b><i>(Public Preview)</i></b> Indicates whether inference happened on-device or in-cloud. |
|  [Language](./ai.md#language) | <b><i>(Public Preview)</i></b> The programming language of the code. |
|  [LiveResponseType](./ai.md#liveresponsetype) | <b><i>(Public Preview)</i></b> The types of responses that can be returned by [LiveSession.receive()](./ai.livesession.md#livesessionreceive)<!-- -->. |
|  [Modality](./ai.md#modality) | Content part modality. |
|  [Outcome](./ai.md#outcome) | <b><i>(Public Preview)</i></b> Represents the result of the code execution. |
|  [POSSIBLE\_ROLES](./ai.md#possible_roles) | Possible roles. |
|  [ResponseModality](./ai.md#responsemodality) | <b><i>(Public Preview)</i></b> Generation modalities to be returned in generation responses. |
|  [SchemaType](./ai.md#schematype) | Contains the list of OpenAPI data types as defined by the [OpenAPI specification](https://swagger.io/docs/specification/data-models/data-types/) |
|  [URLRetrievalStatus](./ai.md#urlretrievalstatus) | <b><i>(Public Preview)</i></b> The status of a URL retrieval. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AIErrorCode](./ai.md#aierrorcode) | Standardized error codes that [AIError](./ai.aierror.md#aierror_class) can have. |
|  [BackendType](./ai.md#backendtype) | Type alias representing valid backend types. It can be either <code>'VERTEX_AI'</code> or <code>'GOOGLE_AI'</code>. |
|  [BlockReason](./ai.md#blockreason) | Reason that a prompt was blocked. |
|  [FinishReason](./ai.md#finishreason) | Reason that a candidate finished. |
|  [FunctionCallingMode](./ai.md#functioncallingmode) |  |
|  [HarmBlockMethod](./ai.md#harmblockmethod) | This property is not supported in the Gemini Developer API ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class)<!-- -->). |
|  [HarmBlockThreshold](./ai.md#harmblockthreshold) | Threshold above which a prompt or candidate will be blocked. |
|  [HarmCategory](./ai.md#harmcategory) | Harm categories that would cause prompts or candidates to be blocked. |
|  [HarmProbability](./ai.md#harmprobability) | Probability that a prompt or candidate matches a harm category. |
|  [HarmSeverity](./ai.md#harmseverity) | Harm severity levels. |
|  [ImagenAspectRatio](./ai.md#imagenaspectratio) | Aspect ratios for Imagen images.<!-- -->To specify an aspect ratio for generated images, set the <code>aspectRatio</code> property in your [ImagenGenerationConfig](./ai.imagengenerationconfig.md#imagengenerationconfig_interface)<!-- -->.<!-- -->See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) for more details and examples of the supported aspect ratios. |
|  [ImagenPersonFilterLevel](./ai.md#imagenpersonfilterlevel) | A filter level controlling whether generation of images containing people or faces is allowed.<!-- -->See the <a href="http://firebase.google.com/docs/vertex-ai/generate-images">personGeneration</a> documentation for more details. |
|  [ImagenSafetyFilterLevel](./ai.md#imagensafetyfilterlevel) | A filter level controlling how aggressively to filter sensitive content.<!-- -->Text prompts provided as inputs and images (generated or uploaded) through Imagen on Vertex AI are assessed against a list of safety filters, which include 'harmful categories' (for example, <code>violence</code>, <code>sexual</code>, <code>derogatory</code>, and <code>toxic</code>). This filter level controls how aggressively to filter out potentially harmful content from responses. See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) and the [Responsible AI and usage guidelines](https://cloud.google.com/vertex-ai/generative-ai/docs/image/responsible-ai-imagen#safety-filters) for more details. |
|  [InferenceMode](./ai.md#inferencemode) | <b><i>(Public Preview)</i></b> Determines whether inference happens on-device or in-cloud. |
|  [InferenceSource](./ai.md#inferencesource) | <b><i>(Public Preview)</i></b> Indicates whether inference happened on-device or in-cloud. |
|  [Language](./ai.md#language) | <b><i>(Public Preview)</i></b> The programming language of the code. |
|  [LanguageModelMessageContentValue](./ai.md#languagemodelmessagecontentvalue) | <b><i>(Public Preview)</i></b> Content formats that can be provided as on-device message content. |
|  [LanguageModelMessageRole](./ai.md#languagemodelmessagerole) | <b><i>(Public Preview)</i></b> Allowable roles for on-device language model usage. |
|  [LanguageModelMessageType](./ai.md#languagemodelmessagetype) | <b><i>(Public Preview)</i></b> Allowable types for on-device language model messages. |
|  [LiveResponseType](./ai.md#liveresponsetype) | <b><i>(Public Preview)</i></b> The types of responses that can be returned by [LiveSession.receive()](./ai.livesession.md#livesessionreceive)<!-- -->. This is a property on all messages that can be used for type narrowing. This property is not returned by the server, it is assigned to a server message object once it's parsed. |
|  [Modality](./ai.md#modality) | Content part modality. |
|  [Outcome](./ai.md#outcome) | <b><i>(Public Preview)</i></b> Represents the result of the code execution. |
|  [Part](./ai.md#part) | Content part - includes text, image/video, or function call/response part types. |
|  [ResponseModality](./ai.md#responsemodality) | <b><i>(Public Preview)</i></b> Generation modalities to be returned in generation responses. |
|  [Role](./ai.md#role) | Role is the producer of the content. |
|  [SchemaType](./ai.md#schematype) | Contains the list of OpenAPI data types as defined by the [OpenAPI specification](https://swagger.io/docs/specification/data-models/data-types/) |
|  [Tool](./ai.md#tool) | Defines a tool that model can call to access external knowledge. |
|  [TypedSchema](./ai.md#typedschema) | A type that includes all specific Schema types. |
|  [URLRetrievalStatus](./ai.md#urlretrievalstatus) | <b><i>(Public Preview)</i></b> The status of a URL retrieval. |

## function(app, ...)

### getAI(app, options) {:#getai_a94a413}

Returns the default [AI](./ai.ai.md#ai_interface) instance that is associated with the provided [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)<!-- -->. If no instance exists, initializes a new instance with the default settings.

<b>Signature:</b>

```typescript
export declare function getAI(app?: FirebaseApp, options?: AIOptions): AI;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) to use. |
|  options | [AIOptions](./ai.aioptions.md#aioptions_interface) | [AIOptions](./ai.aioptions.md#aioptions_interface) that configure the AI instance. |

<b>Returns:</b>

[AI](./ai.ai.md#ai_interface)

The default [AI](./ai.ai.md#ai_interface) instance for the given [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)<!-- -->.

### Example 1


```javascript
const ai = getAI(app);

```

### Example 2


```javascript
// Get an AI instance configured to use the Gemini Developer API (via Google AI).
const ai = getAI(app, { backend: new GoogleAIBackend() });

```

### Example 3


```javascript
// Get an AI instance configured to use the Vertex AI Gemini API.
const ai = getAI(app, { backend: new VertexAIBackend() });

```

## function(ai, ...)

### getGenerativeModel(ai, modelParams, requestOptions) {:#getgenerativemodel_c63f46a}

Returns a [GenerativeModel](./ai.generativemodel.md#generativemodel_class) class with methods for inference and other functionality.

<b>Signature:</b>

```typescript
export declare function getGenerativeModel(ai: AI, modelParams: ModelParams | HybridParams, requestOptions?: RequestOptions): GenerativeModel;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) |  |
|  modelParams | [ModelParams](./ai.modelparams.md#modelparams_interface) \| [HybridParams](./ai.hybridparams.md#hybridparams_interface) |  |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) |  |

<b>Returns:</b>

[GenerativeModel](./ai.generativemodel.md#generativemodel_class)

### getImagenModel(ai, modelParams, requestOptions) {:#getimagenmodel_e1f6645}

Returns an [ImagenModel](./ai.imagenmodel.md#imagenmodel_class) class with methods for using Imagen.

Only Imagen 3 models (named `imagen-3.0-*`<!-- -->) are supported.

<b>Signature:</b>

```typescript
export declare function getImagenModel(ai: AI, modelParams: ImagenModelParams, requestOptions?: RequestOptions): ImagenModel;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) | An [AI](./ai.ai.md#ai_interface) instance. |
|  modelParams | [ImagenModelParams](./ai.imagenmodelparams.md#imagenmodelparams_interface) | Parameters to use when making Imagen requests. |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) | Additional options to use when making requests. |

<b>Returns:</b>

[ImagenModel](./ai.imagenmodel.md#imagenmodel_class)

#### Exceptions

If the `apiKey` or `projectId` fields are missing in your Firebase config.

### getLiveGenerativeModel(ai, modelParams) {:#getlivegenerativemodel_f2099ac}

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Returns a [LiveGenerativeModel](./ai.livegenerativemodel.md#livegenerativemodel_class) class for real-time, bidirectional communication.

The Live API is only supported in modern browser windows and Node &gt;<!-- -->= 22.

<b>Signature:</b>

```typescript
export declare function getLiveGenerativeModel(ai: AI, modelParams: LiveModelParams): LiveGenerativeModel;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) | An [AI](./ai.ai.md#ai_interface) instance. |
|  modelParams | [LiveModelParams](./ai.livemodelparams.md#livemodelparams_interface) | Parameters to use when setting up a [LiveSession](./ai.livesession.md#livesession_class)<!-- -->. |

<b>Returns:</b>

[LiveGenerativeModel](./ai.livegenerativemodel.md#livegenerativemodel_class)

#### Exceptions

If the `apiKey` or `projectId` fields are missing in your Firebase config.

### getTemplateGenerativeModel(ai, requestOptions) {:#gettemplategenerativemodel_9476bbc}

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Returns a [TemplateGenerativeModel](./ai.templategenerativemodel.md#templategenerativemodel_class) class for executing server-side templates.

<b>Signature:</b>

```typescript
export declare function getTemplateGenerativeModel(ai: AI, requestOptions?: RequestOptions): TemplateGenerativeModel;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) | An [AI](./ai.ai.md#ai_interface) instance. |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) | Additional options to use when making requests. |

<b>Returns:</b>

[TemplateGenerativeModel](./ai.templategenerativemodel.md#templategenerativemodel_class)

### getTemplateImagenModel(ai, requestOptions) {:#gettemplateimagenmodel_9476bbc}

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Returns a [TemplateImagenModel](./ai.templateimagenmodel.md#templateimagenmodel_class) class for executing server-side Imagen templates.

<b>Signature:</b>

```typescript
export declare function getTemplateImagenModel(ai: AI, requestOptions?: RequestOptions): TemplateImagenModel;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) | An [AI](./ai.ai.md#ai_interface) instance. |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) | Additional options to use when making requests. |

<b>Returns:</b>

[TemplateImagenModel](./ai.templateimagenmodel.md#templateimagenmodel_class)

## function(liveSession, ...)

### startAudioConversation(liveSession, options) {:#startaudioconversation_01c8e7f}

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Starts a real-time, bidirectional audio conversation with the model. This helper function manages the complexities of microphone access, audio recording, playback, and interruptions.

Important: This function must be called in response to a user gesture (for example, a button click) to comply with [browser autoplay policies](https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API/Best_practices#autoplay_policy)<!-- -->.

<b>Signature:</b>

```typescript
export declare function startAudioConversation(liveSession: LiveSession, options?: StartAudioConversationOptions): Promise<AudioConversationController>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  liveSession | [LiveSession](./ai.livesession.md#livesession_class) | An active [LiveSession](./ai.livesession.md#livesession_class) instance. |
|  options | [StartAudioConversationOptions](./ai.startaudioconversationoptions.md#startaudioconversationoptions_interface) | Configuration options for the audio conversation. |

<b>Returns:</b>

Promise&lt;[AudioConversationController](./ai.audioconversationcontroller.md#audioconversationcontroller_interface)<!-- -->&gt;

A `Promise` that resolves with an [AudioConversationController](./ai.audioconversationcontroller.md#audioconversationcontroller_interface)<!-- -->.

#### Exceptions

`AIError` if the environment does not support required Web APIs (`UNSUPPORTED`<!-- -->), if a conversation is already active (`REQUEST_ERROR`<!-- -->), the session is closed (`SESSION_CLOSED`<!-- -->), or if an unexpected initialization error occurs (`ERROR`<!-- -->).

`DOMException` Thrown by `navigator.mediaDevices.getUserMedia()` if issues occur with microphone access, such as permissions being denied (`NotAllowedError`<!-- -->) or no compatible hardware being found (`NotFoundError`<!-- -->). See the [MDN documentation](https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia#exceptions) for a full list of exceptions.

### Example


```javascript
const liveSession = await model.connect();
let conversationController;

// This function must be called from within a click handler.
async function startConversation() {
  try {
    conversationController = await startAudioConversation(liveSession);
  } catch (e) {
    // Handle AI-specific errors
    if (e instanceof AIError) {
      console.error("AI Error:", e.message);
    }
    // Handle microphone permission and hardware errors
    else if (e instanceof DOMException) {
      console.error("Microphone Error:", e.message);
    }
    // Handle other unexpected errors
    else {
      console.error("An unexpected error occurred:", e);
    }
  }
}

// Later, to stop the conversation:
// if (conversationController) {
//   await conversationController.stop();
// }

```

## AIErrorCode

Standardized error codes that [AIError](./ai.aierror.md#aierror_class) can have.

<b>Signature:</b>

```typescript
AIErrorCode: {
    readonly ERROR: "error";
    readonly REQUEST_ERROR: "request-error";
    readonly RESPONSE_ERROR: "response-error";
    readonly FETCH_ERROR: "fetch-error";
    readonly SESSION_CLOSED: "session-closed";
    readonly INVALID_CONTENT: "invalid-content";
    readonly API_NOT_ENABLED: "api-not-enabled";
    readonly INVALID_SCHEMA: "invalid-schema";
    readonly NO_API_KEY: "no-api-key";
    readonly NO_APP_ID: "no-app-id";
    readonly NO_MODEL: "no-model";
    readonly NO_PROJECT_ID: "no-project-id";
    readonly PARSE_FAILED: "parse-failed";
    readonly UNSUPPORTED: "unsupported";
}
```

## BackendType

An enum-like object containing constants that represent the supported backends for the Firebase AI SDK. This determines which backend service (Vertex AI Gemini API or Gemini Developer API) the SDK will communicate with.

These values are assigned to the `backendType` property within the specific backend configuration objects ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class) or [VertexAIBackend](./ai.vertexaibackend.md#vertexaibackend_class)<!-- -->) to identify which service to target.

<b>Signature:</b>

```typescript
BackendType: {
    readonly VERTEX_AI: "VERTEX_AI";
    readonly GOOGLE_AI: "GOOGLE_AI";
}
```

## BlockReason

Reason that a prompt was blocked.

<b>Signature:</b>

```typescript
BlockReason: {
    readonly SAFETY: "SAFETY";
    readonly OTHER: "OTHER";
    readonly BLOCKLIST: "BLOCKLIST";
    readonly PROHIBITED_CONTENT: "PROHIBITED_CONTENT";
}
```

## FinishReason

Reason that a candidate finished.

<b>Signature:</b>

```typescript
FinishReason: {
    readonly STOP: "STOP";
    readonly MAX_TOKENS: "MAX_TOKENS";
    readonly SAFETY: "SAFETY";
    readonly RECITATION: "RECITATION";
    readonly OTHER: "OTHER";
    readonly BLOCKLIST: "BLOCKLIST";
    readonly PROHIBITED_CONTENT: "PROHIBITED_CONTENT";
    readonly SPII: "SPII";
    readonly MALFORMED_FUNCTION_CALL: "MALFORMED_FUNCTION_CALL";
}
```

## FunctionCallingMode


<b>Signature:</b>

```typescript
FunctionCallingMode: {
    readonly AUTO: "AUTO";
    readonly ANY: "ANY";
    readonly NONE: "NONE";
}
```

## HarmBlockMethod

This property is not supported in the Gemini Developer API ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class)<!-- -->).

<b>Signature:</b>

```typescript
HarmBlockMethod: {
    readonly SEVERITY: "SEVERITY";
    readonly PROBABILITY: "PROBABILITY";
}
```

## HarmBlockThreshold

Threshold above which a prompt or candidate will be blocked.

<b>Signature:</b>

```typescript
HarmBlockThreshold: {
    readonly BLOCK_LOW_AND_ABOVE: "BLOCK_LOW_AND_ABOVE";
    readonly BLOCK_MEDIUM_AND_ABOVE: "BLOCK_MEDIUM_AND_ABOVE";
    readonly BLOCK_ONLY_HIGH: "BLOCK_ONLY_HIGH";
    readonly BLOCK_NONE: "BLOCK_NONE";
    readonly OFF: "OFF";
}
```

## HarmCategory

Harm categories that would cause prompts or candidates to be blocked.

<b>Signature:</b>

```typescript
HarmCategory: {
    readonly HARM_CATEGORY_HATE_SPEECH: "HARM_CATEGORY_HATE_SPEECH";
    readonly HARM_CATEGORY_SEXUALLY_EXPLICIT: "HARM_CATEGORY_SEXUALLY_EXPLICIT";
    readonly HARM_CATEGORY_HARASSMENT: "HARM_CATEGORY_HARASSMENT";
    readonly HARM_CATEGORY_DANGEROUS_CONTENT: "HARM_CATEGORY_DANGEROUS_CONTENT";
}
```

## HarmProbability

Probability that a prompt or candidate matches a harm category.

<b>Signature:</b>

```typescript
HarmProbability: {
    readonly NEGLIGIBLE: "NEGLIGIBLE";
    readonly LOW: "LOW";
    readonly MEDIUM: "MEDIUM";
    readonly HIGH: "HIGH";
}
```

## HarmSeverity

Harm severity levels.

<b>Signature:</b>

```typescript
HarmSeverity: {
    readonly HARM_SEVERITY_NEGLIGIBLE: "HARM_SEVERITY_NEGLIGIBLE";
    readonly HARM_SEVERITY_LOW: "HARM_SEVERITY_LOW";
    readonly HARM_SEVERITY_MEDIUM: "HARM_SEVERITY_MEDIUM";
    readonly HARM_SEVERITY_HIGH: "HARM_SEVERITY_HIGH";
    readonly HARM_SEVERITY_UNSUPPORTED: "HARM_SEVERITY_UNSUPPORTED";
}
```

## ImagenAspectRatio

Aspect ratios for Imagen images.

To specify an aspect ratio for generated images, set the `aspectRatio` property in your [ImagenGenerationConfig](./ai.imagengenerationconfig.md#imagengenerationconfig_interface)<!-- -->.

See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) for more details and examples of the supported aspect ratios.

<b>Signature:</b>

```typescript
ImagenAspectRatio: {
    readonly SQUARE: "1:1";
    readonly LANDSCAPE_3x4: "3:4";
    readonly PORTRAIT_4x3: "4:3";
    readonly LANDSCAPE_16x9: "16:9";
    readonly PORTRAIT_9x16: "9:16";
}
```

## ImagenPersonFilterLevel

A filter level controlling whether generation of images containing people or faces is allowed.

See the <a href="http://firebase.google.com/docs/vertex-ai/generate-images">personGeneration</a> documentation for more details.

<b>Signature:</b>

```typescript
ImagenPersonFilterLevel: {
    readonly BLOCK_ALL: "dont_allow";
    readonly ALLOW_ADULT: "allow_adult";
    readonly ALLOW_ALL: "allow_all";
}
```

## ImagenSafetyFilterLevel

A filter level controlling how aggressively to filter sensitive content.

Text prompts provided as inputs and images (generated or uploaded) through Imagen on Vertex AI are assessed against a list of safety filters, which include 'harmful categories' (for example, `violence`<!-- -->, `sexual`<!-- -->, `derogatory`<!-- -->, and `toxic`<!-- -->). This filter level controls how aggressively to filter out potentially harmful content from responses. See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) and the [Responsible AI and usage guidelines](https://cloud.google.com/vertex-ai/generative-ai/docs/image/responsible-ai-imagen#safety-filters) for more details.

<b>Signature:</b>

```typescript
ImagenSafetyFilterLevel: {
    readonly BLOCK_LOW_AND_ABOVE: "block_low_and_above";
    readonly BLOCK_MEDIUM_AND_ABOVE: "block_medium_and_above";
    readonly BLOCK_ONLY_HIGH: "block_only_high";
    readonly BLOCK_NONE: "block_none";
}
```

## InferenceMode

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Determines whether inference happens on-device or in-cloud.

<b>PREFER\_ON\_DEVICE:</b> Attempt to make inference calls using an on-device model. If on-device inference is not available, the SDK will fall back to using a cloud-hosted model. <br/> <b>ONLY\_ON\_DEVICE:</b> Only attempt to make inference calls using an on-device model. The SDK will not fall back to a cloud-hosted model. If on-device inference is not available, inference methods will throw. <br/> <b>ONLY\_IN\_CLOUD:</b> Only attempt to make inference calls using a cloud-hosted model. The SDK will not fall back to an on-device model. <br/> <b>PREFER\_IN\_CLOUD:</b> Attempt to make inference calls to a cloud-hosted model. If not available, the SDK will fall back to an on-device model.

<b>Signature:</b>

```typescript
InferenceMode: {
    readonly PREFER_ON_DEVICE: "prefer_on_device";
    readonly ONLY_ON_DEVICE: "only_on_device";
    readonly ONLY_IN_CLOUD: "only_in_cloud";
    readonly PREFER_IN_CLOUD: "prefer_in_cloud";
}
```

## InferenceSource

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Indicates whether inference happened on-device or in-cloud.

<b>Signature:</b>

```typescript
InferenceSource: {
    readonly ON_DEVICE: "on_device";
    readonly IN_CLOUD: "in_cloud";
}
```

## Language

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

The programming language of the code.

<b>Signature:</b>

```typescript
Language: {
    UNSPECIFIED: string;
    PYTHON: string;
}
```

## LiveResponseType

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

The types of responses that can be returned by [LiveSession.receive()](./ai.livesession.md#livesessionreceive)<!-- -->.

<b>Signature:</b>

```typescript
LiveResponseType: {
    SERVER_CONTENT: string;
    TOOL_CALL: string;
    TOOL_CALL_CANCELLATION: string;
}
```

## Modality

Content part modality.

<b>Signature:</b>

```typescript
Modality: {
    readonly MODALITY_UNSPECIFIED: "MODALITY_UNSPECIFIED";
    readonly TEXT: "TEXT";
    readonly IMAGE: "IMAGE";
    readonly VIDEO: "VIDEO";
    readonly AUDIO: "AUDIO";
    readonly DOCUMENT: "DOCUMENT";
}
```

## Outcome

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Represents the result of the code execution.

<b>Signature:</b>

```typescript
Outcome: {
    UNSPECIFIED: string;
    OK: string;
    FAILED: string;
    DEADLINE_EXCEEDED: string;
}
```

## POSSIBLE\_ROLES

Possible roles.

<b>Signature:</b>

```typescript
POSSIBLE_ROLES: readonly ["user", "model", "function", "system"]
```

## ResponseModality

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Generation modalities to be returned in generation responses.

<b>Signature:</b>

```typescript
ResponseModality: {
    readonly TEXT: "TEXT";
    readonly IMAGE: "IMAGE";
    readonly AUDIO: "AUDIO";
}
```

## SchemaType

Contains the list of OpenAPI data types as defined by the [OpenAPI specification](https://swagger.io/docs/specification/data-models/data-types/)

<b>Signature:</b>

```typescript
SchemaType: {
    readonly STRING: "string";
    readonly NUMBER: "number";
    readonly INTEGER: "integer";
    readonly BOOLEAN: "boolean";
    readonly ARRAY: "array";
    readonly OBJECT: "object";
}
```

## URLRetrievalStatus

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

The status of a URL retrieval.

<b>URL\_RETRIEVAL\_STATUS\_UNSPECIFIED:</b> Unspecified retrieval status. <br/> <b>URL\_RETRIEVAL\_STATUS\_SUCCESS:</b> The URL retrieval was successful. <br/> <b>URL\_RETRIEVAL\_STATUS\_ERROR:</b> The URL retrieval failed. <br/> <b>URL\_RETRIEVAL\_STATUS\_PAYWALL:</b> The URL retrieval failed because the content is behind a paywall. <br/> <b>URL\_RETRIEVAL\_STATUS\_UNSAFE:</b> The URL retrieval failed because the content is unsafe. <br/>

<b>Signature:</b>

```typescript
URLRetrievalStatus: {
    URL_RETRIEVAL_STATUS_UNSPECIFIED: string;
    URL_RETRIEVAL_STATUS_SUCCESS: string;
    URL_RETRIEVAL_STATUS_ERROR: string;
    URL_RETRIEVAL_STATUS_PAYWALL: string;
    URL_RETRIEVAL_STATUS_UNSAFE: string;
}
```

## AIErrorCode

Standardized error codes that [AIError](./ai.aierror.md#aierror_class) can have.

<b>Signature:</b>

```typescript
export type AIErrorCode = (typeof AIErrorCode)[keyof typeof AIErrorCode];
```

## BackendType

Type alias representing valid backend types. It can be either `'VERTEX_AI'` or `'GOOGLE_AI'`<!-- -->.

<b>Signature:</b>

```typescript
export type BackendType = (typeof BackendType)[keyof typeof BackendType];
```

## BlockReason

Reason that a prompt was blocked.

<b>Signature:</b>

```typescript
export type BlockReason = (typeof BlockReason)[keyof typeof BlockReason];
```

## FinishReason

Reason that a candidate finished.

<b>Signature:</b>

```typescript
export type FinishReason = (typeof FinishReason)[keyof typeof FinishReason];
```

## FunctionCallingMode


<b>Signature:</b>

```typescript
export type FunctionCallingMode = (typeof FunctionCallingMode)[keyof typeof FunctionCallingMode];
```

## HarmBlockMethod

This property is not supported in the Gemini Developer API ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class)<!-- -->).

<b>Signature:</b>

```typescript
export type HarmBlockMethod = (typeof HarmBlockMethod)[keyof typeof HarmBlockMethod];
```

## HarmBlockThreshold

Threshold above which a prompt or candidate will be blocked.

<b>Signature:</b>

```typescript
export type HarmBlockThreshold = (typeof HarmBlockThreshold)[keyof typeof HarmBlockThreshold];
```

## HarmCategory

Harm categories that would cause prompts or candidates to be blocked.

<b>Signature:</b>

```typescript
export type HarmCategory = (typeof HarmCategory)[keyof typeof HarmCategory];
```

## HarmProbability

Probability that a prompt or candidate matches a harm category.

<b>Signature:</b>

```typescript
export type HarmProbability = (typeof HarmProbability)[keyof typeof HarmProbability];
```

## HarmSeverity

Harm severity levels.

<b>Signature:</b>

```typescript
export type HarmSeverity = (typeof HarmSeverity)[keyof typeof HarmSeverity];
```

## ImagenAspectRatio

Aspect ratios for Imagen images.

To specify an aspect ratio for generated images, set the `aspectRatio` property in your [ImagenGenerationConfig](./ai.imagengenerationconfig.md#imagengenerationconfig_interface)<!-- -->.

See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) for more details and examples of the supported aspect ratios.

<b>Signature:</b>

```typescript
export type ImagenAspectRatio = (typeof ImagenAspectRatio)[keyof typeof ImagenAspectRatio];
```

## ImagenPersonFilterLevel

A filter level controlling whether generation of images containing people or faces is allowed.

See the <a href="http://firebase.google.com/docs/vertex-ai/generate-images">personGeneration</a> documentation for more details.

<b>Signature:</b>

```typescript
export type ImagenPersonFilterLevel = (typeof ImagenPersonFilterLevel)[keyof typeof ImagenPersonFilterLevel];
```

## ImagenSafetyFilterLevel

A filter level controlling how aggressively to filter sensitive content.

Text prompts provided as inputs and images (generated or uploaded) through Imagen on Vertex AI are assessed against a list of safety filters, which include 'harmful categories' (for example, `violence`<!-- -->, `sexual`<!-- -->, `derogatory`<!-- -->, and `toxic`<!-- -->). This filter level controls how aggressively to filter out potentially harmful content from responses. See the [documentation](http://firebase.google.com/docs/vertex-ai/generate-images) and the [Responsible AI and usage guidelines](https://cloud.google.com/vertex-ai/generative-ai/docs/image/responsible-ai-imagen#safety-filters) for more details.

<b>Signature:</b>

```typescript
export type ImagenSafetyFilterLevel = (typeof ImagenSafetyFilterLevel)[keyof typeof ImagenSafetyFilterLevel];
```

## InferenceMode

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Determines whether inference happens on-device or in-cloud.

<b>Signature:</b>

```typescript
export type InferenceMode = (typeof InferenceMode)[keyof typeof InferenceMode];
```

## InferenceSource

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Indicates whether inference happened on-device or in-cloud.

<b>Signature:</b>

```typescript
export type InferenceSource = (typeof InferenceSource)[keyof typeof InferenceSource];
```

## Language

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

The programming language of the code.

<b>Signature:</b>

```typescript
export type Language = (typeof Language)[keyof typeof Language];
```

## LanguageModelMessageContentValue

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Content formats that can be provided as on-device message content.

<b>Signature:</b>

```typescript
export type LanguageModelMessageContentValue = ImageBitmapSource | AudioBuffer | BufferSource | string;
```

## LanguageModelMessageRole

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Allowable roles for on-device language model usage.

<b>Signature:</b>

```typescript
export type LanguageModelMessageRole = 'system' | 'user' | 'assistant';
```

## LanguageModelMessageType

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Allowable types for on-device language model messages.

<b>Signature:</b>

```typescript
export type LanguageModelMessageType = 'text' | 'image' | 'audio';
```

## LiveResponseType

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

The types of responses that can be returned by [LiveSession.receive()](./ai.livesession.md#livesessionreceive)<!-- -->. This is a property on all messages that can be used for type narrowing. This property is not returned by the server, it is assigned to a server message object once it's parsed.

<b>Signature:</b>

```typescript
export type LiveResponseType = (typeof LiveResponseType)[keyof typeof LiveResponseType];
```

## Modality

Content part modality.

<b>Signature:</b>

```typescript
export type Modality = (typeof Modality)[keyof typeof Modality];
```

## Outcome

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Represents the result of the code execution.

<b>Signature:</b>

```typescript
export type Outcome = (typeof Outcome)[keyof typeof Outcome];
```

## Part

Content part - includes text, image/video, or function call/response part types.

<b>Signature:</b>

```typescript
export type Part = TextPart | InlineDataPart | FunctionCallPart | FunctionResponsePart | FileDataPart | ExecutableCodePart | CodeExecutionResultPart;
```

## ResponseModality

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Generation modalities to be returned in generation responses.

<b>Signature:</b>

```typescript
export type ResponseModality = (typeof ResponseModality)[keyof typeof ResponseModality];
```

## Role

Role is the producer of the content.

<b>Signature:</b>

```typescript
export type Role = (typeof POSSIBLE_ROLES)[number];
```

## SchemaType

Contains the list of OpenAPI data types as defined by the [OpenAPI specification](https://swagger.io/docs/specification/data-models/data-types/)

<b>Signature:</b>

```typescript
export type SchemaType = (typeof SchemaType)[keyof typeof SchemaType];
```

## Tool

Defines a tool that model can call to access external knowledge.

<b>Signature:</b>

```typescript
export type Tool = FunctionDeclarationsTool | GoogleSearchTool | CodeExecutionTool | URLContextTool;
```

## TypedSchema

A type that includes all specific Schema types.

<b>Signature:</b>

```typescript
export type TypedSchema = IntegerSchema | NumberSchema | StringSchema | BooleanSchema | ObjectSchema | ArraySchema | AnyOfSchema;
```

## URLRetrievalStatus

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

The status of a URL retrieval.

<b>URL\_RETRIEVAL\_STATUS\_UNSPECIFIED:</b> Unspecified retrieval status. <br/> <b>URL\_RETRIEVAL\_STATUS\_SUCCESS:</b> The URL retrieval was successful. <br/> <b>URL\_RETRIEVAL\_STATUS\_ERROR:</b> The URL retrieval failed. <br/> <b>URL\_RETRIEVAL\_STATUS\_PAYWALL:</b> The URL retrieval failed because the content is behind a paywall. <br/> <b>URL\_RETRIEVAL\_STATUS\_UNSAFE:</b> The URL retrieval failed because the content is unsafe. <br/>

<b>Signature:</b>

```typescript
export type URLRetrievalStatus = (typeof URLRetrievalStatus)[keyof typeof URLRetrievalStatus];
```
