Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Schema class
Parent class encompassing all Schema types, with static methods that allow building specific Schema types. This class can be converted with `JSON.stringify()` into a JSON string accepted by Vertex AI REST endpoints. (This string conversion is automatically done when calling SDK methods.)

<b>Signature:</b>

```typescript
export declare abstract class Schema implements SchemaInterface 
```
<b>Implements:</b> [SchemaInterface](./ai.schemainterface.md#schemainterface_interface)

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(schemaParams)](./ai.schema.md#schemaconstructor) |  | Constructs a new instance of the <code>Schema</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [description](./ai.schema.md#schemadescription) |  | string | Optional. The description of the property. |
|  [example](./ai.schema.md#schemaexample) |  | unknown | Optional. The example of the property. |
|  [format](./ai.schema.md#schemaformat) |  | string | Optional. The format of the property. Supported formats:<br/> <ul> <li>for NUMBER type: "float", "double"</li> <li>for INTEGER type: "int32", "int64"</li> <li>for STRING type: "email", "byte", etc</li> </ul> |
|  [items](./ai.schema.md#schemaitems) |  | [SchemaInterface](./ai.schemainterface.md#schemainterface_interface) | Optional. The items of the property. |
|  [maxItems](./ai.schema.md#schemamaxitems) |  | number | The maximum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) <code>array</code>. |
|  [minItems](./ai.schema.md#schemaminitems) |  | number | The minimum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) <code>array</code>. |
|  [nullable](./ai.schema.md#schemanullable) |  | boolean | Optional. Whether the property is nullable. Defaults to false. |
|  [type](./ai.schema.md#schematype) |  | [SchemaType](./ai.md#schematype) | Optional. The type of the property. This can only be undefined when using <code>anyOf</code> schemas, which do not have an explicit type in the [OpenAPI specification](https://swagger.io/docs/specification/v3_0/data-models/data-types/#any-type)<!-- -->. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [anyOf(anyOfParams)](./ai.schema.md#schemaanyof) | <code>static</code> |  |
|  [array(arrayParams)](./ai.schema.md#schemaarray) | <code>static</code> |  |
|  [boolean(booleanParams)](./ai.schema.md#schemaboolean) | <code>static</code> |  |
|  [enumString(stringParams)](./ai.schema.md#schemaenumstring) | <code>static</code> |  |
|  [integer(integerParams)](./ai.schema.md#schemainteger) | <code>static</code> |  |
|  [number(numberParams)](./ai.schema.md#schemanumber) | <code>static</code> |  |
|  [object(objectParams)](./ai.schema.md#schemaobject) | <code>static</code> |  |
|  [string(stringParams)](./ai.schema.md#schemastring) | <code>static</code> |  |

## Schema.(constructor)

Constructs a new instance of the `Schema` class

<b>Signature:</b>

```typescript
constructor(schemaParams: SchemaInterface);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  schemaParams | [SchemaInterface](./ai.schemainterface.md#schemainterface_interface) |  |

## Schema.description

Optional. The description of the property.

<b>Signature:</b>

```typescript
description?: string;
```

## Schema.example

Optional. The example of the property.

<b>Signature:</b>

```typescript
example?: unknown;
```

## Schema.format

Optional. The format of the property. Supported formats:<br/> <ul> <li>for NUMBER type: "float", "double"</li> <li>for INTEGER type: "int32", "int64"</li> <li>for STRING type: "email", "byte", etc</li> </ul>

<b>Signature:</b>

```typescript
format?: string;
```

## Schema.items

Optional. The items of the property.

<b>Signature:</b>

```typescript
items?: SchemaInterface;
```

## Schema.maxItems

The maximum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) `array`<!-- -->.

<b>Signature:</b>

```typescript
maxItems?: number;
```

## Schema.minItems

The minimum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) `array`<!-- -->.

<b>Signature:</b>

```typescript
minItems?: number;
```

## Schema.nullable

Optional. Whether the property is nullable. Defaults to false.

<b>Signature:</b>

```typescript
nullable: boolean;
```

## Schema.type

Optional. The type of the property. This can only be undefined when using `anyOf` schemas, which do not have an explicit type in the [OpenAPI specification](https://swagger.io/docs/specification/v3_0/data-models/data-types/#any-type)<!-- -->.

<b>Signature:</b>

```typescript
type?: SchemaType;
```

## Schema.anyOf()

<b>Signature:</b>

```typescript
static anyOf(anyOfParams: SchemaParams & {
        anyOf: TypedSchema[];
    }): AnyOfSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  anyOfParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) &amp; { anyOf: [TypedSchema](./ai.md#typedschema)<!-- -->\[\]; } |  |

<b>Returns:</b>

[AnyOfSchema](./ai.anyofschema.md#anyofschema_class)

## Schema.array()

<b>Signature:</b>

```typescript
static array(arrayParams: SchemaParams & {
        items: Schema;
    }): ArraySchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  arrayParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) &amp; { items: [Schema](./ai.schema.md#schema_class)<!-- -->; } |  |

<b>Returns:</b>

[ArraySchema](./ai.arrayschema.md#arrayschema_class)

## Schema.boolean()

<b>Signature:</b>

```typescript
static boolean(booleanParams?: SchemaParams): BooleanSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  booleanParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) |  |

<b>Returns:</b>

[BooleanSchema](./ai.booleanschema.md#booleanschema_class)

## Schema.enumString()

<b>Signature:</b>

```typescript
static enumString(stringParams: SchemaParams & {
        enum: string[];
    }): StringSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  stringParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) &amp; { enum: string\[\]; } |  |

<b>Returns:</b>

[StringSchema](./ai.stringschema.md#stringschema_class)

## Schema.integer()

<b>Signature:</b>

```typescript
static integer(integerParams?: SchemaParams): IntegerSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  integerParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) |  |

<b>Returns:</b>

[IntegerSchema](./ai.integerschema.md#integerschema_class)

## Schema.number()

<b>Signature:</b>

```typescript
static number(numberParams?: SchemaParams): NumberSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  numberParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) |  |

<b>Returns:</b>

[NumberSchema](./ai.numberschema.md#numberschema_class)

## Schema.object()

<b>Signature:</b>

```typescript
static object(objectParams: SchemaParams & {
        properties: {
            [k: string]: Schema;
        };
        optionalProperties?: string[];
    }): ObjectSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  objectParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) &amp; { properties: { \[k: string\]: [Schema](./ai.schema.md#schema_class)<!-- -->; }; optionalProperties?: string\[\]; } |  |

<b>Returns:</b>

[ObjectSchema](./ai.objectschema.md#objectschema_class)

## Schema.string()

<b>Signature:</b>

```typescript
static string(stringParams?: SchemaParams): StringSchema;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  stringParams | [SchemaParams](./ai.schemaparams.md#schemaparams_interface) |  |

<b>Returns:</b>

[StringSchema](./ai.stringschema.md#stringschema_class)

