Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# SchemaShared interface
Basic [Schema](./ai.schema.md#schema_class) properties shared across several Schema-related types.

<b>Signature:</b>

```typescript
export interface SchemaShared<T> 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [anyOf](./ai.schemashared.md#schemasharedanyof) | T\[\] | An array of [Schema](./ai.schema.md#schema_class)<!-- -->. The generated data must be valid against any of the schemas listed in this array. This allows specifying multiple possible structures or types for a single field. |
|  [description](./ai.schemashared.md#schemashareddescription) | string | Optional. The description of the property. |
|  [enum](./ai.schemashared.md#schemasharedenum) | string\[\] | Optional. The enum of the property. |
|  [example](./ai.schemashared.md#schemasharedexample) | unknown | Optional. The example of the property. |
|  [format](./ai.schemashared.md#schemasharedformat) | string | Optional. The format of the property. When using the Gemini Developer API ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class)<!-- -->), this must be either <code>'enum'</code> or <code>'date-time'</code>, otherwise requests will fail. |
|  [items](./ai.schemashared.md#schemashareditems) | T | Optional. The items of the property. |
|  [maximum](./ai.schemashared.md#schemasharedmaximum) | number | The maximum value of a numeric type. |
|  [maxItems](./ai.schemashared.md#schemasharedmaxitems) | number | The maximum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) <code>array</code>. |
|  [minimum](./ai.schemashared.md#schemasharedminimum) | number | The minimum value of a numeric type. |
|  [minItems](./ai.schemashared.md#schemasharedminitems) | number | The minimum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) <code>array</code>. |
|  [nullable](./ai.schemashared.md#schemasharednullable) | boolean | Optional. Whether the property is nullable. |
|  [properties](./ai.schemashared.md#schemasharedproperties) | { \[k: string\]: T; } | Optional. Map of <code>Schema</code> objects. |
|  [propertyOrdering](./ai.schemashared.md#schemasharedpropertyordering) | string\[\] | A hint suggesting the order in which the keys should appear in the generated JSON string. |
|  [title](./ai.schemashared.md#schemasharedtitle) | string | The title of the property. This helps document the schema's purpose but does not typically constrain the generated value. It can subtly guide the model by clarifying the intent of a field. |

## SchemaShared.anyOf

An array of [Schema](./ai.schema.md#schema_class)<!-- -->. The generated data must be valid against any of the schemas listed in this array. This allows specifying multiple possible structures or types for a single field.

<b>Signature:</b>

```typescript
anyOf?: T[];
```

## SchemaShared.description

Optional. The description of the property.

<b>Signature:</b>

```typescript
description?: string;
```

## SchemaShared.enum

Optional. The enum of the property.

<b>Signature:</b>

```typescript
enum?: string[];
```

## SchemaShared.example

Optional. The example of the property.

<b>Signature:</b>

```typescript
example?: unknown;
```

## SchemaShared.format

Optional. The format of the property. When using the Gemini Developer API ([GoogleAIBackend](./ai.googleaibackend.md#googleaibackend_class)<!-- -->), this must be either `'enum'` or `'date-time'`<!-- -->, otherwise requests will fail.

<b>Signature:</b>

```typescript
format?: string;
```

## SchemaShared.items

Optional. The items of the property.

<b>Signature:</b>

```typescript
items?: T;
```

## SchemaShared.maximum

The maximum value of a numeric type.

<b>Signature:</b>

```typescript
maximum?: number;
```

## SchemaShared.maxItems

The maximum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) `array`<!-- -->.

<b>Signature:</b>

```typescript
maxItems?: number;
```

## SchemaShared.minimum

The minimum value of a numeric type.

<b>Signature:</b>

```typescript
minimum?: number;
```

## SchemaShared.minItems

The minimum number of items (elements) in a schema of [SchemaType](./ai.md#schematype) `array`<!-- -->.

<b>Signature:</b>

```typescript
minItems?: number;
```

## SchemaShared.nullable

Optional. Whether the property is nullable.

<b>Signature:</b>

```typescript
nullable?: boolean;
```

## SchemaShared.properties

Optional. Map of `Schema` objects.

<b>Signature:</b>

```typescript
properties?: {
        [k: string]: T;
    };
```

## SchemaShared.propertyOrdering

A hint suggesting the order in which the keys should appear in the generated JSON string.

<b>Signature:</b>

```typescript
propertyOrdering?: string[];
```

## SchemaShared.title

The title of the property. This helps document the schema's purpose but does not typically constrain the generated value. It can subtly guide the model by clarifying the intent of a field.

<b>Signature:</b>

```typescript
title?: string;
```
