Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# SearchEntrypoint interface
Google search entry point.

<b>Signature:</b>

```typescript
export interface SearchEntrypoint 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [renderedContent](./ai.searchentrypoint.md#searchentrypointrenderedcontent) | string | HTML/CSS snippet that must be embedded in a web page. The snippet is designed to avoid undesired interaction with the rest of the page's CSS.<!-- -->To ensure proper rendering and prevent CSS conflicts, it is recommended to encapsulate this <code>renderedContent</code> within a shadow DOM when embedding it into a webpage. See [MDN: Using shadow DOM](https://developer.mozilla.org/en-US/docs/Web/API/Web_components/Using_shadow_DOM)<!-- -->. |

## SearchEntrypoint.renderedContent

HTML/CSS snippet that must be embedded in a web page. The snippet is designed to avoid undesired interaction with the rest of the page's CSS.

To ensure proper rendering and prevent CSS conflicts, it is recommended to encapsulate this `renderedContent` within a shadow DOM when embedding it into a webpage. See [MDN: Using shadow DOM](https://developer.mozilla.org/en-US/docs/Web/API/Web_components/Using_shadow_DOM)<!-- -->.

<b>Signature:</b>

```typescript
renderedContent?: string;
```

### Example


```javascript
const container = document.createElement('div');
document.body.appendChild(container);
container.attachShadow({ mode: 'open' }).innerHTML = renderedContent;

```

