Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Segment interface
Represents a specific segment within a [Content](./ai.content.md#content_interface) object, often used to pinpoint the exact location of text or data that grounding information refers to.

<b>Signature:</b>

```typescript
export interface Segment 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [endIndex](./ai.segment.md#segmentendindex) | number | The zero-based end index of the segment within the specified <code>Part</code>, measured in UTF-8 bytes. This offset is exclusive, meaning the character at this index is not included in the segment. |
|  [partIndex](./ai.segment.md#segmentpartindex) | number | The zero-based index of the [Part](./ai.md#part) object within the <code>parts</code> array of its parent [Content](./ai.content.md#content_interface) object. This identifies which part of the content the segment belongs to. |
|  [startIndex](./ai.segment.md#segmentstartindex) | number | The zero-based start index of the segment within the specified <code>Part</code>, measured in UTF-8 bytes. This offset is inclusive, starting from 0 at the beginning of the part's content (e.g., <code>Part.text</code>). |
|  [text](./ai.segment.md#segmenttext) | string | The text corresponding to the segment from the response. |

## Segment.endIndex

The zero-based end index of the segment within the specified `Part`<!-- -->, measured in UTF-8 bytes. This offset is exclusive, meaning the character at this index is not included in the segment.

<b>Signature:</b>

```typescript
endIndex: number;
```

## Segment.partIndex

The zero-based index of the [Part](./ai.md#part) object within the `parts` array of its parent [Content](./ai.content.md#content_interface) object. This identifies which part of the content the segment belongs to.

<b>Signature:</b>

```typescript
partIndex: number;
```

## Segment.startIndex

The zero-based start index of the segment within the specified `Part`<!-- -->, measured in UTF-8 bytes. This offset is inclusive, starting from 0 at the beginning of the part's content (e.g., `Part.text`<!-- -->).

<b>Signature:</b>

```typescript
startIndex: number;
```

## Segment.text

The text corresponding to the segment from the response.

<b>Signature:</b>

```typescript
text: string;
```
