Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# TemplateGenerativeModel class
> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

[GenerativeModel](./ai.generativemodel.md#generativemodel_class) APIs that execute on a server-side template.

This class should only be instantiated with [getTemplateGenerativeModel()](./ai.md#gettemplategenerativemodel_9476bbc)<!-- -->.

<b>Signature:</b>

```typescript
export declare class TemplateGenerativeModel 
```

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(ai, requestOptions)](./ai.templategenerativemodel.md#templategenerativemodelconstructor) |  | <b><i>(Public Preview)</i></b>  Constructs a new instance of the <code>TemplateGenerativeModel</code> class |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [requestOptions](./ai.templategenerativemodel.md#templategenerativemodelrequestoptions) |  | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) | <b><i>(Public Preview)</i></b> Additional options to use when making requests. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [generateContent(templateId, templateVariables)](./ai.templategenerativemodel.md#templategenerativemodelgeneratecontent) |  | <b><i>(Public Preview)</i></b> Makes a single non-streaming call to the model and returns an object containing a single [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface)<!-- -->. |
|  [generateContentStream(templateId, templateVariables)](./ai.templategenerativemodel.md#templategenerativemodelgeneratecontentstream) |  | <b><i>(Public Preview)</i></b> Makes a single streaming call to the model and returns an object containing an iterable stream that iterates over all chunks in the streaming response as well as a promise that returns the final aggregated response. |

## TemplateGenerativeModel.(constructor)

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

 Constructs a new instance of the `TemplateGenerativeModel` class

<b>Signature:</b>

```typescript
constructor(ai: AI, requestOptions?: RequestOptions);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  ai | [AI](./ai.ai.md#ai_interface) |  |
|  requestOptions | [RequestOptions](./ai.requestoptions.md#requestoptions_interface) |  |

## TemplateGenerativeModel.requestOptions

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Additional options to use when making requests.

<b>Signature:</b>

```typescript
requestOptions?: RequestOptions;
```

## TemplateGenerativeModel.generateContent()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Makes a single non-streaming call to the model and returns an object containing a single [GenerateContentResponse](./ai.generatecontentresponse.md#generatecontentresponse_interface)<!-- -->.

<b>Signature:</b>

```typescript
generateContent(templateId: string, templateVariables: object): Promise<GenerateContentResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  templateId | string | The ID of the server-side template to execute. |
|  templateVariables | object | A key-value map of variables to populate the template with. |

<b>Returns:</b>

Promise&lt;[GenerateContentResult](./ai.generatecontentresult.md#generatecontentresult_interface)<!-- -->&gt;

## TemplateGenerativeModel.generateContentStream()

> This API is provided as a preview for developers and may change based on feedback that we receive. Do not use this API in a production environment.
> 

Makes a single streaming call to the model and returns an object containing an iterable stream that iterates over all chunks in the streaming response as well as a promise that returns the final aggregated response.

<b>Signature:</b>

```typescript
generateContentStream(templateId: string, templateVariables: object): Promise<GenerateContentStreamResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  templateId | string | The ID of the server-side template to execute. |
|  templateVariables | object | A key-value map of variables to populate the template with. |

<b>Returns:</b>

Promise&lt;[GenerateContentStreamResult](./ai.generatecontentstreamresult.md#generatecontentstreamresult_interface)<!-- -->&gt;

