Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ThinkingConfig interface
Configuration for "thinking" behavior of compatible Gemini models.

Certain models utilize a thinking process before generating a response. This allows them to reason through complex problems and plan a more coherent and accurate answer.

<b>Signature:</b>

```typescript
export interface ThinkingConfig 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [includeThoughts](./ai.thinkingconfig.md#thinkingconfigincludethoughts) | boolean | Whether to include "thought summaries" in the model's response. |
|  [thinkingBudget](./ai.thinkingconfig.md#thinkingconfigthinkingbudget) | number | The thinking budget, in tokens.<!-- -->This parameter sets an upper limit on the number of tokens the model can use for its internal "thinking" process. A higher budget may result in higher quality responses for complex tasks but can also increase latency and cost.<!-- -->If you don't specify a budget, the model will determine the appropriate amount of thinking based on the complexity of the prompt.<!-- -->An error will be thrown if you set a thinking budget for a model that does not support this feature or if the specified budget is not within the model's supported range. |

## ThinkingConfig.includeThoughts

Whether to include "thought summaries" in the model's response.

Thought summaries provide a brief overview of the model's internal thinking process, offering insight into how it arrived at the final answer. This can be useful for debugging, understanding the model's reasoning, and verifying its accuracy.

<b>Signature:</b>

```typescript
includeThoughts?: boolean;
```

## ThinkingConfig.thinkingBudget

The thinking budget, in tokens.

This parameter sets an upper limit on the number of tokens the model can use for its internal "thinking" process. A higher budget may result in higher quality responses for complex tasks but can also increase latency and cost.

If you don't specify a budget, the model will determine the appropriate amount of thinking based on the complexity of the prompt.

An error will be thrown if you set a thinking budget for a model that does not support this feature or if the specified budget is not within the model's supported range.

<b>Signature:</b>

```typescript
thinkingBudget?: number;
```
