Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# VertexAIBackend class
Configuration class for the Vertex AI Gemini API.

Use this with [AIOptions](./ai.aioptions.md#aioptions_interface) when initializing the AI service via [getAI()](./ai.md#getai_a94a413) to specify the Vertex AI Gemini API as the backend.

<b>Signature:</b>

```typescript
export declare class VertexAIBackend extends Backend 
```
<b>Extends:</b> [Backend](./ai.backend.md#backend_class)

## Constructors

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [(constructor)(location)](./ai.vertexaibackend.md#vertexaibackendconstructor) |  | Creates a configuration object for the Vertex AI backend. |

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [location](./ai.vertexaibackend.md#vertexaibackendlocation) |  | string | The region identifier. See [Vertex AI locations](https://firebase.google.com/docs/vertex-ai/locations#available-locations) for a list of supported locations. |

## VertexAIBackend.(constructor)

Creates a configuration object for the Vertex AI backend.

<b>Signature:</b>

```typescript
constructor(location?: string);
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  location | string | The region identifier, defaulting to <code>us-central1</code>; see [Vertex AI locations](https://firebase.google.com/docs/vertex-ai/locations#available-locations) for a list of supported locations. |

## VertexAIBackend.location

The region identifier. See [Vertex AI locations](https://firebase.google.com/docs/vertex-ai/locations#available-locations) for a list of supported locations.

<b>Signature:</b>

```typescript
readonly location: string;
```
