Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ConsentSettings interface
Consent status settings for each consent type. For more information, see [the GA4 reference documentation for consent state and consent types](https://developers.google.com/tag-platform/tag-manager/templates/consent-apis)<!-- -->.

<b>Signature:</b>

```typescript
export interface ConsentSettings 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [ad\_personalization](./analytics.consentsettings.md#consentsettingsad_personalization) | [ConsentStatusString](./analytics.md#consentstatusstring) | Sets consent for personalized advertising. |
|  [ad\_storage](./analytics.consentsettings.md#consentsettingsad_storage) | [ConsentStatusString](./analytics.md#consentstatusstring) | Enables storage, such as cookies, related to advertising |
|  [ad\_user\_data](./analytics.consentsettings.md#consentsettingsad_user_data) | [ConsentStatusString](./analytics.md#consentstatusstring) | Sets consent for sending user data to Google for advertising purposes. |
|  [analytics\_storage](./analytics.consentsettings.md#consentsettingsanalytics_storage) | [ConsentStatusString](./analytics.md#consentstatusstring) | Enables storage, such as cookies, related to analytics (for example, visit duration) |
|  [functionality\_storage](./analytics.consentsettings.md#consentsettingsfunctionality_storage) | [ConsentStatusString](./analytics.md#consentstatusstring) | Enables storage that supports the functionality of the website or app such as language settings |
|  [personalization\_storage](./analytics.consentsettings.md#consentsettingspersonalization_storage) | [ConsentStatusString](./analytics.md#consentstatusstring) | Enables storage related to personalization such as video recommendations |
|  [security\_storage](./analytics.consentsettings.md#consentsettingssecurity_storage) | [ConsentStatusString](./analytics.md#consentstatusstring) | Enables storage related to security such as authentication functionality, fraud prevention, and other user protection. |

## ConsentSettings.ad\_personalization

Sets consent for personalized advertising.

<b>Signature:</b>

```typescript
ad_personalization?: ConsentStatusString;
```

## ConsentSettings.ad\_storage

Enables storage, such as cookies, related to advertising

<b>Signature:</b>

```typescript
ad_storage?: ConsentStatusString;
```

## ConsentSettings.ad\_user\_data

Sets consent for sending user data to Google for advertising purposes.

<b>Signature:</b>

```typescript
ad_user_data?: ConsentStatusString;
```

## ConsentSettings.analytics\_storage

Enables storage, such as cookies, related to analytics (for example, visit duration)

<b>Signature:</b>

```typescript
analytics_storage?: ConsentStatusString;
```

## ConsentSettings.functionality\_storage

Enables storage that supports the functionality of the website or app such as language settings

<b>Signature:</b>

```typescript
functionality_storage?: ConsentStatusString;
```

## ConsentSettings.personalization\_storage

Enables storage related to personalization such as video recommendations

<b>Signature:</b>

```typescript
personalization_storage?: ConsentStatusString;
```

## ConsentSettings.security\_storage

Enables storage related to security such as authentication functionality, fraud prevention, and other user protection.

<b>Signature:</b>

```typescript
security_storage?: ConsentStatusString;
```
