Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# analytics package
The Firebase Analytics Web SDK. This SDK does not work in a Node.js environment.

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [getAnalytics(app)](./analytics.md#getanalytics_cf608e1) | Returns an [Analytics](./analytics.analytics.md#analytics_interface) instance for the given app. |
|  [initializeAnalytics(app, options)](./analytics.md#initializeanalytics_a68c1d7) | Returns an [Analytics](./analytics.analytics.md#analytics_interface) instance for the given app. |
|  <b>function(analyticsInstance, ...)</b> |
|  [getGoogleAnalyticsClientId(analyticsInstance)](./analytics.md#getgoogleanalyticsclientid_b0a3b5a) | Retrieves a unique Google Analytics identifier for the web client. See [client\_id](https://developers.google.com/analytics/devguides/collection/ga4/reference/config#client_id)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_d5f1743) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_507c89b) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_918c505) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->See [Track Screenviews](https://firebase.google.com/docs/analytics/screenviews)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_97ff7c6) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_1f89527) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_5dd5dd2) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_77bad34) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_560b592) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_0f60635) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_bf98d4d) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_88130b6) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_feb40db) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_cfbc3bb) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_f0c3c2c) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_a155179) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_c4de9a4) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_8260753) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_162cb02) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_800159e) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->See [Measure exceptions](https://developers.google.com/analytics/devguides/collection/ga4/exceptions)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_9c11aa9) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_1f3f282) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [logEvent(analyticsInstance, eventName, eventParams, options)](./analytics.md#logevent_0792e28) | Sends a Google Analytics event with given <code>eventParams</code>. This method automatically associates this logged event with this Firebase web app instance on this device.<!-- -->See [Page views](https://developers.google.com/analytics/devguides/collection/ga4/views)<!-- -->. |
|  [setAnalyticsCollectionEnabled(analyticsInstance, enabled)](./analytics.md#setanalyticscollectionenabled_494179c) | Sets whether Google Analytics collection is enabled for this app on this device. Sets global <code>window['ga-disable-analyticsId'] = true;</code> |
|  [setCurrentScreen(analyticsInstance, screenName, options)](./analytics.md#setcurrentscreen_a6168fa) | Use gtag <code>config</code> command to set <code>screen_name</code>. |
|  [setUserId(analyticsInstance, id, options)](./analytics.md#setuserid_86d82f6) | Use gtag <code>config</code> command to set <code>user_id</code>. |
|  [setUserProperties(analyticsInstance, properties, options)](./analytics.md#setuserproperties_877b6e8) | Use gtag <code>config</code> command to set all params specified. |
|  <b>function()</b> |
|  [isSupported()](./analytics.md#issupported) | This is a public static method provided to users that wraps four different checks:<!-- -->1. Check if it's not a browser extension environment. 2. Check if cookies are enabled in current browser. 3. Check if IndexedDB is supported by the browser environment. 4. Check if the current browser context is valid for using <code>IndexedDB.open()</code>. |
|  <b>function(consentSettings, ...)</b> |
|  [setConsent(consentSettings)](./analytics.md#setconsent_1697027) | Sets the applicable end user consent state for this web app across all gtag references once Firebase Analytics is initialized.<!-- -->Use the [ConsentSettings](./analytics.consentsettings.md#consentsettings_interface) to specify individual consent type values. By default consent types are set to "granted". |
|  <b>function(customParams, ...)</b> |
|  [setDefaultEventParameters(customParams)](./analytics.md#setdefaulteventparameters_0682bee) | Adds data that will be set on every event logged from the SDK, including automatic ones. With gtag's "set" command, the values passed persist on the current page and are passed with all subsequent events. |
|  <b>function(options, ...)</b> |
|  [settings(options)](./analytics.md#settings_eb37905) | Configures Firebase Analytics to use custom <code>gtag</code> or <code>dataLayer</code> names. Intended to be used if <code>gtag.js</code> script has been installed on this page independently of Firebase Analytics, and is using non-default names for either the <code>gtag</code> function or for <code>dataLayer</code>. Must be called before calling <code>getAnalytics()</code> or it won't have any effect. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [Analytics](./analytics.analytics.md#analytics_interface) | An instance of Firebase Analytics. |
|  [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) | Additional options that can be passed to Analytics method calls such as <code>logEvent</code>, etc. |
|  [AnalyticsSettings](./analytics.analyticssettings.md#analyticssettings_interface) | [Analytics](./analytics.analytics.md#analytics_interface) instance initialization options. |
|  [ConsentSettings](./analytics.consentsettings.md#consentsettings_interface) | Consent status settings for each consent type. For more information, see [the GA4 reference documentation for consent state and consent types](https://developers.google.com/tag-platform/tag-manager/templates/consent-apis)<!-- -->. |
|  [ControlParams](./analytics.controlparams.md#controlparams_interface) | Standard <code>gtag.js</code> control parameters. For more information, see [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [CustomParams](./analytics.customparams.md#customparams_interface) | Any custom params the user may pass to <code>gtag</code>. |
|  [EventParams](./analytics.eventparams.md#eventparams_interface) | Standard <code>gtag.js</code> event parameters. For more information, see [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->. |
|  [GtagConfigParams](./analytics.gtagconfigparams.md#gtagconfigparams_interface) | A set of common Google Analytics config settings recognized by <code>gtag.js</code>. |
|  [Item](./analytics.item.md#item_interface) | Standard Google Analytics <code>Item</code> type. |
|  [Promotion](./analytics.promotion.md#promotion_interface) | Field previously used by some Google Analytics events. |
|  [SettingsOptions](./analytics.settingsoptions.md#settingsoptions_interface) | Specifies custom options for your Firebase Analytics instance. You must set these before initializing <code>firebase.analytics()</code>. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [ConsentStatusString](./analytics.md#consentstatusstring) | Whether a particular consent type has been granted or denied. |
|  [Currency](./analytics.md#currency) | Standard Google Analytics currency type. |
|  [CustomEventName](./analytics.md#customeventname) | Any custom event name string not in the standard list of recommended event names. |
|  [EventNameString](./analytics.md#eventnamestring) | Type for standard Google Analytics event names. <code>logEvent</code> also accepts any custom string and interprets it as a custom event name. |

## function(app, ...)

### getAnalytics(app) {:#getanalytics_cf608e1}

Returns an [Analytics](./analytics.analytics.md#analytics_interface) instance for the given app.

<b>Signature:</b>

```typescript
export declare function getAnalytics(app?: FirebaseApp): Analytics;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) to use. |

<b>Returns:</b>

[Analytics](./analytics.analytics.md#analytics_interface)

### initializeAnalytics(app, options) {:#initializeanalytics_a68c1d7}

Returns an [Analytics](./analytics.analytics.md#analytics_interface) instance for the given app.

<b>Signature:</b>

```typescript
export declare function initializeAnalytics(app: FirebaseApp, options?: AnalyticsSettings): Analytics;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) to use. |
|  options | [AnalyticsSettings](./analytics.analyticssettings.md#analyticssettings_interface) |  |

<b>Returns:</b>

[Analytics](./analytics.analytics.md#analytics_interface)

## function(analyticsInstance, ...)

### getGoogleAnalyticsClientId(analyticsInstance) {:#getgoogleanalyticsclientid_b0a3b5a}

Retrieves a unique Google Analytics identifier for the web client. See [client\_id](https://developers.google.com/analytics/devguides/collection/ga4/reference/config#client_id)<!-- -->.

<b>Signature:</b>

```typescript
export declare function getGoogleAnalyticsClientId(analyticsInstance: Analytics): Promise<string>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |

<b>Returns:</b>

Promise&lt;string&gt;

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_d5f1743}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'add_payment_info', eventParams?: {
    coupon?: EventParams['coupon'];
    currency?: EventParams['currency'];
    items?: EventParams['items'];
    payment_type?: EventParams['payment_type'];
    value?: EventParams['value'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'add\_payment\_info' |  |
|  eventParams | { coupon?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['coupon'\]; currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; payment\_type?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['payment\_type'\]; value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_507c89b}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'purchase' | 'refund', eventParams?: {
    value?: EventParams['value'];
    currency?: EventParams['currency'];
    transaction_id: EventParams['transaction_id'];
    tax?: EventParams['tax'];
    shipping?: EventParams['shipping'];
    items?: EventParams['items'];
    coupon?: EventParams['coupon'];
    affiliation?: EventParams['affiliation'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'purchase' \| 'refund' |  |
|  eventParams | { value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; transaction\_id: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['transaction\_id'\]; tax?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['tax'\]; shipping?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['shipping'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; coupon?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['coupon'\]; affiliation?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['affiliation'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_918c505}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

See [Track Screenviews](https://firebase.google.com/docs/analytics/screenviews)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'screen_view', eventParams?: {
    firebase_screen: EventParams['firebase_screen'];
    firebase_screen_class: EventParams['firebase_screen_class'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'screen\_view' |  |
|  eventParams | { firebase\_screen: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['firebase\_screen'\]; firebase\_screen\_class: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['firebase\_screen\_class'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_97ff7c6}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'search' | 'view_search_results', eventParams?: {
    search_term?: EventParams['search_term'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'search' \| 'view\_search\_results' |  |
|  eventParams | { search\_term?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['search\_term'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_1f89527}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'select_content', eventParams?: {
    content_type?: EventParams['content_type'];
    item_id?: EventParams['item_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'select\_content' |  |
|  eventParams | { content\_type?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['content\_type'\]; item\_id?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['item\_id'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_5dd5dd2}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'select_item', eventParams?: {
    items?: EventParams['items'];
    item_list_name?: EventParams['item_list_name'];
    item_list_id?: EventParams['item_list_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'select\_item' |  |
|  eventParams | { items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; item\_list\_name?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['item\_list\_name'\]; item\_list\_id?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['item\_list\_id'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_77bad34}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'select_promotion' | 'view_promotion', eventParams?: {
    items?: EventParams['items'];
    promotion_id?: EventParams['promotion_id'];
    promotion_name?: EventParams['promotion_name'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'select\_promotion' \| 'view\_promotion' |  |
|  eventParams | { items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; promotion\_id?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['promotion\_id'\]; promotion\_name?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['promotion\_name'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_560b592}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'set_checkout_option', eventParams?: {
    checkout_step?: EventParams['checkout_step'];
    checkout_option?: EventParams['checkout_option'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'set\_checkout\_option' |  |
|  eventParams | { checkout\_step?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['checkout\_step'\]; checkout\_option?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['checkout\_option'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_0f60635}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'share', eventParams?: {
    method?: EventParams['method'];
    content_type?: EventParams['content_type'];
    item_id?: EventParams['item_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'share' |  |
|  eventParams | { method?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['method'\]; content\_type?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['content\_type'\]; item\_id?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['item\_id'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_bf98d4d}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'sign_up', eventParams?: {
    method?: EventParams['method'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'sign\_up' |  |
|  eventParams | { method?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['method'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_88130b6}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'timing_complete', eventParams?: {
    name: string;
    value: number;
    event_category?: string;
    event_label?: string;
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'timing\_complete' |  |
|  eventParams | { name: string; value: number; event\_category?: string; event\_label?: string; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_feb40db}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'add_shipping_info', eventParams?: {
    coupon?: EventParams['coupon'];
    currency?: EventParams['currency'];
    items?: EventParams['items'];
    shipping_tier?: EventParams['shipping_tier'];
    value?: EventParams['value'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'add\_shipping\_info' |  |
|  eventParams | { coupon?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['coupon'\]; currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; shipping\_tier?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['shipping\_tier'\]; value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_cfbc3bb}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'view_cart' | 'view_item', eventParams?: {
    currency?: EventParams['currency'];
    items?: EventParams['items'];
    value?: EventParams['value'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'view\_cart' \| 'view\_item' |  |
|  eventParams | { currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_f0c3c2c}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'view_item_list', eventParams?: {
    items?: EventParams['items'];
    item_list_name?: EventParams['item_list_name'];
    item_list_id?: EventParams['item_list_id'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'view\_item\_list' |  |
|  eventParams | { items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; item\_list\_name?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['item\_list\_name'\]; item\_list\_id?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['item\_list\_id'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_a155179}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent<T extends string>(analyticsInstance: Analytics, eventName: CustomEventName<T>, eventParams?: {
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | [CustomEventName](./analytics.md#customeventname)<!-- -->&lt;T&gt; |  |
|  eventParams | { \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_c4de9a4}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'add_to_cart' | 'add_to_wishlist' | 'remove_from_cart', eventParams?: {
    currency?: EventParams['currency'];
    value?: EventParams['value'];
    items?: EventParams['items'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'add\_to\_cart' \| 'add\_to\_wishlist' \| 'remove\_from\_cart' |  |
|  eventParams | { currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_8260753}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'begin_checkout', eventParams?: {
    currency?: EventParams['currency'];
    coupon?: EventParams['coupon'];
    value?: EventParams['value'];
    items?: EventParams['items'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'begin\_checkout' |  |
|  eventParams | { currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; coupon?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['coupon'\]; value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_162cb02}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'checkout_progress', eventParams?: {
    currency?: EventParams['currency'];
    coupon?: EventParams['coupon'];
    value?: EventParams['value'];
    items?: EventParams['items'];
    checkout_step?: EventParams['checkout_step'];
    checkout_option?: EventParams['checkout_option'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'checkout\_progress' |  |
|  eventParams | { currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; coupon?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['coupon'\]; value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; items?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['items'\]; checkout\_step?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['checkout\_step'\]; checkout\_option?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['checkout\_option'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_800159e}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

See [Measure exceptions](https://developers.google.com/analytics/devguides/collection/ga4/exceptions)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'exception', eventParams?: {
    description?: EventParams['description'];
    fatal?: EventParams['fatal'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'exception' |  |
|  eventParams | { description?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['description'\]; fatal?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['fatal'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_9c11aa9}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'generate_lead', eventParams?: {
    value?: EventParams['value'];
    currency?: EventParams['currency'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'generate\_lead' |  |
|  eventParams | { value?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['value'\]; currency?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['currency'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_1f3f282}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

List of recommended event parameters can be found in [the GA4 reference documentation](https://developers.google.com/gtagjs/reference/ga4-events)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'login', eventParams?: {
    method?: EventParams['method'];
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'login' |  |
|  eventParams | { method?: [EventParams](./analytics.eventparams.md#eventparams_interface)<!-- -->\['method'\]; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### logEvent(analyticsInstance, eventName, eventParams, options) {:#logevent_0792e28}

Sends a Google Analytics event with given `eventParams`<!-- -->. This method automatically associates this logged event with this Firebase web app instance on this device.

See [Page views](https://developers.google.com/analytics/devguides/collection/ga4/views)<!-- -->.

<b>Signature:</b>

```typescript
export declare function logEvent(analyticsInstance: Analytics, eventName: 'page_view', eventParams?: {
    page_title?: string;
    page_location?: string;
    page_path?: string;
    [key: string]: any;
}, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  eventName | 'page\_view' |  |
|  eventParams | { page\_title?: string; page\_location?: string; page\_path?: string; \[key: string\]: any; } |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### setAnalyticsCollectionEnabled(analyticsInstance, enabled) {:#setanalyticscollectionenabled_494179c}

Sets whether Google Analytics collection is enabled for this app on this device. Sets global `window['ga-disable-analyticsId'] = true;`

<b>Signature:</b>

```typescript
export declare function setAnalyticsCollectionEnabled(analyticsInstance: Analytics, enabled: boolean): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) | The [Analytics](./analytics.analytics.md#analytics_interface) instance. |
|  enabled | boolean | If true, enables collection, if false, disables it. |

<b>Returns:</b>

void

### setCurrentScreen(analyticsInstance, screenName, options) {:#setcurrentscreen_a6168fa}

> Warning: This API is now obsolete.
> 
> Use  with `eventName` as 'screen\_view' and add relevant `eventParams`<!-- -->. See [Track Screenviews](https://firebase.google.com/docs/analytics/screenviews)<!-- -->.
> 

Use gtag `config` command to set `screen_name`<!-- -->.

<b>Signature:</b>

```typescript
export declare function setCurrentScreen(analyticsInstance: Analytics, screenName: string, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) | The [Analytics](./analytics.analytics.md#analytics_interface) instance. |
|  screenName | string | Screen name to set. |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### setUserId(analyticsInstance, id, options) {:#setuserid_86d82f6}

Use gtag `config` command to set `user_id`<!-- -->.

<b>Signature:</b>

```typescript
export declare function setUserId(analyticsInstance: Analytics, id: string | null, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) | The [Analytics](./analytics.analytics.md#analytics_interface) instance. |
|  id | string \| null | User ID to set. |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

### setUserProperties(analyticsInstance, properties, options) {:#setuserproperties_877b6e8}

Use gtag `config` command to set all params specified.

<b>Signature:</b>

```typescript
export declare function setUserProperties(analyticsInstance: Analytics, properties: CustomParams, options?: AnalyticsCallOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  analyticsInstance | [Analytics](./analytics.analytics.md#analytics_interface) |  |
|  properties | [CustomParams](./analytics.customparams.md#customparams_interface) |  |
|  options | [AnalyticsCallOptions](./analytics.analyticscalloptions.md#analyticscalloptions_interface) |  |

<b>Returns:</b>

void

## function()

### isSupported() {:#issupported}

This is a public static method provided to users that wraps four different checks:

1. Check if it's not a browser extension environment. 2. Check if cookies are enabled in current browser. 3. Check if IndexedDB is supported by the browser environment. 4. Check if the current browser context is valid for using `IndexedDB.open()`<!-- -->.

<b>Signature:</b>

```typescript
export declare function isSupported(): Promise<boolean>;
```
<b>Returns:</b>

Promise&lt;boolean&gt;

## function(consentSettings, ...)

### setConsent(consentSettings) {:#setconsent_1697027}

Sets the applicable end user consent state for this web app across all gtag references once Firebase Analytics is initialized.

Use the [ConsentSettings](./analytics.consentsettings.md#consentsettings_interface) to specify individual consent type values. By default consent types are set to "granted".

<b>Signature:</b>

```typescript
export declare function setConsent(consentSettings: ConsentSettings): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  consentSettings | [ConsentSettings](./analytics.consentsettings.md#consentsettings_interface) | Maps the applicable end user consent state for gtag.js. |

<b>Returns:</b>

void

## function(customParams, ...)

### setDefaultEventParameters(customParams) {:#setdefaulteventparameters_0682bee}

Adds data that will be set on every event logged from the SDK, including automatic ones. With gtag's "set" command, the values passed persist on the current page and are passed with all subsequent events.

<b>Signature:</b>

```typescript
export declare function setDefaultEventParameters(customParams: CustomParams): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  customParams | [CustomParams](./analytics.customparams.md#customparams_interface) | Any custom params the user may pass to gtag.js. |

<b>Returns:</b>

void

## function(options, ...)

### settings(options) {:#settings_eb37905}

Configures Firebase Analytics to use custom `gtag` or `dataLayer` names. Intended to be used if `gtag.js` script has been installed on this page independently of Firebase Analytics, and is using non-default names for either the `gtag` function or for `dataLayer`<!-- -->. Must be called before calling `getAnalytics()` or it won't have any effect.

<b>Signature:</b>

```typescript
export declare function settings(options: SettingsOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [SettingsOptions](./analytics.settingsoptions.md#settingsoptions_interface) | Custom gtag and dataLayer names. |

<b>Returns:</b>

void

## ConsentStatusString

Whether a particular consent type has been granted or denied.

<b>Signature:</b>

```typescript
export type ConsentStatusString = 'granted' | 'denied';
```

## Currency

Standard Google Analytics currency type.

<b>Signature:</b>

```typescript
export type Currency = string | number;
```

## CustomEventName

Any custom event name string not in the standard list of recommended event names.

<b>Signature:</b>

```typescript
export type CustomEventName<T> = T extends EventNameString ? never : T;
```

## EventNameString

Type for standard Google Analytics event names. `logEvent` also accepts any custom string and interprets it as a custom event name.

<b>Signature:</b>

```typescript
export type EventNameString = 'add_payment_info' | 'add_shipping_info' | 'add_to_cart' | 'add_to_wishlist' | 'begin_checkout' | 'checkout_progress' | 'exception' | 'generate_lead' | 'login' | 'page_view' | 'purchase' | 'refund' | 'remove_from_cart' | 'screen_view' | 'search' | 'select_content' | 'select_item' | 'select_promotion' | 'set_checkout_option' | 'share' | 'sign_up' | 'timing_complete' | 'view_cart' | 'view_item' | 'view_item_list' | 'view_promotion' | 'view_search_results';
```
