Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# app-check package
The Firebase App Check Web SDK.

Firebase App Check does not work in a Node.js environment using `ReCaptchaV3Provider` or `ReCaptchaEnterpriseProvider`<!-- -->, but can be used in Node.js if you use `CustomProvider` and write your own attestation method.

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [initializeAppCheck(app, options)](./app-check.md#initializeappcheck_5548dfc) | Activate App Check for the given app. Can be called only once per app. |
|  <b>function(appCheckInstance, ...)</b> |
|  [getLimitedUseToken(appCheckInstance)](./app-check.md#getlimitedusetoken_53ef5e3) | Requests a Firebase App Check token. This method should be used only if you need to authorize requests to a non-Firebase backend.<!-- -->Returns limited-use tokens that are intended for use with your non-Firebase backend endpoints that are protected with <a href="https://firebase.google.com/docs/app-check/custom-resource-backend#replay-protection"> Replay Protection</a>. This method does not affect the token generation behavior of the \#getAppCheckToken() method. |
|  [getToken(appCheckInstance, forceRefresh)](./app-check.md#gettoken_39fc1b3) | Get the current App Check token. If <code>forceRefresh</code> is false, this function first checks for a valid token in memory, then local persistence (IndexedDB). If not found, or if <code>forceRefresh</code> is true, it makes a request to the App Check endpoint for a fresh token. That request attaches to the most recent in-flight request if one is present. |
|  [onTokenChanged(appCheckInstance, observer)](./app-check.md#ontokenchanged_9761e16) | Registers a listener to changes in the token state. There can be more than one listener registered at the same time for one or more App Check instances. The listeners call back on the UI thread whenever the current token associated with this App Check instance changes. |
|  [onTokenChanged(appCheckInstance, onNext, onError, onCompletion)](./app-check.md#ontokenchanged_8ef80a7) | Registers a listener to changes in the token state. There can be more than one listener registered at the same time for one or more App Check instances. The listeners call back on the UI thread whenever the current token associated with this App Check instance changes. |
|  [setTokenAutoRefreshEnabled(appCheckInstance, isTokenAutoRefreshEnabled)](./app-check.md#settokenautorefreshenabled_057a76c) | Set whether App Check will automatically refresh tokens as needed. |

## Classes

|  Class | Description |
|  --- | --- |
|  [CustomProvider](./app-check.customprovider.md#customprovider_class) | Custom provider class. |
|  [ReCaptchaEnterpriseProvider](./app-check.recaptchaenterpriseprovider.md#recaptchaenterpriseprovider_class) | App Check provider that can obtain a reCAPTCHA Enterprise token and exchange it for an App Check token. |
|  [ReCaptchaV3Provider](./app-check.recaptchav3provider.md#recaptchav3provider_class) | App Check provider that can obtain a reCAPTCHA V3 token and exchange it for an App Check token. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [AppCheck](./app-check.appcheck.md#appcheck_interface) | The Firebase App Check service interface. |
|  [AppCheckOptions](./app-check.appcheckoptions.md#appcheckoptions_interface) | Options for App Check initialization. |
|  [AppCheckToken](./app-check.appchecktoken.md#appchecktoken_interface) | The token returned from an App Check provider. |
|  [AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface) | Result returned by <code>getToken()</code>. |
|  [CustomProviderOptions](./app-check.customprovideroptions.md#customprovideroptions_interface) | Options when creating a [CustomProvider](./app-check.customprovider.md#customprovider_class)<!-- -->. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AppCheckTokenListener](./app-check.md#appchecktokenlistener) | A listener that is called whenever the App Check token changes. |

## function(app, ...)

### initializeAppCheck(app, options) {:#initializeappcheck_5548dfc}

Activate App Check for the given app. Can be called only once per app.

<b>Signature:</b>

```typescript
export declare function initializeAppCheck(app: FirebaseApp | undefined, options: AppCheckOptions): AppCheck;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) \| undefined | the [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) to activate App Check for |
|  options | [AppCheckOptions](./app-check.appcheckoptions.md#appcheckoptions_interface) | App Check initialization options |

<b>Returns:</b>

[AppCheck](./app-check.appcheck.md#appcheck_interface)

## function(appCheckInstance, ...)

### getLimitedUseToken(appCheckInstance) {:#getlimitedusetoken_53ef5e3}

Requests a Firebase App Check token. This method should be used only if you need to authorize requests to a non-Firebase backend.

Returns limited-use tokens that are intended for use with your non-Firebase backend endpoints that are protected with <a href="https://firebase.google.com/docs/app-check/custom-resource-backend#replay-protection"> Replay Protection</a>. This method does not affect the token generation behavior of the \#getAppCheckToken() method.

<b>Signature:</b>

```typescript
export declare function getLimitedUseToken(appCheckInstance: AppCheck): Promise<AppCheckTokenResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  appCheckInstance | [AppCheck](./app-check.appcheck.md#appcheck_interface) | The App Check service instance. |

<b>Returns:</b>

Promise&lt;[AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface)<!-- -->&gt;

The limited use token.

### getToken(appCheckInstance, forceRefresh) {:#gettoken_39fc1b3}

Get the current App Check token. If `forceRefresh` is false, this function first checks for a valid token in memory, then local persistence (IndexedDB). If not found, or if `forceRefresh` is true, it makes a request to the App Check endpoint for a fresh token. That request attaches to the most recent in-flight request if one is present.

<b>Signature:</b>

```typescript
export declare function getToken(appCheckInstance: AppCheck, forceRefresh?: boolean): Promise<AppCheckTokenResult>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  appCheckInstance | [AppCheck](./app-check.appcheck.md#appcheck_interface) | The App Check service instance. |
|  forceRefresh | boolean | If true, will always try to fetch a fresh token. If false, will use a cached token if found in storage. |

<b>Returns:</b>

Promise&lt;[AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface)<!-- -->&gt;

### onTokenChanged(appCheckInstance, observer) {:#ontokenchanged_9761e16}

Registers a listener to changes in the token state. There can be more than one listener registered at the same time for one or more App Check instances. The listeners call back on the UI thread whenever the current token associated with this App Check instance changes.

<b>Signature:</b>

```typescript
export declare function onTokenChanged(appCheckInstance: AppCheck, observer: PartialObserver<AppCheckTokenResult>): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  appCheckInstance | [AppCheck](./app-check.appcheck.md#appcheck_interface) | The App Check service instance. |
|  observer | [PartialObserver](./util.md#partialobserver)<!-- -->&lt;[AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface)<!-- -->&gt; | An object with <code>next</code>, <code>error</code>, and <code>complete</code> properties. <code>next</code> is called with an [AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface) whenever the token changes. <code>error</code> is optional and is called if an error is thrown by the listener (the <code>next</code> function). <code>complete</code> is unused, as the token stream is unending. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

A function that unsubscribes this listener.

### onTokenChanged(appCheckInstance, onNext, onError, onCompletion) {:#ontokenchanged_8ef80a7}

Registers a listener to changes in the token state. There can be more than one listener registered at the same time for one or more App Check instances. The listeners call back on the UI thread whenever the current token associated with this App Check instance changes.

<b>Signature:</b>

```typescript
export declare function onTokenChanged(appCheckInstance: AppCheck, onNext: (tokenResult: AppCheckTokenResult) => void, onError?: (error: Error) => void, onCompletion?: () => void): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  appCheckInstance | [AppCheck](./app-check.appcheck.md#appcheck_interface) | The App Check service instance. |
|  onNext | (tokenResult: [AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface)<!-- -->) =&gt; void | When the token changes, this function is called with an [AppCheckTokenResult](./app-check.appchecktokenresult.md#appchecktokenresult_interface)<!-- -->. |
|  onError | (error: Error) =&gt; void | Optional. Called if there is an error thrown by the listener (the <code>onNext</code> function). |
|  onCompletion | () =&gt; void | Currently unused, as the token stream is unending. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

A function that unsubscribes this listener.

### setTokenAutoRefreshEnabled(appCheckInstance, isTokenAutoRefreshEnabled) {:#settokenautorefreshenabled_057a76c}

Set whether App Check will automatically refresh tokens as needed.

<b>Signature:</b>

```typescript
export declare function setTokenAutoRefreshEnabled(appCheckInstance: AppCheck, isTokenAutoRefreshEnabled: boolean): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  appCheckInstance | [AppCheck](./app-check.appcheck.md#appcheck_interface) | The App Check service instance. |
|  isTokenAutoRefreshEnabled | boolean | If true, the SDK automatically refreshes App Check tokens as needed. This overrides any value set during <code>initializeAppCheck()</code>. |

<b>Returns:</b>

void

## AppCheckTokenListener

A listener that is called whenever the App Check token changes.

<b>Signature:</b>

```typescript
export type AppCheckTokenListener = (token: AppCheckTokenResult) => void;
```
