Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# FirebaseApp interface
A [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) holds the initialization information for a collection of services.

Do not call this constructor directly. Instead, use [initializeApp()](./app.md#initializeapp_cb2f5e1) to create an app.

<b>Signature:</b>

```typescript
export interface FirebaseApp 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [automaticDataCollectionEnabled](./app.firebaseapp.md#firebaseappautomaticdatacollectionenabled) | boolean | The settable config flag for GDPR opt-in/opt-out |
|  [name](./app.firebaseapp.md#firebaseappname) | string | The (read-only) name for this app.<!-- -->The default app's name is <code>&quot;[DEFAULT]&quot;</code>. |
|  [options](./app.firebaseapp.md#firebaseappoptions) | [FirebaseOptions](./app.firebaseoptions.md#firebaseoptions_interface) | The (read-only) configuration options for this app. These are the original parameters given in [initializeApp()](./app.md#initializeapp_cb2f5e1)<!-- -->. |

## FirebaseApp.automaticDataCollectionEnabled

The settable config flag for GDPR opt-in/opt-out

<b>Signature:</b>

```typescript
automaticDataCollectionEnabled: boolean;
```

## FirebaseApp.name

The (read-only) name for this app.

The default app's name is `"[DEFAULT]"`<!-- -->.

<b>Signature:</b>

```typescript
readonly name: string;
```

### Example 1


```javascript
// The default app's name is "[DEFAULT]"
const app = initializeApp(defaultAppConfig);
console.log(app.name);  // "[DEFAULT]"

```

### Example 2


```javascript
// A named app's name is what you provide to initializeApp()
const otherApp = initializeApp(otherAppConfig, "other");
console.log(otherApp.name);  // "other"

```

## FirebaseApp.options

The (read-only) configuration options for this app. These are the original parameters given in [initializeApp()](./app.md#initializeapp_cb2f5e1)<!-- -->.

<b>Signature:</b>

```typescript
readonly options: FirebaseOptions;
```

### Example


```javascript
const app = initializeApp(config);
console.log(app.options.databaseURL === config.databaseURL);  // true

```

