Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# FirebaseOptions interface
Firebase configuration object. Contains a set of parameters required by services in order to successfully communicate with Firebase server APIs and to associate client data with your Firebase project and Firebase application. Typically this object is populated by the Firebase console at project setup. See also: [Learn about the Firebase config object](https://firebase.google.com/docs/web/setup#config-object)<!-- -->.

<b>Signature:</b>

```typescript
export interface FirebaseOptions 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [apiKey](./app.firebaseoptions.md#firebaseoptionsapikey) | string | An encrypted string used when calling certain APIs that don't need to access private user data (example value: <code>AIzaSyDOCAbC123dEf456GhI789jKl012-MnO</code>). |
|  [appId](./app.firebaseoptions.md#firebaseoptionsappid) | string | Unique identifier for the app. |
|  [authDomain](./app.firebaseoptions.md#firebaseoptionsauthdomain) | string | Auth domain for the project ID. |
|  [databaseURL](./app.firebaseoptions.md#firebaseoptionsdatabaseurl) | string | Default Realtime Database URL. |
|  [measurementId](./app.firebaseoptions.md#firebaseoptionsmeasurementid) | string | An ID automatically created when you enable Analytics in your Firebase project and register a web app. In versions 7.20.0 and higher, this parameter is optional. |
|  [messagingSenderId](./app.firebaseoptions.md#firebaseoptionsmessagingsenderid) | string | Unique numerical value used to identify each sender that can send Firebase Cloud Messaging messages to client apps. |
|  [projectId](./app.firebaseoptions.md#firebaseoptionsprojectid) | string | The unique identifier for the project across all of Firebase and Google Cloud. |
|  [storageBucket](./app.firebaseoptions.md#firebaseoptionsstoragebucket) | string | The default Cloud Storage bucket name. |

## FirebaseOptions.apiKey

An encrypted string used when calling certain APIs that don't need to access private user data (example value: `AIzaSyDOCAbC123dEf456GhI789jKl012-MnO`<!-- -->).

<b>Signature:</b>

```typescript
apiKey?: string;
```

## FirebaseOptions.appId

Unique identifier for the app.

<b>Signature:</b>

```typescript
appId?: string;
```

## FirebaseOptions.authDomain

Auth domain for the project ID.

<b>Signature:</b>

```typescript
authDomain?: string;
```

## FirebaseOptions.databaseURL

Default Realtime Database URL.

<b>Signature:</b>

```typescript
databaseURL?: string;
```

## FirebaseOptions.measurementId

An ID automatically created when you enable Analytics in your Firebase project and register a web app. In versions 7.20.0 and higher, this parameter is optional.

<b>Signature:</b>

```typescript
measurementId?: string;
```

## FirebaseOptions.messagingSenderId

Unique numerical value used to identify each sender that can send Firebase Cloud Messaging messages to client apps.

<b>Signature:</b>

```typescript
messagingSenderId?: string;
```

## FirebaseOptions.projectId

The unique identifier for the project across all of Firebase and Google Cloud.

<b>Signature:</b>

```typescript
projectId?: string;
```

## FirebaseOptions.storageBucket

The default Cloud Storage bucket name.

<b>Signature:</b>

```typescript
storageBucket?: string;
```
