Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# FirebaseServerApp interface
A [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) holds the initialization information for a collection of services running in server environments.

Do not call this constructor directly. Instead, use [initializeServerApp()](./app.md#initializeserverapp_30ab697) to create an app.

<b>Signature:</b>

```typescript
export interface FirebaseServerApp extends FirebaseApp 
```
<b>Extends:</b> [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [name](./app.firebaseserverapp.md#firebaseserverappname) | string | There is no <code>getApp()</code> operation for <code>FirebaseServerApp</code>, so the name is not relevant for applications. However, it may be used internally, and is declared here so that <code>FirebaseServerApp</code> conforms to the <code>FirebaseApp</code> interface. |
|  [settings](./app.firebaseserverapp.md#firebaseserverappsettings) | [FirebaseServerAppSettings](./app.firebaseserverappsettings.md#firebaseserverappsettings_interface) | The (read-only) configuration settings for this server app. These are the original parameters given in [initializeServerApp()](./app.md#initializeserverapp_30ab697)<!-- -->. |

## FirebaseServerApp.name

There is no `getApp()` operation for `FirebaseServerApp`<!-- -->, so the name is not relevant for applications. However, it may be used internally, and is declared here so that `FirebaseServerApp` conforms to the `FirebaseApp` interface.

<b>Signature:</b>

```typescript
name: string;
```

## FirebaseServerApp.settings

The (read-only) configuration settings for this server app. These are the original parameters given in [initializeServerApp()](./app.md#initializeserverapp_30ab697)<!-- -->.

<b>Signature:</b>

```typescript
readonly settings: FirebaseServerAppSettings;
```

### Example


```javascript
const app = initializeServerApp(settings);
console.log(app.settings.authIdToken === options.authIdToken);  // true

```

