Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# app package
Firebase App

This package coordinates the communication between the different Firebase components

## Functions

|  Function | Description |
|  --- | --- |
|  <b>function(app, ...)</b> |
|  [deleteApp(app)](./app.md#deleteapp_cf608e1) | Renders this app unusable and frees the resources of all associated services. |
|  <b>function()</b> |
|  [getApps()](./app.md#getapps) | A (read-only) array of all initialized apps. |
|  [initializeApp()](./app.md#initializeapp) | Creates and initializes a FirebaseApp instance. |
|  <b>function(config, ...)</b> |
|  [initializeServerApp(config)](./app.md#initializeserverapp_e7d0728) | Creates and initializes a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) instance. |
|  <b>function(libraryKeyOrName, ...)</b> |
|  [registerVersion(libraryKeyOrName, version, variant)](./app.md#registerversion_f673248) | Registers a library's name and version for platform logging purposes. |
|  <b>function(logCallback, ...)</b> |
|  [onLog(logCallback, options)](./app.md#onlog_fd46eae) | Sets log handler for all Firebase SDKs. |
|  <b>function(logLevel, ...)</b> |
|  [setLogLevel(logLevel)](./app.md#setloglevel_697d53a) | Sets log level for all Firebase SDKs.<!-- -->All of the log types above the current log level are captured (i.e. if you set the log level to <code>info</code>, errors are logged, but <code>debug</code> and <code>verbose</code> logs are not). |
|  <b>function(name, ...)</b> |
|  [getApp(name)](./app.md#getapp_1eaaff4) | Retrieves a [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance.<!-- -->When called with no arguments, the default app is returned. When an app name is provided, the app corresponding to that name is returned.<!-- -->An exception is thrown if the app being retrieved has not yet been initialized. |
|  <b>function(options, ...)</b> |
|  [initializeApp(options, name)](./app.md#initializeapp_cb2f5e1) | Creates and initializes a [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance.<!-- -->See [Add Firebase to your app](https://firebase.google.com/docs/web/setup#add_firebase_to_your_app) and [Initialize multiple projects](https://firebase.google.com/docs/web/setup#multiple-projects) for detailed documentation. |
|  [initializeApp(options, config)](./app.md#initializeapp_079e917) | Creates and initializes a FirebaseApp instance. |
|  [initializeServerApp(options, config)](./app.md#initializeserverapp_30ab697) | Creates and initializes a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) instance.<!-- -->The <code>FirebaseServerApp</code> is similar to <code>FirebaseApp</code>, but is intended for execution in server side rendering environments only. Initialization will fail if invoked from a browser environment.<!-- -->See [Add Firebase to your app](https://firebase.google.com/docs/web/setup#add_firebase_to_your_app) and [Initialize multiple projects](https://firebase.google.com/docs/web/setup#multiple-projects) for detailed documentation. |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | A [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) holds the initialization information for a collection of services.<!-- -->Do not call this constructor directly. Instead, use [initializeApp()](./app.md#initializeapp_cb2f5e1) to create an app. |
|  [FirebaseAppSettings](./app.firebaseappsettings.md#firebaseappsettings_interface) | Configuration options given to [initializeApp()](./app.md#initializeapp_cb2f5e1) |
|  [FirebaseOptions](./app.firebaseoptions.md#firebaseoptions_interface) | Firebase configuration object. Contains a set of parameters required by services in order to successfully communicate with Firebase server APIs and to associate client data with your Firebase project and Firebase application. Typically this object is populated by the Firebase console at project setup. See also: [Learn about the Firebase config object](https://firebase.google.com/docs/web/setup#config-object)<!-- -->. |
|  [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) | A [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) holds the initialization information for a collection of services running in server environments.<!-- -->Do not call this constructor directly. Instead, use [initializeServerApp()](./app.md#initializeserverapp_30ab697) to create an app. |
|  [FirebaseServerAppSettings](./app.firebaseserverappsettings.md#firebaseserverappsettings_interface) | Configuration options given to [initializeServerApp()](./app.md#initializeserverapp_30ab697) |

## Variables

|  Variable | Description |
|  --- | --- |
|  [SDK\_VERSION](./app.md#sdk_version) | The current SDK version. |

## function(app, ...)

### deleteApp(app) {:#deleteapp_cf608e1}

Renders this app unusable and frees the resources of all associated services.

<b>Signature:</b>

```typescript
export declare function deleteApp(app: FirebaseApp): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  app | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) |  |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
deleteApp(app)
  .then(function() {
    console.log("App deleted successfully");
  })
  .catch(function(error) {
    console.log("Error deleting app:", error);
  });

```

## function()

### getApps() {:#getapps}

A (read-only) array of all initialized apps.

<b>Signature:</b>

```typescript
export declare function getApps(): FirebaseApp[];
```
<b>Returns:</b>

[FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)<!-- -->\[\]

### initializeApp() {:#initializeapp}

Creates and initializes a FirebaseApp instance.

<b>Signature:</b>

```typescript
export declare function initializeApp(): FirebaseApp;
```
<b>Returns:</b>

[FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)

## function(config, ...)

### initializeServerApp(config) {:#initializeserverapp_e7d0728}

Creates and initializes a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) instance.

<b>Signature:</b>

```typescript
export declare function initializeServerApp(config?: FirebaseServerAppSettings): FirebaseServerApp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  config | [FirebaseServerAppSettings](./app.firebaseserverappsettings.md#firebaseserverappsettings_interface) | Optional <code>FirebaseServerApp</code> settings. |

<b>Returns:</b>

[FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)

The initialized `FirebaseServerApp`<!-- -->.

#### Exceptions

If invoked in an unsupported non-server environment such as a browser.

If [FirebaseServerAppSettings.releaseOnDeref](./app.firebaseserverappsettings.md#firebaseserverappsettingsreleaseonderef) is defined but the runtime doesn't provide Finalization Registry support.

If the `FIREBASE_OPTIONS` environment variable does not contain a valid project configuration required for auto-initialization.

## function(libraryKeyOrName, ...)

### registerVersion(libraryKeyOrName, version, variant) {:#registerversion_f673248}

Registers a library's name and version for platform logging purposes.

<b>Signature:</b>

```typescript
export declare function registerVersion(libraryKeyOrName: string, version: string, variant?: string): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  libraryKeyOrName | string |  |
|  version | string | Current version of that library. |
|  variant | string | Bundle variant, e.g., node, rn, etc. |

<b>Returns:</b>

void

## function(logCallback, ...)

### onLog(logCallback, options) {:#onlog_fd46eae}

Sets log handler for all Firebase SDKs.

<b>Signature:</b>

```typescript
export declare function onLog(logCallback: LogCallback | null, options?: LogOptions): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  logCallback | LogCallback \| null | An optional custom log handler that executes user code whenever the Firebase SDK makes a logging call. |
|  options | LogOptions |  |

<b>Returns:</b>

void

## function(logLevel, ...)

### setLogLevel(logLevel) {:#setloglevel_697d53a}

Sets log level for all Firebase SDKs.

All of the log types above the current log level are captured (i.e. if you set the log level to `info`<!-- -->, errors are logged, but `debug` and `verbose` logs are not).

<b>Signature:</b>

```typescript
export declare function setLogLevel(logLevel: LogLevelString): void;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  logLevel | LogLevelString |  |

<b>Returns:</b>

void

## function(name, ...)

### getApp(name) {:#getapp_1eaaff4}

Retrieves a [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance.

When called with no arguments, the default app is returned. When an app name is provided, the app corresponding to that name is returned.

An exception is thrown if the app being retrieved has not yet been initialized.

<b>Signature:</b>

```typescript
export declare function getApp(name?: string): FirebaseApp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  name | string | Optional name of the app to return. If no name is provided, the default is <code>&quot;[DEFAULT]&quot;</code>. |

<b>Returns:</b>

[FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)

The app corresponding to the provided app name. If no app name is provided, the default app is returned.

### Example 1


```javascript
// Return the default app
const app = getApp();

```

### Example 2


```javascript
// Return a named app
const otherApp = getApp("otherApp");

```

## function(options, ...)

### initializeApp(options, name) {:#initializeapp_cb2f5e1}

Creates and initializes a [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) instance.

See [Add Firebase to your app](https://firebase.google.com/docs/web/setup#add_firebase_to_your_app) and [Initialize multiple projects](https://firebase.google.com/docs/web/setup#multiple-projects) for detailed documentation.

<b>Signature:</b>

```typescript
export declare function initializeApp(options: FirebaseOptions, name?: string): FirebaseApp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [FirebaseOptions](./app.firebaseoptions.md#firebaseoptions_interface) | Options to configure the app's services. |
|  name | string | Optional name of the app to initialize. If no name is provided, the default is <code>&quot;[DEFAULT]&quot;</code>. |

<b>Returns:</b>

[FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)

The initialized app.

#### Exceptions

If the optional `name` parameter is malformed or empty.

If a `FirebaseApp` already exists with the same name but with a different configuration.

### Example 1


```javascript

// Initialize default app
// Retrieve your own options values by adding a web app on
// https://console.firebase.google.com
initializeApp({
  apiKey: "AIza....",                             // Auth / General Use
  authDomain: "YOUR_APP.firebaseapp.com",         // Auth with popup/redirect
  databaseURL: "https://YOUR_APP.firebaseio.com", // Realtime Database
  storageBucket: "YOUR_APP.appspot.com",          // Storage
  messagingSenderId: "123456789"                  // Cloud Messaging
});

```

### Example 2


```javascript

// Initialize another app
const otherApp = initializeApp({
  databaseURL: "https://<OTHER_DATABASE_NAME>.firebaseio.com",
  storageBucket: "<OTHER_STORAGE_BUCKET>.appspot.com"
}, "otherApp");

```

### initializeApp(options, config) {:#initializeapp_079e917}

Creates and initializes a FirebaseApp instance.

<b>Signature:</b>

```typescript
export declare function initializeApp(options: FirebaseOptions, config?: FirebaseAppSettings): FirebaseApp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [FirebaseOptions](./app.firebaseoptions.md#firebaseoptions_interface) | Options to configure the app's services. |
|  config | [FirebaseAppSettings](./app.firebaseappsettings.md#firebaseappsettings_interface) | FirebaseApp Configuration |

<b>Returns:</b>

[FirebaseApp](./app.firebaseapp.md#firebaseapp_interface)

#### Exceptions

If [FirebaseAppSettings.name](./app.firebaseappsettings.md#firebaseappsettingsname) is defined but the value is malformed or empty.

If a `FirebaseApp` already exists with the same name but with a different configuration.

### initializeServerApp(options, config) {:#initializeserverapp_30ab697}

Creates and initializes a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface) instance.

The `FirebaseServerApp` is similar to `FirebaseApp`<!-- -->, but is intended for execution in server side rendering environments only. Initialization will fail if invoked from a browser environment.

See [Add Firebase to your app](https://firebase.google.com/docs/web/setup#add_firebase_to_your_app) and [Initialize multiple projects](https://firebase.google.com/docs/web/setup#multiple-projects) for detailed documentation.

<b>Signature:</b>

```typescript
export declare function initializeServerApp(options: FirebaseOptions | FirebaseApp, config?: FirebaseServerAppSettings): FirebaseServerApp;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  options | [FirebaseOptions](./app.firebaseoptions.md#firebaseoptions_interface) \| [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | <code>Firebase.AppOptions</code> to configure the app's services, or a a <code>FirebaseApp</code> instance which contains the <code>AppOptions</code> within. |
|  config | [FirebaseServerAppSettings](./app.firebaseserverappsettings.md#firebaseserverappsettings_interface) | Optional <code>FirebaseServerApp</code> settings. |

<b>Returns:</b>

[FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)

The initialized `FirebaseServerApp`<!-- -->.

#### Exceptions

If invoked in an unsupported non-server environment such as a browser.

If [FirebaseServerAppSettings.releaseOnDeref](./app.firebaseserverappsettings.md#firebaseserverappsettingsreleaseonderef) is defined but the runtime doesn't provide Finalization Registry support.

### Example


```javascript

// Initialize an instance of `FirebaseServerApp`.
// Retrieve your own options values by adding a web app on
// https://console.firebase.google.com
initializeServerApp({
    apiKey: "AIza....",                             // Auth / General Use
    authDomain: "YOUR_APP.firebaseapp.com",         // Auth with popup/redirect
    databaseURL: "https://YOUR_APP.firebaseio.com", // Realtime Database
    storageBucket: "YOUR_APP.appspot.com",          // Storage
    messagingSenderId: "123456789"                  // Cloud Messaging
  },
  {
   authIdToken: "Your Auth ID Token"
  });

```

## SDK\_VERSION

The current SDK version.

<b>Signature:</b>

```typescript
SDK_VERSION: string
```
