Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# ActionCodeURL class
A utility class to parse email action URLs such as password reset, email verification, email link sign in, etc.

The constructor for this class is marked as internal. Third-party code should not call the constructor directly or create subclasses that extend the `ActionCodeURL` class.

<b>Signature:</b>

```typescript
export declare class ActionCodeURL 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [apiKey](./auth.actioncodeurl.md#actioncodeurlapikey) |  | string | The API key of the email action link. |
|  [code](./auth.actioncodeurl.md#actioncodeurlcode) |  | string | The action code of the email action link. |
|  [continueUrl](./auth.actioncodeurl.md#actioncodeurlcontinueurl) |  | string \| null | The continue URL of the email action link. Null if not provided. |
|  [languageCode](./auth.actioncodeurl.md#actioncodeurllanguagecode) |  | string \| null | The language code of the email action link. Null if not provided. |
|  [operation](./auth.actioncodeurl.md#actioncodeurloperation) |  | string | The action performed by the email action link. It returns from one of the types from [ActionCodeInfo](./auth.actioncodeinfo.md#actioncodeinfo_interface) |
|  [tenantId](./auth.actioncodeurl.md#actioncodeurltenantid) |  | string \| null | The tenant ID of the email action link. Null if the email action is from the parent project. |

## Methods

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [parseLink(link)](./auth.actioncodeurl.md#actioncodeurlparselink) | <code>static</code> | Parses the email action link string and returns an [ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) if the link is valid, otherwise returns null. |

## ActionCodeURL.apiKey

The API key of the email action link.

<b>Signature:</b>

```typescript
readonly apiKey: string;
```

## ActionCodeURL.code

The action code of the email action link.

<b>Signature:</b>

```typescript
readonly code: string;
```

## ActionCodeURL.continueUrl

The continue URL of the email action link. Null if not provided.

<b>Signature:</b>

```typescript
readonly continueUrl: string | null;
```

## ActionCodeURL.languageCode

The language code of the email action link. Null if not provided.

<b>Signature:</b>

```typescript
readonly languageCode: string | null;
```

## ActionCodeURL.operation

The action performed by the email action link. It returns from one of the types from [ActionCodeInfo](./auth.actioncodeinfo.md#actioncodeinfo_interface)

<b>Signature:</b>

```typescript
readonly operation: string;
```

## ActionCodeURL.tenantId

The tenant ID of the email action link. Null if the email action is from the parent project.

<b>Signature:</b>

```typescript
readonly tenantId: string | null;
```

## ActionCodeURL.parseLink()

Parses the email action link string and returns an [ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) if the link is valid, otherwise returns null.

<b>Signature:</b>

```typescript
static parseLink(link: string): ActionCodeURL | null;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  link | string | The email action link string. |

<b>Returns:</b>

[ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) \| null

The [ActionCodeURL](./auth.actioncodeurl.md#actioncodeurl_class) object, or null if the link is invalid.

