Project: /docs/reference/js/_project.yaml
Book: /docs/reference/_book.yaml
page_type: reference

{% comment %}
DO NOT EDIT THIS FILE!
This is generated by the JS SDK team, and any local changes will be
overwritten. Changes should be made in the source code at
https://github.com/firebase/firebase-js-sdk
{% endcomment %}

# Auth interface
Interface representing Firebase Auth service.

See [Firebase Authentication](https://firebase.google.com/docs/auth/) for a full guide on how to use the Firebase Auth service.

<b>Signature:</b>

```typescript
export interface Auth 
```

## Properties

|  Property | Type | Description |
|  --- | --- | --- |
|  [app](./auth.auth.md#authapp) | [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) | The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) associated with the <code>Auth</code> service instance. |
|  [config](./auth.auth.md#authconfig) | [Config](./auth.config.md#config_interface) | The [Config](./auth.config.md#config_interface) used to initialize this instance. |
|  [currentUser](./auth.auth.md#authcurrentuser) | [User](./auth.user.md#user_interface) \| null | The currently signed-in user (or null). |
|  [emulatorConfig](./auth.auth.md#authemulatorconfig) | [EmulatorConfig](./auth.emulatorconfig.md#emulatorconfig_interface) \| null | The current emulator configuration (or null). |
|  [languageCode](./auth.auth.md#authlanguagecode) | string \| null | The [Auth](./auth.auth.md#auth_interface) instance's language code. |
|  [name](./auth.auth.md#authname) | string | The name of the app associated with the <code>Auth</code> service instance. |
|  [settings](./auth.auth.md#authsettings) | [AuthSettings](./auth.authsettings.md#authsettings_interface) | The [Auth](./auth.auth.md#auth_interface) instance's settings. |
|  [tenantId](./auth.auth.md#authtenantid) | string \| null | The [Auth](./auth.auth.md#auth_interface) instance's tenant ID. |

## Methods

|  Method | Description |
|  --- | --- |
|  [authStateReady()](./auth.auth.md#authauthstateready) | returns a promise that resolves immediately when the initial auth state is settled. When the promise resolves, the current user might be a valid user or <code>null</code> if the user signed out. |
|  [beforeAuthStateChanged(callback, onAbort)](./auth.auth.md#authbeforeauthstatechanged) | Adds a blocking callback that runs before an auth state change sets a new user. |
|  [onAuthStateChanged(nextOrObserver, error, completed)](./auth.auth.md#authonauthstatechanged) | Adds an observer for changes to the user's sign-in state. |
|  [onIdTokenChanged(nextOrObserver, error, completed)](./auth.auth.md#authonidtokenchanged) | Adds an observer for changes to the signed-in user's ID token. |
|  [setPersistence(persistence)](./auth.auth.md#authsetpersistence) | Changes the type of persistence on the <code>Auth</code> instance. |
|  [signOut()](./auth.auth.md#authsignout) | Signs out the current user. This does not automatically revoke the user's ID token. |
|  [updateCurrentUser(user)](./auth.auth.md#authupdatecurrentuser) | Asynchronously sets the provided user as [Auth.currentUser](./auth.auth.md#authcurrentuser) on the [Auth](./auth.auth.md#auth_interface) instance. |
|  [useDeviceLanguage()](./auth.auth.md#authusedevicelanguage) | Sets the current language to the default device/browser preference. |

## Auth.app

The [FirebaseApp](./app.firebaseapp.md#firebaseapp_interface) associated with the `Auth` service instance.

<b>Signature:</b>

```typescript
readonly app: FirebaseApp;
```

## Auth.config

The [Config](./auth.config.md#config_interface) used to initialize this instance.

<b>Signature:</b>

```typescript
readonly config: Config;
```

## Auth.currentUser

The currently signed-in user (or null).

<b>Signature:</b>

```typescript
readonly currentUser: User | null;
```

## Auth.emulatorConfig

The current emulator configuration (or null).

<b>Signature:</b>

```typescript
readonly emulatorConfig: EmulatorConfig | null;
```

## Auth.languageCode

The [Auth](./auth.auth.md#auth_interface) instance's language code.

This is a readable/writable property. When set to null, the default Firebase Console language setting is applied. The language code will propagate to email action templates (password reset, email verification and email change revocation), SMS templates for phone authentication, reCAPTCHA verifier and OAuth popup/redirect operations provided the specified providers support localization with the language code specified.

<b>Signature:</b>

```typescript
languageCode: string | null;
```

## Auth.name

The name of the app associated with the `Auth` service instance.

<b>Signature:</b>

```typescript
readonly name: string;
```

## Auth.settings

The [Auth](./auth.auth.md#auth_interface) instance's settings.

This is used to edit/read configuration related options such as app verification mode for phone authentication.

<b>Signature:</b>

```typescript
readonly settings: AuthSettings;
```

## Auth.tenantId

The [Auth](./auth.auth.md#auth_interface) instance's tenant ID.

This is a readable/writable property. When you set the tenant ID of an [Auth](./auth.auth.md#auth_interface) instance, all future sign-in/sign-up operations will pass this tenant ID and sign in or sign up users to the specified tenant project. When set to null, users are signed in to the parent project.

<b>Signature:</b>

```typescript
tenantId: string | null;
```

### Example


```javascript
// Set the tenant ID on Auth instance.
auth.tenantId = 'TENANT_PROJECT_ID';

// All future sign-in request now include tenant ID.
const result = await signInWithEmailAndPassword(auth, email, password);
// result.user.tenantId should be 'TENANT_PROJECT_ID'.

```

## Auth.authStateReady()

returns a promise that resolves immediately when the initial auth state is settled. When the promise resolves, the current user might be a valid user or `null` if the user signed out.

<b>Signature:</b>

```typescript
authStateReady(): Promise<void>;
```
<b>Returns:</b>

Promise&lt;void&gt;

## Auth.beforeAuthStateChanged()

Adds a blocking callback that runs before an auth state change sets a new user.

<b>Signature:</b>

```typescript
beforeAuthStateChanged(callback: (user: User | null) => void | Promise<void>, onAbort?: () => void): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  callback | (user: [User](./auth.user.md#user_interface) \| null) =&gt; void \| Promise&lt;void&gt; | callback triggered before new user value is set. If this throws, it blocks the user from being set. |
|  onAbort | () =&gt; void | callback triggered if a later <code>beforeAuthStateChanged()</code> callback throws, allowing you to undo any side effects. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

## Auth.onAuthStateChanged()

Adds an observer for changes to the user's sign-in state.

To keep the old behavior, see [Auth.onIdTokenChanged()](./auth.auth.md#authonidtokenchanged)<!-- -->.

<b>Signature:</b>

```typescript
onAuthStateChanged(nextOrObserver: NextOrObserver<User | null>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  nextOrObserver | [NextOrObserver](./auth.md#nextorobserver)<!-- -->&lt;[User](./auth.user.md#user_interface) \| null&gt; | callback triggered on change. |
|  error | [ErrorFn](./util.md#errorfn) | Deprecated. This callback is never triggered. Errors on signing in/out can be caught in promises returned from sign-in/sign-out functions. |
|  completed | [CompleteFn](./util.md#completefn) | Deprecated. This callback is never triggered. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

## Auth.onIdTokenChanged()

Adds an observer for changes to the signed-in user's ID token.

This includes sign-in, sign-out, and token refresh events.

<b>Signature:</b>

```typescript
onIdTokenChanged(nextOrObserver: NextOrObserver<User | null>, error?: ErrorFn, completed?: CompleteFn): Unsubscribe;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  nextOrObserver | [NextOrObserver](./auth.md#nextorobserver)<!-- -->&lt;[User](./auth.user.md#user_interface) \| null&gt; | callback triggered on change. |
|  error | [ErrorFn](./util.md#errorfn) | Deprecated. This callback is never triggered. Errors on signing in/out can be caught in promises returned from sign-in/sign-out functions. |
|  completed | [CompleteFn](./util.md#completefn) | Deprecated. This callback is never triggered. |

<b>Returns:</b>

[Unsubscribe](./util.md#unsubscribe)

## Auth.setPersistence()

Changes the type of persistence on the `Auth` instance.

This will affect the currently saved Auth session and applies this type of persistence for future sign-in requests, including sign-in with redirect requests.

This makes it easy for a user signing in to specify whether their session should be remembered or not. It also makes it easier to never persist the Auth state for applications that are shared by other users or have sensitive data.

This method does not work in a Node.js environment.

<b>Signature:</b>

```typescript
setPersistence(persistence: Persistence): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  persistence | [Persistence](./auth.persistence.md#persistence_interface) | The [Persistence](./auth.persistence.md#persistence_interface) to use. |

<b>Returns:</b>

Promise&lt;void&gt;

### Example


```javascript
auth.setPersistence(browserSessionPersistence);

```

## Auth.signOut()

Signs out the current user. This does not automatically revoke the user's ID token.

This method is not supported by [Auth](./auth.auth.md#auth_interface) instances created with a [FirebaseServerApp](./app.firebaseserverapp.md#firebaseserverapp_interface)<!-- -->.

<b>Signature:</b>

```typescript
signOut(): Promise<void>;
```
<b>Returns:</b>

Promise&lt;void&gt;

## Auth.updateCurrentUser()

Asynchronously sets the provided user as [Auth.currentUser](./auth.auth.md#authcurrentuser) on the [Auth](./auth.auth.md#auth_interface) instance.

A new instance copy of the user provided will be made and set as currentUser.

This will trigger [Auth.onAuthStateChanged()](./auth.auth.md#authonauthstatechanged) and [Auth.onIdTokenChanged()](./auth.auth.md#authonidtokenchanged) listeners like other sign in methods.

The operation fails with an error if the user to be updated belongs to a different Firebase project.

<b>Signature:</b>

```typescript
updateCurrentUser(user: User | null): Promise<void>;
```

#### Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  user | [User](./auth.user.md#user_interface) \| null | The new [User](./auth.user.md#user_interface)<!-- -->. |

<b>Returns:</b>

Promise&lt;void&gt;

## Auth.useDeviceLanguage()

Sets the current language to the default device/browser preference.

<b>Signature:</b>

```typescript
useDeviceLanguage(): void;
```
<b>Returns:</b>

void

